/*
 * Decompiled with CFR 0.152.
 */
package com.mps.deepviolet.api.samples;

import com.mps.deepviolet.api.DVFactory;
import com.mps.deepviolet.api.IDVCipherSuite;
import com.mps.deepviolet.api.IDVEng;
import com.mps.deepviolet.api.IDVSession;
import java.net.URL;
import java.util.HashMap;

public class PrintServerCiphersuites {
    public PrintServerCiphersuites() throws Exception {
        URL url = new URL("https://github.com/");
        IDVSession session = DVFactory.initializeSession(url);
        IDVEng eng = DVFactory.getDVEng(session);
        IDVCipherSuite[] ciphers = eng.getCipherSuites();
        HashMap<IDVCipherSuite, IDVCipherSuite> tmap = new HashMap<IDVCipherSuite, IDVCipherSuite>();
        System.out.println("Ciphers supported by host " + url.toString());
        for (IDVCipherSuite cipher : ciphers) {
            if (tmap.containsKey(cipher)) continue;
            StringBuffer buff = new StringBuffer();
            buff.append(cipher.getSuiteName());
            buff.append('(');
            buff.append(cipher.getStrengthEvaluation());
            buff.append(',');
            buff.append(cipher.getHandshakeProtocol());
            buff.append(')');
            System.out.println(buff.toString());
            tmap.put(cipher, cipher);
        }
        System.out.flush();
    }

    public static final void main(String[] args) {
        try {
            new PrintServerCiphersuites();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

