/*
 * Decompiled with CFR 0.152.
 */
package com.mps.deepviolet.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mps.deepviolet.api.JsonLdrCipherMap;
import com.mps.deepviolet.api.JsonLdrMozillaCerts;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class FileUtils {
    public static final String getWorkingDirectory() {
        String OS = System.getProperty("os.name");
        String home = System.getProperty("user.home");
        StringBuffer buff = new StringBuffer();
        if (OS.contains("Linux")) {
            buff.append(home);
            buff.append(File.separator);
            buff.append("DeepViolet");
            buff.append(File.separator);
        } else if (OS.contains("Windows")) {
            buff.append(home);
            buff.append(File.separator);
            buff.append("My Documents");
            buff.append(File.separator);
            buff.append("DeepViolet");
            buff.append(File.separator);
        } else if (OS.contains("Mac")) {
            buff.append(home);
            buff.append(File.separator);
            buff.append("DeepViolet");
            buff.append(File.separator);
        } else {
            buff.append(System.getProperty("java.io.tmpdir"));
            buff.append(File.separator);
            buff.append("DeepViolet");
            buff.append(File.separator);
        }
        return buff.toString();
    }

    public static final void createWorkingDirectory() {
        String violetdir = FileUtils.getWorkingDirectory();
        File workdir = new File(violetdir);
        if (workdir.exists()) {
            return;
        }
        if (!(!workdir.exists() || workdir.canRead() && workdir.canWrite())) {
            System.err.println("Failed creating user report directory, reason=READ&WRITE required");
            System.exit(10);
        }
        if (!workdir.mkdirs()) {
            System.err.println("Can't create a working directory.  reason=File.mkdirs failed");
            System.exit(15);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getJsonResourceAsString(String name) {
        BufferedReader br = null;
        StringBuffer buff = new StringBuffer(4000);
        try {
            String sCurrentLine;
            InputStream in = FileUtils.class.getClassLoader().getResourceAsStream(name);
            br = new BufferedReader(new InputStreamReader(in));
            while ((sCurrentLine = br.readLine()) != null) {
                buff.append(sCurrentLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return buff.toString();
    }

    public static JsonLdrCipherMap readCiphermapFromJSON(String file) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonLdrCipherMap obj = (JsonLdrCipherMap)mapper.readValue(new File(file), JsonLdrCipherMap.class);
        return obj;
    }

    public static JsonLdrMozillaCerts readMozillaCertsFromJSON(String file) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonLdrMozillaCerts obj = (JsonLdrMozillaCerts)mapper.readValue(new File(file), JsonLdrMozillaCerts.class);
        return obj;
    }
}

