/*
 * Decompiled with CFR 0.152.
 */
package ch.scheitlin.alex.java;

import ch.scheitlin.alex.java.StackTrace;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StackTraceParser {
    private static String LINE_SEPARATOR_REGEX = "\\r?\\n|\\r";
    private static String STACK_TRACE_LINE_REGEX = "^\\tat (?:((?:[\\d\\w]*\\.)*[\\d\\w]*)\\/)?((?:(?:[\\d\\w]*\\.)*[\\d\\w]*))\\.([\\d\\w\\$]*)\\.([\\d\\w\\$]*)\\((?:(?:([\\d\\w]*\\.java):(\\d*))|([\\d\\w\\s]*))\\)$";
    private static Pattern STACK_TRACE_LINE_PATTERN = Pattern.compile(STACK_TRACE_LINE_REGEX);

    public static StackTrace parse(List<String> stackTraceLines) throws Exception {
        StringBuilder builder = new StringBuilder();
        for (String line : stackTraceLines) {
            builder.append(line).append(System.lineSeparator());
        }
        return StackTraceParser.parse(builder.substring(0, builder.length() - 1));
    }

    public static StackTrace parse(String stackTraceString) throws Exception {
        String[] lines = stackTraceString.split(LINE_SEPARATOR_REGEX);
        String firstLine = lines[0];
        ArrayList<StackTraceElement> stackTraceLines = new ArrayList<StackTraceElement>();
        for (int i = 1; i < lines.length; ++i) {
            Matcher matcher = STACK_TRACE_LINE_PATTERN.matcher(lines[i]);
            if (!matcher.matches()) continue;
            String moduleName = null;
            if (matcher.group(1) != null) {
                moduleName = matcher.group(1);
            }
            String packageName = matcher.group(2);
            String className = matcher.group(3);
            String methodName = matcher.group(4);
            String fileName = null;
            if (matcher.group(5) != null) {
                fileName = matcher.group(5);
            }
            int lineNumber = -1;
            if (matcher.group(6) != null) {
                lineNumber = Integer.valueOf(matcher.group(6));
            }
            if (matcher.group(7) != null && matcher.group(7).equals("Native Method")) {
                lineNumber = -2;
            }
            StackTraceElement element = new StackTraceElement((moduleName != null ? moduleName + "/" : "") + packageName + "." + className, methodName, fileName, lineNumber);
            if (!("\tat " + element.toString()).equals(lines[i])) {
                throw new Exception("ERROR: Stack trace line could not be parsed to StackTraceElement:\n\tOriginal stack trace line:\t" + lines[i] + "\n\tParsed StackTraceElement:\t\tat " + element.toString());
            }
            stackTraceLines.add(element);
        }
        return new StackTrace(firstLine, stackTraceLines);
    }
}

