/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.cli.export;

import fr.spoonlabs.flacoco.api.result.FlacocoResult;
import fr.spoonlabs.flacoco.api.result.Location;
import fr.spoonlabs.flacoco.api.result.Suspiciousness;
import fr.spoonlabs.flacoco.cli.export.FlacocoExporter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class CSVExporter
implements FlacocoExporter {
    private static final CsvPreference csvPreference = new CsvPreference.Builder(CsvPreference.STANDARD_PREFERENCE).build();

    @Override
    public void export(FlacocoResult result, OutputStreamWriter outputStream) throws IOException {
        CsvListWriter writer = new CsvListWriter((Writer)outputStream, csvPreference);
        for (Map.Entry<Location, Suspiciousness> entry : result.getDefaultSuspiciousnessMap().entrySet()) {
            writer.write(new Object[]{entry.getKey().getClassName(), entry.getKey().getLineNumber(), entry.getValue().getScore()});
        }
        writer.close();
    }

    @Override
    public String extension() {
        return "csv";
    }
}

