/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.core.config;

import fr.spoonlabs.flacoco.localization.spectrum.SpectrumFormula;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class FlacocoConfig {
    private String workspace;
    private String projectPath;
    private List<String> srcJavaDir;
    private List<String> srcTestDir;
    private List<String> binJavaDir;
    private List<String> binTestDir;
    private String classpath;
    private String customJUnitClasspath;
    private String customJacocoClasspath;
    private String mavenHome;
    private boolean coverTests;
    private boolean testRunnerVerbose;
    private int testRunnerTimeoutInMs;
    private String testRunnerJVMArgs;
    private double threshold;
    private boolean includeZeros;
    private int complianceLevel;
    private TestDetectionStrategy testDetectionStrategy;
    private Set<String> ignoredTests;
    private Set<String> jUnit4Tests;
    private Set<String> jUnit5Tests;
    private Set<String> jacocoIncludes;
    private Set<String> jacocoExcludes;
    private boolean computeSpoonResults;
    private FaultLocalizationFamily family;
    private SpectrumFormula spectrumFormula;

    public FlacocoConfig() {
        this.initDefaults();
    }

    private void initDefaults() {
        this.workspace = new File("./").getAbsolutePath();
        this.projectPath = new File("./").getAbsolutePath();
        this.classpath = "";
        this.srcJavaDir = new ArrayList<String>();
        this.srcTestDir = new ArrayList<String>();
        this.binJavaDir = new ArrayList<String>();
        this.binTestDir = new ArrayList<String>();
        this.customJUnitClasspath = null;
        this.customJacocoClasspath = null;
        this.mavenHome = System.getProperty("user.home") + "/.m2/repository/";
        this.coverTests = false;
        this.testRunnerVerbose = false;
        this.testRunnerTimeoutInMs = 1000000;
        this.testRunnerJVMArgs = null;
        this.threshold = 0.0;
        this.includeZeros = false;
        this.complianceLevel = 8;
        this.testDetectionStrategy = TestDetectionStrategy.CLASSLOADER;
        this.ignoredTests = new HashSet<String>();
        this.jUnit4Tests = new HashSet<String>();
        this.jUnit5Tests = new HashSet<String>();
        this.jacocoIncludes = new HashSet<String>();
        this.jacocoExcludes = new HashSet<String>();
        this.computeSpoonResults = false;
        this.family = FaultLocalizationFamily.SPECTRUM_BASED;
        this.spectrumFormula = SpectrumFormula.OCHIAI;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = new File(projectPath).getAbsolutePath();
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public List<String> getSrcJavaDir() {
        if (this.srcJavaDir.isEmpty()) {
            return Collections.singletonList(new File(this.getProjectPath() + File.separatorChar + "src/main/java/").getAbsolutePath());
        }
        return this.srcJavaDir;
    }

    public void setSrcJavaDir(List<String> srcJavaDir) {
        this.srcJavaDir = FlacocoConfig.listOfPathsToListOfAbsolutePaths(srcJavaDir);
    }

    public List<String> getSrcTestDir() {
        if (this.srcTestDir.isEmpty()) {
            return Collections.singletonList(new File(this.getProjectPath() + File.separatorChar + "src/test/").getAbsolutePath());
        }
        return this.srcTestDir;
    }

    public void setSrcTestDir(List<String> srcTestDir) {
        this.srcTestDir = FlacocoConfig.listOfPathsToListOfAbsolutePaths(srcTestDir);
    }

    public List<String> getBinJavaDir() {
        if (this.binJavaDir.isEmpty()) {
            return Collections.singletonList(new File(this.getProjectPath() + File.separatorChar + "target/classes/").getAbsolutePath());
        }
        return this.binJavaDir;
    }

    public void setBinJavaDir(List<String> binJavaDir) {
        this.binJavaDir = FlacocoConfig.listOfPathsToListOfAbsolutePaths(binJavaDir);
    }

    public List<String> getBinTestDir() {
        if (this.binTestDir.isEmpty()) {
            return Collections.singletonList(new File(this.getProjectPath() + File.separatorChar + "target/test-classes/").getAbsolutePath());
        }
        return this.binTestDir;
    }

    public void setBinTestDir(List<String> binTestDir) {
        this.binTestDir = FlacocoConfig.listOfPathsToListOfAbsolutePaths(binTestDir);
    }

    public String getCustomJUnitClasspath() {
        return this.customJUnitClasspath;
    }

    public void setCustomJUnitClasspath(String customJUnitClasspath) {
        this.customJUnitClasspath = customJUnitClasspath;
    }

    public String getCustomJacocoClasspath() {
        return this.customJacocoClasspath;
    }

    public void setCustomJacocoClasspath(String customJacocoClasspath) {
        this.customJacocoClasspath = customJacocoClasspath;
    }

    public String getMavenHome() {
        return this.mavenHome;
    }

    public void setMavenHome(String mavenHome) {
        this.mavenHome = new File(mavenHome).getAbsolutePath();
    }

    public boolean isCoverTests() {
        return this.coverTests;
    }

    public void setCoverTests(boolean coverTests) {
        this.coverTests = coverTests;
    }

    public boolean isTestRunnerVerbose() {
        return this.testRunnerVerbose;
    }

    public void setTestRunnerVerbose(boolean testRunnerVerbose) {
        this.testRunnerVerbose = testRunnerVerbose;
    }

    public int getTestRunnerTimeoutInMs() {
        return this.testRunnerTimeoutInMs;
    }

    public void setTestRunnerTimeoutInMs(int testRunnerTimeoutInMs) {
        this.testRunnerTimeoutInMs = testRunnerTimeoutInMs;
    }

    public String getTestRunnerJVMArgs() {
        return this.testRunnerJVMArgs;
    }

    public void setTestRunnerJVMArgs(String testRunnerJVMArgs) {
        this.testRunnerJVMArgs = testRunnerJVMArgs;
    }

    public TestDetectionStrategy getTestDetectionStrategy() {
        return this.testDetectionStrategy;
    }

    public void setTestDetectionStrategy(TestDetectionStrategy testDetectionStrategy) {
        this.testDetectionStrategy = testDetectionStrategy;
    }

    public Set<String> getIgnoredTests() {
        return this.ignoredTests;
    }

    public void setIgnoredTests(Set<String> ignoredTests) {
        this.ignoredTests = ignoredTests;
    }

    public Set<String> getjUnit4Tests() {
        return this.jUnit4Tests;
    }

    public void setjUnit4Tests(Set<String> jUnit4Tests) {
        this.jUnit4Tests = jUnit4Tests;
    }

    public Set<String> getjUnit5Tests() {
        return this.jUnit5Tests;
    }

    public void setjUnit5Tests(Set<String> jUnit5Tests) {
        this.jUnit5Tests = jUnit5Tests;
    }

    public Set<String> getJacocoIncludes() {
        return this.jacocoIncludes;
    }

    public void setJacocoIncludes(Set<String> jacocoIncludes) {
        this.jacocoIncludes = jacocoIncludes;
    }

    public Set<String> getJacocoExcludes() {
        return this.jacocoExcludes;
    }

    public void setJacocoExcludes(Set<String> jacocoExcludes) {
        this.jacocoExcludes = jacocoExcludes;
    }

    public FaultLocalizationFamily getFamily() {
        return this.family;
    }

    public void setFamily(FaultLocalizationFamily family) {
        this.family = family;
    }

    public SpectrumFormula getSpectrumFormula() {
        return this.spectrumFormula;
    }

    public void setSpectrumFormula(SpectrumFormula spectrumFormula) {
        this.spectrumFormula = spectrumFormula;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public boolean isIncludeZeros() {
        return this.includeZeros;
    }

    public void setIncludeZeros(boolean includeZeros) {
        this.includeZeros = includeZeros;
    }

    public int getComplianceLevel() {
        return this.complianceLevel;
    }

    public void setComplianceLevel(int complianceLevel) {
        this.complianceLevel = complianceLevel;
    }

    public boolean isComputeSpoonResults() {
        return this.computeSpoonResults;
    }

    public void setComputeSpoonResults(boolean computeSpoonResults) {
        this.computeSpoonResults = computeSpoonResults;
    }

    public String toString() {
        return "FlacocoConfig{workspace='" + this.workspace + '\'' + ", projectPath='" + this.projectPath + '\'' + ", srcJavaDir=" + this.getSrcJavaDir() + ", srcTestDir=" + this.getSrcTestDir() + ", binJavaDir=" + this.getBinJavaDir() + ", binTestDir=" + this.getBinTestDir() + ", classpath='" + this.classpath + '\'' + ", customJUnitClasspath='" + this.customJUnitClasspath + '\'' + ", customJacocoClasspath='" + this.customJacocoClasspath + '\'' + ", mavenHome='" + this.mavenHome + '\'' + ", coverTests=" + this.coverTests + ", testRunnerVerbose=" + this.testRunnerVerbose + ", testRunnerTimeoutInMs=" + this.testRunnerTimeoutInMs + ", testRunnerJVMArgs='" + this.testRunnerJVMArgs + '\'' + ", threshold=" + this.threshold + ", includeZeros=" + this.includeZeros + ", complianceLevel=" + this.complianceLevel + ", testDetectionStrategy=" + (Object)((Object)this.testDetectionStrategy) + ", ignoredTests=" + this.ignoredTests + ", jUnit4Tests=" + this.jUnit4Tests + ", jUnit5Tests=" + this.jUnit5Tests + ", jacocoIncludes=" + this.jacocoIncludes + ", jacocoExcludes=" + this.jacocoExcludes + ", family=" + (Object)((Object)this.family) + ", spectrumFormula=" + (Object)((Object)this.spectrumFormula) + ", computeSpoonResults=" + this.computeSpoonResults + '}';
    }

    private static List<String> listOfPathsToListOfAbsolutePaths(List<String> paths) {
        return paths.stream().map(x -> new File((String)x).getAbsolutePath()).collect(Collectors.toList());
    }

    public static enum TestDetectionStrategy {
        TEST_RUNNER,
        CLASSLOADER;

    }

    public static enum FaultLocalizationFamily {
        SPECTRUM_BASED;

    }
}

