/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.core.coverage;

import ch.scheitlin.alex.java.StackTrace;
import ch.scheitlin.alex.java.StackTraceParser;
import eu.stamp_project.testrunner.listener.CoveredTestResultPerTestMethod;
import eu.stamp_project.testrunner.listener.impl.CoverageDetailed;
import eu.stamp_project.testrunner.listener.impl.CoverageFromClass;
import fr.spoonlabs.flacoco.api.result.Location;
import fr.spoonlabs.flacoco.core.config.FlacocoConfig;
import fr.spoonlabs.flacoco.core.coverage.CoverageFromSingleTestUnit;
import fr.spoonlabs.flacoco.core.test.method.TestMethod;
import fr.spoonlabs.flacoco.utils.spoon.SpoonBlockInspector;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.api.testset.TestListResolver;
import org.jacoco.core.runtime.WildcardMatcher;

public class CoverageMatrix {
    private Logger logger = Logger.getLogger(CoverageMatrix.class);
    private FlacocoConfig config;
    protected Map<Location, Set<TestMethod>> resultExecution = new HashMap<Location, Set<TestMethod>>();
    protected Map<TestMethod, Boolean> tests = new HashMap<TestMethod, Boolean>();

    public CoverageMatrix(FlacocoConfig config) {
        this.config = config;
    }

    public void processSingleTest(CoverageFromSingleTestUnit iCovWrapper, Set<String> testClasses) {
        CoverageDetailed covLine = iCovWrapper.getCov();
        if (iCovWrapper.isSkip()) {
            this.logger.debug((Object)("Ignoring skipped test: " + iCovWrapper.getTestMethod().getFullyQualifiedMethodName()));
            return;
        }
        boolean isPassing = iCovWrapper.isPassing();
        for (String iClassNameCovered : covLine.getDetailedCoverage().keySet()) {
            String className = iClassNameCovered.replace("/", ".");
            if (!this.config.isCoverTests() && testClasses.contains(className)) continue;
            CoverageFromClass lines = (CoverageFromClass)covLine.getDetailedCoverage().get((Object)iClassNameCovered);
            Iterator iterator = lines.getCov().keySet().iterator();
            while (iterator.hasNext()) {
                int iLineNumber = (Integer)iterator.next();
                int instExecutedAtLineI = (Integer)lines.getCov().get(iLineNumber);
                this.add(new Location(className, iLineNumber), iCovWrapper.getTestMethod(), instExecutedAtLineI, isPassing);
            }
        }
        CoveredTestResultPerTestMethod result = iCovWrapper.getCoveredTestResultPerTestMethod();
        TestMethod testMethod = iCovWrapper.getTestMethod();
        if (!isPassing && result.getFailureOf(testMethod.getFullyQualifiedMethodName()) != null) {
            try {
                StackTrace trace = StackTraceParser.parse(result.getFailureOf((String)testMethod.getFullyQualifiedMethodName()).stackTrace);
                for (StackTraceElement element : trace.getStackTraceLines()) {
                    if (element.isNativeMethod() || !this.classToInclude(element.getClassName()) || !this.config.isCoverTests() && testClasses.contains(element.getClassName())) continue;
                    Location location = new Location(element.getClassName(), element.getLineNumber());
                    this.logger.debug((Object)("Adding a line where an exception was thrown: " + location));
                    this.add(location, testMethod, 1, false);
                    SpoonBlockInspector blockMatcher = new SpoonBlockInspector(this.config);
                    List<Location> locations = blockMatcher.getBlockLocations(element);
                    for (Location blockLocation : locations) {
                        this.logger.debug((Object)("Adding a line from the block where an exception was thrown: " + blockLocation));
                        this.add(blockLocation, testMethod, 1, false);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Map<Location, Set<TestMethod>> getResultExecution() {
        return this.resultExecution;
    }

    public Map<TestMethod, Boolean> getTests() {
        return this.tests;
    }

    public Set<TestMethod> getFailingTestCases() {
        return this.tests.entrySet().stream().filter(x -> (Boolean)x.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public void add(Location location, TestMethod testMethod, int instExecutedAtLineI, Boolean testResult) {
        if (instExecutedAtLineI > 0) {
            Set<Object> currentExecution;
            if (this.resultExecution.containsKey(location)) {
                currentExecution = this.resultExecution.get(location);
            } else {
                currentExecution = new HashSet();
                this.resultExecution.put(location, currentExecution);
            }
            currentExecution.add(testMethod);
        }
        this.tests.put(testMethod, testResult);
    }

    private boolean classToInclude(String className) {
        DirectoryScanner directoryScanner;
        WildcardMatcher matcher;
        for (String pattern : this.config.getJacocoExcludes()) {
            matcher = new WildcardMatcher(pattern);
            if (!matcher.matches(className)) continue;
            return false;
        }
        for (String pattern : this.config.getJacocoIncludes()) {
            matcher = new WildcardMatcher(pattern);
            if (!matcher.matches(className)) continue;
            return true;
        }
        for (String dir : this.config.getBinJavaDir()) {
            directoryScanner = new DirectoryScanner(new File(dir), TestListResolver.getWildcard());
            if (!directoryScanner.scan().getClasses().contains(className)) continue;
            return true;
        }
        for (String dir : this.config.getBinTestDir()) {
            directoryScanner = new DirectoryScanner(new File(dir), TestListResolver.getWildcard());
            if (!directoryScanner.scan().getClasses().contains(className)) continue;
            return true;
        }
        return false;
    }
}

