/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.core.coverage.framework;

import eu.stamp_project.testrunner.EntryPoint;
import eu.stamp_project.testrunner.listener.CoveredTestResultPerTestMethod;
import eu.stamp_project.testrunner.runner.ParserOptions;
import fr.spoonlabs.flacoco.core.config.FlacocoConfig;
import fr.spoonlabs.flacoco.core.test.TestContext;
import java.io.File;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.apache.maven.plugin.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.api.testset.TestListResolver;

public abstract class TestFrameworkStrategy {
    private static final Logger logger = Logger.getLogger(TestFrameworkStrategy.class);
    protected FlacocoConfig config;

    public TestFrameworkStrategy(FlacocoConfig flacocoConfig) {
        this.config = flacocoConfig;
    }

    public abstract CoveredTestResultPerTestMethod execute(TestContext var1) throws TimeoutException;

    protected void setupTestRunnerEntryPoint() {
        EntryPoint.coverageDetail = ParserOptions.CoverageTransformerDetail.DETAIL_COMPRESSED;
        EntryPoint.workingDirectory = new File(this.config.getWorkspace());
        EntryPoint.verbose = this.config.isTestRunnerVerbose();
        EntryPoint.timeoutInMs = this.config.getTestRunnerTimeoutInMs();
        EntryPoint.JVMArgs = this.config.getTestRunnerJVMArgs();
        EntryPoint.jUnit5Mode = false;
        EntryPoint.jacocoAgentIncludes = !this.config.getJacocoIncludes().isEmpty() ? this.config.getJacocoIncludes().stream().reduce((x, y) -> x + ":" + y).orElse("") : this.computeJacocoIncludes();
        if (!this.config.getJacocoIncludes().isEmpty()) {
            EntryPoint.jacocoAgentExcludes = this.config.getJacocoExcludes().stream().reduce((x, y) -> x + ":" + y).orElse("");
        }
    }

    protected String computeClasspath() {
        String classpath = this.config.getClasspath() + File.pathSeparatorChar + this.config.getBinJavaDir().stream().reduce((x, y) -> x + File.pathSeparatorChar + y).orElse("") + File.pathSeparatorChar + this.config.getBinTestDir().stream().reduce((x, y) -> x + File.pathSeparatorChar + y).orElse("");
        String mavenHome = this.config.getMavenHome();
        String junitClasspath = mavenHome + "junit/junit/4.13.2/junit-4.13.2.jar" + File.pathSeparatorChar + mavenHome + "org/hamcrest/hamcrest-core/1.3/hamcrest-core-1.3.jar" + File.pathSeparatorChar + mavenHome + "org/junit/jupiter/junit-jupiter-api/5.3.2/junit-jupiter-api-5.3.2.jar" + File.pathSeparatorChar + mavenHome + "org/apiguardian/apiguardian-api/1.0.0/apiguardian-api-1.0.0.jar" + File.pathSeparatorChar + mavenHome + "org/opentest4j/opentest4j/1.1.1/opentest4j-1.1.1.jar" + File.pathSeparatorChar + mavenHome + "org/junit/platform/junit-platform-commons/1.3.2/junit-platform-commons-1.3.2.jar" + File.pathSeparatorChar + mavenHome + "org/junit/jupiter/junit-jupiter-engine/5.3.2/junit-jupiter-engine-5.3.2.jar" + File.pathSeparatorChar + mavenHome + "org/junit/jupiter/junit-jupiter-params/5.3.2/junit-jupiter-params-5.3.2.jar" + File.pathSeparatorChar + mavenHome + "org/junit/platform/junit-platform-engine/1.3.2/junit-platform-engine-1.3.2.jar" + File.pathSeparatorChar + mavenHome + "org/junit/platform/junit-platform-launcher/1.3.2/junit-platform-launcher-1.3.2.jar";
        String jacocoClassPath = mavenHome + "org/jacoco/org.jacoco.core/0.8.7/org.jacoco.core-0.8.7.jar";
        if (this.config.getCustomJUnitClasspath() != null) {
            junitClasspath = this.config.getCustomJUnitClasspath();
        }
        if (this.config.getCustomJacocoClasspath() != null) {
            jacocoClassPath = this.config.getCustomJacocoClasspath();
        }
        return junitClasspath + File.pathSeparatorChar + jacocoClassPath + File.pathSeparatorChar + classpath + File.pathSeparatorChar;
    }

    protected String computeJacocoIncludes() {
        DirectoryScanner directoryScanner;
        StringBuilder includes = new StringBuilder();
        for (String directory : this.config.getBinJavaDir()) {
            directoryScanner = new DirectoryScanner(new File(directory), TestListResolver.getWildcard());
            includes.append(":").append(directoryScanner.scan().getClasses().stream().reduce((x, y) -> x + ":" + y).orElse(""));
        }
        if (this.config.isCoverTests()) {
            for (String directory : this.config.getBinTestDir()) {
                directoryScanner = new DirectoryScanner(new File(directory), TestListResolver.getWildcard());
                includes.append(":").append(directoryScanner.scan().getClasses().stream().reduce((x, y) -> x + ":" + y).orElse(""));
            }
        }
        return includes.toString();
    }
}

