/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.core.test.method;

import fr.spoonlabs.flacoco.core.test.method.TestMethod;
import java.util.Objects;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;

public class SpoonTestMethod
implements TestMethod {
    private CtType<?> testClassModel;
    private String fullyQualifiedClassName;
    private CtMethod<?> testMethodModel;
    private String fullyQualifiedMethodName;

    public SpoonTestMethod(CtType<?> testClassModel, CtMethod<?> testMethodModel) {
        this.testClassModel = testClassModel;
        this.testMethodModel = testMethodModel;
        this.fullyQualifiedClassName = testClassModel.getQualifiedName();
        this.fullyQualifiedMethodName = this.fullyQualifiedClassName + "#" + testMethodModel.getSimpleName();
    }

    public CtType<?> getTestClassModel() {
        return this.testClassModel;
    }

    public CtMethod<?> getTestMethodModel() {
        return this.testMethodModel;
    }

    @Override
    public String getFullyQualifiedClassName() {
        return this.fullyQualifiedClassName;
    }

    @Override
    public String getFullyQualifiedMethodName() {
        return this.fullyQualifiedMethodName;
    }

    public String toString() {
        return "[Spoon]TestMethod=" + this.getFullyQualifiedMethodName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass().getSuperclass() != o.getClass().getSuperclass()) {
            return false;
        }
        TestMethod that = (TestMethod)o;
        return Objects.equals(this.getFullyQualifiedMethodName(), that.getFullyQualifiedMethodName());
    }

    public int hashCode() {
        return Objects.hash(this.getFullyQualifiedMethodName());
    }
}

