/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.core.test.strategies.classloader.finder.filters;

import fr.spoonlabs.flacoco.core.test.method.StringTestMethod;
import fr.spoonlabs.flacoco.core.test.method.TestMethod;
import fr.spoonlabs.flacoco.core.test.strategies.classloader.finder.filters.TestType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.junit.Test;

public class TestMethodFilter {
    private static final Logger logger = Logger.getLogger(TestMethodFilter.class);
    private final EnumSet<TestType> testTypes;
    private final Set<String> ignoredTests;

    public TestMethodFilter(EnumSet<TestType> testTypes, Set<String> ignoredTests) {
        this.testTypes = testTypes;
        this.ignoredTests = ignoredTests;
    }

    public List<TestMethod> acceptClass(Class<?> clazz) {
        ArrayList<TestMethod> testMethods = new ArrayList<TestMethod>();
        if (this.isAbstractClass(clazz) || this.isIgnoredClass(clazz)) {
            return testMethods;
        }
        if (this.isInSuiteTypes(TestType.JUNIT5_TEST)) {
            testMethods.addAll(this.acceptJUnit5Test(clazz));
        }
        if (this.isInSuiteTypes(TestType.JUNIT4_TEST)) {
            testMethods.addAll(this.acceptJUnit4Test(clazz));
        }
        if (this.isInSuiteTypes(TestType.JUNIT3_TEST)) {
            testMethods.addAll(this.acceptJUnit3Test(clazz));
        }
        return testMethods;
    }

    private List<TestMethod> acceptJUnit3Test(Class<?> clazz) {
        ArrayList<TestMethod> testMethods = new ArrayList<TestMethod>();
        try {
            if (this.isPublicClass(clazz) && TestCase.class.isAssignableFrom(clazz)) {
                for (Method method : clazz.getMethods()) {
                    if (!this.isPublicMethod(method) || this.isStaticMethod(method) || method.getReturnType() != Void.TYPE || !method.getName().startsWith("test") || this.isIgnoredMethod(clazz, method)) continue;
                    testMethods.add(new StringTestMethod(clazz.getCanonicalName(), method.getName()));
                }
            }
        }
        catch (NoClassDefFoundError ignore) {
            logger.warn((Object)("NoClassDefFoundError: " + clazz));
        }
        return testMethods;
    }

    private List<TestMethod> acceptJUnit4Test(Class<?> clazz) {
        ArrayList<TestMethod> testMethods = new ArrayList<TestMethod>();
        try {
            for (Method method : clazz.getMethods()) {
                if (method.getAnnotation(Test.class) == null || this.isIgnoredMethod(clazz, method)) continue;
                testMethods.add(new StringTestMethod(clazz.getCanonicalName(), method.getName()));
            }
        }
        catch (NoClassDefFoundError ignore) {
            logger.warn((Object)("NoClassDefFoundError: " + clazz));
        }
        return testMethods;
    }

    private List<TestMethod> acceptJUnit5Test(Class<?> clazz) {
        ArrayList<TestMethod> testMethods = new ArrayList<TestMethod>();
        try {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.getAnnotation(org.junit.jupiter.api.Test.class) == null || this.isPrivateMethod(method) || this.isIgnoredMethod(clazz, method)) continue;
                testMethods.add(new StringTestMethod(clazz.getCanonicalName(), method.getName()));
            }
        }
        catch (NoClassDefFoundError ignore) {
            logger.warn((Object)("NoClassDefFoundError: " + clazz));
        }
        return testMethods;
    }

    private boolean isAbstractClass(Class<?> clazz) {
        return (clazz.getModifiers() & 0x400) != 0;
    }

    private boolean isPublicClass(Class<?> clazz) {
        return (clazz.getModifiers() & 1) != 0;
    }

    private boolean isIgnoredClass(Class<?> clazz) {
        return this.ignoredTests.contains(clazz.getCanonicalName());
    }

    private boolean isIgnoredMethod(Class<?> clazz, Method method) {
        return this.ignoredTests.contains(clazz.getCanonicalName() + "#" + method.getName());
    }

    private boolean isPublicMethod(Method method) {
        return (method.getModifiers() & 1) != 0;
    }

    private boolean isPrivateMethod(Method method) {
        return (method.getModifiers() & 2) != 0;
    }

    private boolean isStaticMethod(Method method) {
        return (method.getModifiers() & 8) != 0;
    }

    private boolean isInSuiteTypes(TestType testType) {
        return this.testTypes.contains((Object)testType);
    }
}

