/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.core.test.strategies.testrunner;

import eu.stamp_project.testrunner.test_framework.TestFramework;
import fr.spoonlabs.flacoco.core.config.FlacocoConfig;
import fr.spoonlabs.flacoco.core.coverage.framework.JUnit4Strategy;
import fr.spoonlabs.flacoco.core.coverage.framework.JUnit5Strategy;
import fr.spoonlabs.flacoco.core.test.TestContext;
import fr.spoonlabs.flacoco.core.test.TestDetector;
import fr.spoonlabs.flacoco.core.test.method.SpoonTestMethod;
import fr.spoonlabs.flacoco.core.test.strategies.TestDetectionStrategy;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import spoon.Launcher;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;

public class TestRunnerStrategy
implements TestDetectionStrategy {
    private Logger logger = Logger.getLogger(TestRunnerStrategy.class);
    private FlacocoConfig config;

    public TestRunnerStrategy(FlacocoConfig config) {
        this.config = config;
    }

    @Override
    public List<TestContext> findTests() {
        Launcher launcher = new Launcher();
        for (String dir : this.config.getSrcTestDir()) {
            launcher.addInputResource(dir);
        }
        launcher.getEnvironment().setComplianceLevel(this.config.getComplianceLevel());
        launcher.buildModel();
        TestFramework.init((Factory)launcher.getFactory());
        TestContext jUnit4Context = new TestContext(new JUnit4Strategy(this.config));
        TestContext jUnit5Context = new TestContext(new JUnit5Strategy(this.config));
        for (CtType ctType : TestFramework.getAllTestClasses()) {
            if (ctType.isAbstract()) continue;
            if (ctType.getPackage().isUnnamedPackage()) {
                this.logger.warn((Object)("TestDetector was not able to retrieve the fully qualified class name of : " + ctType.getQualifiedName()));
                continue;
            }
            jUnit4Context.addTestMethods(TestFramework.getAllTest((CtType)ctType).stream().filter(TestFramework::isJUnit4).map(ctMethod -> new SpoonTestMethod((CtType<?>)ctType, (CtMethod<?>)ctMethod)).filter(x -> !TestDetector.isIgnored(x, this.config.getIgnoredTests())).collect(Collectors.toList()));
            jUnit5Context.addTestMethods(TestFramework.getAllTest((CtType)ctType).stream().filter(TestFramework::isJUnit5).map(ctMethod -> new SpoonTestMethod((CtType<?>)ctType, (CtMethod<?>)ctMethod)).filter(x -> !TestDetector.isIgnored(x, this.config.getIgnoredTests())).collect(Collectors.toList()));
        }
        return Stream.of(jUnit4Context, jUnit5Context).filter(x -> !x.getTestMethods().isEmpty()).collect(Collectors.toList());
    }
}

