/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.localization.spectrum;

import fr.spoonlabs.flacoco.api.result.FlacocoResult;
import fr.spoonlabs.flacoco.api.result.Location;
import fr.spoonlabs.flacoco.api.result.Suspiciousness;
import fr.spoonlabs.flacoco.core.config.FlacocoConfig;
import fr.spoonlabs.flacoco.core.coverage.CoverageMatrix;
import fr.spoonlabs.flacoco.core.coverage.CoverageRunner;
import fr.spoonlabs.flacoco.core.test.TestContext;
import fr.spoonlabs.flacoco.core.test.TestDetector;
import fr.spoonlabs.flacoco.localization.FaultLocalizationRunner;
import fr.spoonlabs.flacoco.localization.spectrum.SpectrumSuspiciousComputation;
import fr.spoonlabs.flacoco.utils.spoon.SpoonConverter;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SpectrumRunner
implements FaultLocalizationRunner {
    private Logger logger = Logger.getLogger(SpectrumRunner.class);
    private FlacocoConfig config;

    public SpectrumRunner(FlacocoConfig config) {
        this.config = config;
    }

    @Override
    public FlacocoResult run() {
        FlacocoResult result = new FlacocoResult();
        CoverageMatrix coverageMatrix = this.computeCoverageMatrix();
        result.setFailingTests(coverageMatrix.getFailingTestCases());
        SpectrumSuspiciousComputation ssc = new SpectrumSuspiciousComputation(this.config);
        Map<Location, Suspiciousness> defaultMapping = ssc.calculateSuspicious(coverageMatrix, this.config.getSpectrumFormula().getFormula());
        result.setDefaultSuspiciousnessMap(defaultMapping);
        if (this.config.isComputeSpoonResults()) {
            result = new SpoonConverter(this.config).convertResult(result);
        }
        return result;
    }

    private CoverageMatrix computeCoverageMatrix() {
        this.logger.debug((Object)"Running spectrum-based fault localization...");
        this.logger.debug((Object)this.config);
        TestDetector testDetector = new TestDetector(this.config);
        List<TestContext> tests = testDetector.getTests();
        CoverageRunner detector = new CoverageRunner(this.config);
        return detector.getCoverageMatrix(tests);
    }
}

