/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.utils.spoon;

import fr.spoonlabs.flacoco.api.result.Location;
import fr.spoonlabs.flacoco.core.config.FlacocoConfig;
import fr.spoonlabs.flacoco.utils.spoon.SpoonBlockLocationsFinder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import spoon.Launcher;
import spoon.processing.Processor;
import spoon.reflect.code.CtStatement;

public class SpoonBlockInspector {
    private static final Logger logger = Logger.getLogger(SpoonBlockInspector.class);
    private FlacocoConfig config;

    public SpoonBlockInspector(FlacocoConfig config) {
        this.config = config;
    }

    public List<Location> getBlockLocations(StackTraceElement element) {
        String path = element.getClassName().replace(".", "/") + ".java";
        for (String dir : this.config.getSrcJavaDir()) {
            if (!new File(new File(dir), path).exists()) continue;
            path = new File(new File(dir), path).getAbsolutePath();
            break;
        }
        if (!new File(path).exists()) {
            logger.debug((Object)("No source code file was found for stack-trace element: " + element));
            return new ArrayList<Location>();
        }
        Launcher launcher = new Launcher();
        launcher.addInputResource(path);
        launcher.buildModel();
        launcher.addProcessor((Processor)new SpoonBlockLocationsFinder());
        SpoonBlockLocationsFinder.fullyQualifiedClassName = element.getClassName();
        SpoonBlockLocationsFinder.lineNumber = element.getLineNumber();
        SpoonBlockLocationsFinder.found = null;
        launcher.process();
        if (SpoonBlockLocationsFinder.found == null) {
            logger.debug((Object)("No block was found for stack-trace element: " + element));
            return new ArrayList<Location>();
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        for (CtStatement ctStatement : SpoonBlockLocationsFinder.found.getStatements()) {
            if (ctStatement.getPosition().getLine() > element.getLineNumber()) continue;
            locations.add(new Location(element.getClassName(), ctStatement.getPosition().getLine()));
        }
        SpoonBlockLocationsFinder.found = null;
        return locations;
    }
}

