/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.utils.spoon;

import fr.spoonlabs.flacoco.utils.spoon.SpoonBlockFilter;
import java.util.List;
import org.apache.log4j.Logger;
import spoon.processing.AbstractProcessor;
import spoon.reflect.code.CtBlock;
import spoon.reflect.cu.SourcePosition;
import spoon.reflect.declaration.CtType;
import spoon.reflect.visitor.Filter;

public class SpoonBlockLocationsFinder
extends AbstractProcessor<CtType<?>> {
    private static final Logger logger = Logger.getLogger(SpoonBlockLocationsFinder.class);
    public static String fullyQualifiedClassName;
    public static int lineNumber;
    public static CtBlock<?> found;

    public boolean isToBeProcessed(CtType<?> candidate) {
        return candidate.getQualifiedName().equals(fullyQualifiedClassName);
    }

    public void process(CtType<?> ctType) {
        List result = ctType.filterChildren((Filter)new SpoonBlockFilter(lineNumber)).list();
        CtBlock bestFit = null;
        SourcePosition curPos = null;
        for (CtBlock ctBlock : result) {
            SourcePosition pos = ctBlock.getPosition();
            if (bestFit == null || curPos == null) {
                bestFit = ctBlock;
                curPos = pos;
                continue;
            }
            int curStart = curPos.getLine();
            int start = pos.getLine();
            int curEnd = curPos.getEndLine();
            int end = pos.getEndLine();
            if (curStart < start) {
                bestFit = ctBlock;
                curPos = pos;
                continue;
            }
            if (curStart == lineNumber && curEnd == lineNumber && start == lineNumber && end == lineNumber) {
                if (curPos.getSourceStart() < pos.getSourceStart() || pos.getSourceEnd() < curPos.getSourceEnd() || curPos.getSourceStart() + curPos.getSourceEnd() == pos.getSourceStart() + pos.getSourceEnd()) continue;
                bestFit = ctBlock;
                curPos = pos;
                continue;
            }
            if (end >= curEnd) continue;
            bestFit = ctBlock;
            curPos = pos;
        }
        found = bestFit;
    }
}

