/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.utils.spoon;

import fr.spoonlabs.flacoco.api.result.FlacocoResult;
import fr.spoonlabs.flacoco.api.result.Location;
import fr.spoonlabs.flacoco.api.result.Suspiciousness;
import fr.spoonlabs.flacoco.core.config.FlacocoConfig;
import fr.spoonlabs.flacoco.utils.spoon.SpoonLocalizedFaultFinder;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import spoon.Launcher;
import spoon.processing.Processor;
import spoon.reflect.code.CtStatement;

public class SpoonConverter {
    private static Logger logger = Logger.getLogger(SpoonConverter.class);
    private FlacocoConfig config;

    public SpoonConverter(FlacocoConfig config) {
        this.config = config;
    }

    public FlacocoResult convertResult(FlacocoResult flacocoResult) {
        logger.debug((Object)"Converting results to Spoon format...");
        Launcher launcher = new Launcher();
        for (String dir : this.config.getSrcJavaDir()) {
            launcher.addInputResource(dir);
        }
        for (String dir : this.config.getSrcTestDir()) {
            launcher.addInputResource(dir);
        }
        launcher.buildModel();
        launcher.addProcessor((Processor)new SpoonLocalizedFaultFinder());
        HashMap<CtStatement, Suspiciousness> result = new HashMap<CtStatement, Suspiciousness>();
        HashMap<Location, CtStatement> mapping = new HashMap<Location, CtStatement>();
        Map<Location, Suspiciousness> original = flacocoResult.getDefaultSuspiciousnessMap();
        for (Location location : original.keySet()) {
            SpoonLocalizedFaultFinder.fullyQualifiedClassName = location.getClassName();
            SpoonLocalizedFaultFinder.lineNumber = location.getLineNumber();
            SpoonLocalizedFaultFinder.found = null;
            launcher.process();
            if (SpoonLocalizedFaultFinder.found == null) {
                logger.debug((Object)("Spoon found no CtStatement for the location " + SpoonLocalizedFaultFinder.fullyQualifiedClassName + ":" + SpoonLocalizedFaultFinder.lineNumber));
                continue;
            }
            if (result.containsKey(SpoonLocalizedFaultFinder.found) && !((Suspiciousness)result.get(SpoonLocalizedFaultFinder.found)).equals(original.get(location))) {
                logger.debug((Object)("Converting [" + location + "] to [" + SpoonLocalizedFaultFinder.found + "] resulted in a duplicate key with different suspiciouness values. Please report this to the developers of Flacoco on https://github.com/SpoonLabs/flacoco"));
            }
            result.put(SpoonLocalizedFaultFinder.found, original.get(location));
            mapping.put(location, SpoonLocalizedFaultFinder.found);
            SpoonLocalizedFaultFinder.found = null;
        }
        flacocoResult.setSpoonSuspiciousnessMap(result);
        flacocoResult.setLocationStatementMap(mapping);
        return flacocoResult;
    }
}

