/*
 * Decompiled with CFR 0.152.
 */
package ch.scheitlin.alex.java;

import java.util.ArrayList;
import java.util.List;

public class StackTrace {
    private String firstLine;
    private List<StackTraceElement> stackTraceLines;

    public StackTrace(String firstLine, List<StackTraceElement> stackTraceLines) {
        this.firstLine = firstLine;
        this.stackTraceLines = stackTraceLines;
    }

    public String getFirstLine() {
        return this.firstLine;
    }

    public List<StackTraceElement> getStackTraceLines() {
        return this.stackTraceLines;
    }

    public String getOriginalStackTrace() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.firstLine).append(System.lineSeparator());
        for (StackTraceElement element : this.stackTraceLines) {
            builder.append("\tat ").append(element).append(System.lineSeparator());
        }
        return builder.substring(0, builder.length() - 1);
    }

    public List<StackTraceElement> getLinesOfPackage(String packageName) {
        ArrayList<StackTraceElement> linesOfPackage = new ArrayList<StackTraceElement>();
        for (StackTraceElement line : this.stackTraceLines) {
            if (!line.toString().startsWith(packageName)) continue;
            linesOfPackage.add(line);
        }
        return linesOfPackage;
    }
}

