/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.core.coverage;

import eu.stamp_project.testrunner.listener.CoveredTestResultPerTestMethod;
import eu.stamp_project.testrunner.listener.impl.CoverageDetailed;
import fr.spoonlabs.flacoco.core.test.method.TestMethod;

public class CoverageFromSingleTestUnit {
    protected TestMethod testMethod;
    protected CoveredTestResultPerTestMethod coveredTestResultPerTestMethod;
    protected boolean isPassing;
    protected boolean isSkip;

    public CoverageFromSingleTestUnit(TestMethod testMethod, CoveredTestResultPerTestMethod result) {
        this.testMethod = testMethod;
        this.coveredTestResultPerTestMethod = result;
        this.isPassing = result.getPassingTests().contains(testMethod.getFullyQualifiedMethodName());
        this.isSkip = result.getIgnoredTests().contains(testMethod.getFullyQualifiedMethodName());
    }

    public TestMethod getTestMethod() {
        return this.testMethod;
    }

    public CoverageDetailed getCov() {
        return (CoverageDetailed)this.coveredTestResultPerTestMethod.getCoverageOf(this.testMethod.getFullyQualifiedMethodName());
    }

    public CoveredTestResultPerTestMethod getCoveredTestResultPerTestMethod() {
        return this.coveredTestResultPerTestMethod;
    }

    public boolean isPassing() {
        return this.isPassing;
    }

    public boolean isSkip() {
        return this.isSkip;
    }

    public String toString() {
        return "CoverageFromSingleTestUnit{testMethod=" + this.testMethod + ", cov=" + this.getCov() + ", passing=" + this.isPassing() + ", skip=" + this.isSkip() + '}';
    }
}

