/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.core.coverage;

import eu.stamp_project.testrunner.listener.CoveredTestResultPerTestMethod;
import fr.spoonlabs.flacoco.core.config.FlacocoConfig;
import fr.spoonlabs.flacoco.core.coverage.CoverageFromSingleTestUnit;
import fr.spoonlabs.flacoco.core.coverage.CoverageMatrix;
import fr.spoonlabs.flacoco.core.test.TestContext;
import fr.spoonlabs.flacoco.core.test.method.TestMethod;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class CoverageRunner {
    private Logger logger = Logger.getLogger(CoverageRunner.class);
    private FlacocoConfig config;

    public CoverageRunner(FlacocoConfig config) {
        this.config = config;
    }

    public CoverageMatrix getCoverageMatrix(List<TestContext> testContexts) {
        CoverageMatrix matrixExecutionResult = new CoverageMatrix(this.config);
        Set<String> testClasses = testContexts.stream().map(TestContext::getTestMethods).flatMap(Collection::stream).map(TestMethod::getFullyQualifiedClassName).collect(Collectors.toSet());
        int executedTests = 0;
        int testsFound = 0;
        for (TestContext testContext : testContexts) {
            this.logger.debug((Object)("Running " + testContext));
            try {
                CoveredTestResultPerTestMethod result = testContext.getTestFrameworkStrategy().execute(testContext);
                for (TestMethod testMethod : testContext.getTestMethods()) {
                    ++testsFound;
                    if (result.getCoverageResultsMap().containsKey(testMethod.getFullyQualifiedMethodName())) {
                        matrixExecutionResult.processSingleTest(new CoverageFromSingleTestUnit(testMethod, result), testClasses);
                        ++executedTests;
                        continue;
                    }
                    this.logger.warn((Object)("Test " + testMethod + " result was not reported by test-runner."));
                }
            }
            catch (TimeoutException e) {
                this.logger.error((Object)e);
            }
        }
        this.logger.info((Object)("Tests found: " + testsFound));
        this.logger.info((Object)("Tests executed: " + executedTests));
        return matrixExecutionResult;
    }
}

