/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.core.test;

import fr.spoonlabs.flacoco.core.config.FlacocoConfig;
import fr.spoonlabs.flacoco.core.coverage.framework.JUnit4Strategy;
import fr.spoonlabs.flacoco.core.coverage.framework.JUnit5Strategy;
import fr.spoonlabs.flacoco.core.test.TestContext;
import fr.spoonlabs.flacoco.core.test.method.StringTestMethod;
import fr.spoonlabs.flacoco.core.test.method.TestMethod;
import fr.spoonlabs.flacoco.core.test.strategies.classloader.ClassloaderStrategy;
import fr.spoonlabs.flacoco.core.test.strategies.testrunner.TestRunnerStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class TestDetector {
    private Logger logger = Logger.getLogger(TestDetector.class);
    private FlacocoConfig config;
    private List<TestContext> tests;

    public TestDetector(FlacocoConfig config) {
        this.config = config;
    }

    public List<TestContext> getTests() {
        if (this.tests != null) {
            this.logger.debug((Object)"Returning tests previously computed.");
            return this.tests;
        }
        if (!this.config.getjUnit4Tests().isEmpty() || !this.config.getjUnit5Tests().isEmpty()) {
            this.logger.debug((Object)"Computing tests from config.");
            this.tests = this.computeTests();
            return this.tests;
        }
        this.logger.debug((Object)("Running chosen test detection strategy: " + (Object)((Object)this.config.getTestDetectionStrategy())));
        this.tests = this.findTests();
        return this.tests;
    }

    private List<TestContext> computeTests() {
        ArrayList<TestContext> result = new ArrayList<TestContext>();
        if (!this.config.getjUnit4Tests().isEmpty()) {
            TestContext jUnit4Context = new TestContext(new JUnit4Strategy(this.config));
            jUnit4Context.addTestMethods(this.config.getjUnit4Tests().stream().map(x -> new StringTestMethod(x.split("#")[0], x.split("#")[1])).filter(x -> !TestDetector.isIgnored(x, this.config.getIgnoredTests())).collect(Collectors.toList()));
            result.add(jUnit4Context);
        }
        if (!this.config.getjUnit5Tests().isEmpty()) {
            TestContext jUnit5Context = new TestContext(new JUnit5Strategy(this.config));
            jUnit5Context.addTestMethods(this.config.getjUnit5Tests().stream().map(x -> new StringTestMethod(x.split("#")[0], x.split("#")[1])).filter(x -> !TestDetector.isIgnored(x, this.config.getIgnoredTests())).collect(Collectors.toList()));
            result.add(jUnit5Context);
        }
        return result;
    }

    private List<TestContext> findTests() {
        switch (this.config.getTestDetectionStrategy()) {
            case TEST_RUNNER: {
                return new TestRunnerStrategy(this.config).findTests();
            }
        }
        return new ClassloaderStrategy(this.config).findTests();
    }

    public static boolean isIgnored(TestMethod testMethod, Set<String> ignoredTests) {
        return ignoredTests.contains(testMethod.getFullyQualifiedClassName()) || ignoredTests.contains(testMethod.getFullyQualifiedMethodName());
    }
}

