/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.core.test.strategies.classloader;

import fr.spoonlabs.flacoco.core.config.FlacocoConfig;
import fr.spoonlabs.flacoco.core.test.TestContext;
import fr.spoonlabs.flacoco.core.test.strategies.TestDetectionStrategy;
import fr.spoonlabs.flacoco.core.test.strategies.classloader.finder.CustomClassLoaderThreadFactory;
import fr.spoonlabs.flacoco.core.test.strategies.classloader.finder.TestFinderRunner;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ClassloaderStrategy
implements TestDetectionStrategy {
    private Logger logger = Logger.getLogger(ClassloaderStrategy.class);
    private FlacocoConfig config;

    public ClassloaderStrategy(FlacocoConfig config) {
        this.config = config;
    }

    @Override
    public List<TestContext> findTests() {
        try {
            URLClassLoader urlClassLoader = new URLClassLoader(this.getUrls());
            CustomClassLoaderThreadFactory threadFactory = new CustomClassLoaderThreadFactory(urlClassLoader);
            ExecutorService executor = Executors.newSingleThreadExecutor(threadFactory);
            Future<List<TestContext>> future = executor.submit(new TestFinderRunner(this.config));
            executor.shutdown();
            return future.get();
        }
        catch (InterruptedException | MalformedURLException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private URL[] getUrls() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String dir : this.config.getBinJavaDir()) {
            urls.add(new File(dir).toURI().toURL());
        }
        for (String dir : this.config.getBinTestDir()) {
            urls.add(new File(dir).toURI().toURL());
        }
        if (!this.config.getClasspath().isEmpty()) {
            for (String dir : this.config.getClasspath().split(File.pathSeparator)) {
                urls.add(new File(dir).toURI().toURL());
            }
        }
        return urls.toArray(new URL[0]);
    }
}

