/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.core.test.strategies.classloader.finder;

import fr.spoonlabs.flacoco.core.test.method.TestMethod;
import fr.spoonlabs.flacoco.core.test.strategies.classloader.finder.classes.ClassFinder;
import fr.spoonlabs.flacoco.core.test.strategies.classloader.finder.classes.impl.ClassloaderFinder;
import fr.spoonlabs.flacoco.core.test.strategies.classloader.finder.filters.TestMethodFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class Processor {
    private static final Logger logger = Logger.getLogger(Processor.class);
    private static final int CLASS_SUFFIX_LENGTH = ".class".length();
    private static final int JAVA_SUFFIX_LENGTH = ".java".length();
    private final TestMethodFilter tester;
    private final ClassFinder finder;

    public Processor(ClassFinder finder, TestMethodFilter tester) {
        this.tester = tester;
        this.finder = finder;
    }

    public List<TestMethod> process() {
        ArrayList<TestMethod> testMethods = new ArrayList<TestMethod>();
        for (String className : this.finder.getClasses()) {
            if (className.contains("$")) continue;
            try {
                Class<?> clazz = Class.forName(className);
                if (clazz.isLocalClass() || clazz.isAnonymousClass()) continue;
                testMethods.addAll(this.tester.acceptClass(clazz));
            }
            catch (ClassNotFoundException cnfe) {
                Class<?> clazz;
                try {
                    ClassLoader tmp = Thread.currentThread().getContextClassLoader();
                    clazz = Class.forName(className, false, tmp);
                    if (clazz.isLocalClass() || clazz.isAnonymousClass()) continue;
                    testMethods.addAll(this.tester.acceptClass(clazz));
                }
                catch (ClassNotFoundException | IllegalAccessError cnfe2) {
                    clazz = null;
                    try {
                        clazz = Class.forName(className, false, ((ClassloaderFinder)this.finder).urlClassloader);
                        if (clazz.isLocalClass() || clazz.isAnonymousClass()) continue;
                        testMethods.addAll(this.tester.acceptClass(clazz));
                    }
                    catch (ClassNotFoundException | IllegalAccessError e) {
                        logger.warn((Object)("ClassNotFoundException: " + className));
                        logger.warn((Object)Arrays.toString(((ClassloaderFinder)this.finder).urlClassloader.getURLs()));
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        return testMethods;
    }

    private String classNameFromJava(String fileName) {
        String s = this.replaceFileSeparators(this.cutOffExtension(fileName, JAVA_SUFFIX_LENGTH));
        while (s.startsWith(".")) {
            s = s.substring(1);
        }
        return s;
    }

    private boolean isJavaFile(String fileName) {
        return fileName.endsWith(".java");
    }

    private boolean isInnerClass(String className) {
        return className.contains("$");
    }

    private boolean isClassFile(String classFileName) {
        return classFileName.endsWith(".class");
    }

    private String classNameFromFile(String classFileName) {
        String s = this.replaceFileSeparators(this.cutOffExtension(classFileName, CLASS_SUFFIX_LENGTH));
        while (s.startsWith(".")) {
            s = s.substring(1);
        }
        return s;
    }

    private String replaceFileSeparators(String s) {
        String result = s.replace(File.separatorChar, '.');
        if (File.separatorChar != '/') {
            result = result.replace('/', '.');
        }
        return result;
    }

    private String cutOffExtension(String classFileName, int length) {
        return classFileName.substring(0, classFileName.length() - length);
    }
}

