/*
 * Decompiled with CFR 0.152.
 */
package fr.spoonlabs.flacoco.localization.spectrum;

import fr.spoonlabs.flacoco.api.result.Location;
import fr.spoonlabs.flacoco.api.result.Suspiciousness;
import fr.spoonlabs.flacoco.core.config.FlacocoConfig;
import fr.spoonlabs.flacoco.core.coverage.CoverageMatrix;
import fr.spoonlabs.flacoco.core.test.method.TestMethod;
import fr.spoonlabs.flacoco.localization.spectrum.formulas.Formula;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class SpectrumSuspiciousComputation {
    private Logger logger = Logger.getLogger(SpectrumSuspiciousComputation.class);
    private FlacocoConfig config;

    public SpectrumSuspiciousComputation(FlacocoConfig config) {
        this.config = config;
    }

    public Map<Location, Suspiciousness> calculateSuspicious(CoverageMatrix matrix, Formula formula) {
        HashMap<Location, Suspiciousness> result = new HashMap<Location, Suspiciousness>();
        for (Location location : matrix.getResultExecution().keySet()) {
            ArrayList<TestMethod> testsPassingExecuting = new ArrayList<TestMethod>();
            ArrayList<TestMethod> testsFailingExecuting = new ArrayList<TestMethod>();
            int nrTestPassingNotExecuting = 0;
            int nrTestFailingNotExecuting = 0;
            Set<TestMethod> currentExecution = matrix.getResultExecution().get(location);
            for (TestMethod testMethod : matrix.getTests().keySet()) {
                Boolean iTestPassing = matrix.getTests().get(testMethod);
                Boolean nrExecuted = currentExecution.contains(testMethod);
                if (iTestPassing.booleanValue() && nrExecuted.booleanValue()) {
                    testsPassingExecuting.add(testMethod);
                    continue;
                }
                if (!iTestPassing.booleanValue() && nrExecuted.booleanValue()) {
                    testsFailingExecuting.add(testMethod);
                    continue;
                }
                if (iTestPassing.booleanValue() && !nrExecuted.booleanValue()) {
                    ++nrTestPassingNotExecuting;
                    continue;
                }
                if (iTestPassing.booleanValue() || nrExecuted.booleanValue()) continue;
                ++nrTestFailingNotExecuting;
            }
            Double score = formula.compute(nrTestPassingNotExecuting, nrTestFailingNotExecuting, testsPassingExecuting.size(), testsFailingExecuting.size());
            result.put(location, new Suspiciousness(score, testsPassingExecuting, testsFailingExecuting));
        }
        return result.entrySet().stream().filter(x -> ((Suspiciousness)x.getValue()).getScore() >= this.config.getThreshold() && (((Suspiciousness)x.getValue()).getScore() > 0.0 || this.config.isIncludeZeros())).sorted(Comparator.comparing(x -> ((Location)x.getKey()).getClassName())).sorted(Comparator.comparingInt(x -> ((Location)x.getKey()).getLineNumber())).sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }
}

