/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.query.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.springframework.social.google.api.query.QueryBuilder;
import org.springframework.util.StringUtils;

public abstract class QueryBuilderImpl<Q extends QueryBuilder<?, T>, T>
implements QueryBuilder<Q, T> {
    private static final Format dateFormatter;
    protected String feedUrl;
    private Map<String, String> params = new LinkedHashMap<String, String>();

    protected QueryBuilderImpl() {
    }

    protected QueryBuilderImpl(String feedUrl) {
        this.feedUrl = feedUrl;
    }

    protected static String encode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    protected Q castThis() {
        return (Q)this;
    }

    @Override
    public Q maxResultsNumber(int maxResults) {
        this.appendQueryParam("maxResults", maxResults);
        return this.castThis();
    }

    protected Q appendQueryParam(String name, Date value) {
        if (value != null) {
            this.appendQueryParam(name, dateFormatter.format(value));
        }
        return this.castThis();
    }

    protected Q appendQueryParam(String name, int value) {
        if (value > 0) {
            this.appendQueryParam(name, String.valueOf(value));
        }
        return this.castThis();
    }

    protected Q appendQueryParam(String name, boolean value) {
        if (value) {
            this.appendQueryParam(name, "true");
        }
        return this.castThis();
    }

    protected Q appendQueryParam(String name, Object value) {
        if (value != null) {
            this.appendQueryParam(name, value.toString());
        }
        return this.castThis();
    }

    protected Q appendQueryParam(StringBuilder sb, String name, Enum<?> value) {
        if (value != null) {
            this.appendQueryParam(name, value.name().toLowerCase());
        }
        return this.castThis();
    }

    protected Q appendQueryParam(String name, String value) {
        if (StringUtils.hasText((String)value)) {
            this.params.put(name, value);
        }
        return this.castThis();
    }

    protected String build() {
        StringBuilder sb = new StringBuilder(this.feedUrl);
        if (!this.params.isEmpty() && this.feedUrl.indexOf(63) < 0) {
            sb.append('?');
        }
        for (Map.Entry<String, String> param : this.params.entrySet()) {
            if (sb.charAt(sb.length() - 1) != '?') {
                sb.append('&');
            }
            sb.append(param.getKey()).append('=').append(param.getValue());
        }
        return sb.toString();
    }

    static {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateFormatter = simpleDateFormat;
    }
}

