/*
 * Decompiled with CFR 0.152.
 */
package com.github.springtestdbunit;

import com.github.springtestdbunit.DataSetModifiers;
import com.github.springtestdbunit.DatabaseConnections;
import com.github.springtestdbunit.DbUnitTestContext;
import com.github.springtestdbunit.DbUnitTestExecutionListener;
import com.github.springtestdbunit.annotation.DatabaseOperation;
import com.github.springtestdbunit.annotation.DatabaseSetup;
import com.github.springtestdbunit.annotation.DatabaseSetups;
import com.github.springtestdbunit.annotation.DatabaseTearDown;
import com.github.springtestdbunit.annotation.DatabaseTearDowns;
import com.github.springtestdbunit.annotation.ExpectedDatabase;
import com.github.springtestdbunit.annotation.ExpectedDatabases;
import com.github.springtestdbunit.assertion.DatabaseAssertion;
import com.github.springtestdbunit.dataset.DataSetLoader;
import com.github.springtestdbunit.dataset.DataSetModifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.filter.IColumnFilter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbUnitRunner {
    private static final Log logger = LogFactory.getLog(DbUnitTestExecutionListener.class);

    public void beforeTestMethod(DbUnitTestContext testContext) throws Exception {
        Annotations annotations = Annotations.get(testContext, DatabaseSetups.class, DatabaseSetup.class);
        this.setupOrTeardown(testContext, true, AnnotationAttributes.get(annotations));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTestMethod(DbUnitTestContext testContext) throws Exception {
        try {
            try {
                this.verifyExpected(testContext, Annotations.get(testContext, ExpectedDatabases.class, ExpectedDatabase.class));
            }
            finally {
                block12: {
                    Annotations annotations = Annotations.get(testContext, DatabaseTearDowns.class, DatabaseTearDown.class);
                    try {
                        this.setupOrTeardown(testContext, false, AnnotationAttributes.get(annotations));
                    }
                    catch (RuntimeException ex) {
                        if (testContext.getTestException() == null) {
                            throw ex;
                        }
                        if (!logger.isWarnEnabled()) break block12;
                        logger.warn((Object)"Unable to throw database cleanup exception due to existing test error", (Throwable)ex);
                    }
                }
            }
        }
        finally {
            testContext.getConnections().closeAll();
        }
    }

    private void verifyExpected(DbUnitTestContext testContext, Annotations<ExpectedDatabase> annotations) throws Exception {
        if (testContext.getTestException() != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Skipping @DatabaseTest expectation due to test exception " + testContext.getTestException().getClass()));
            }
            return;
        }
        DatabaseConnections connections = testContext.getConnections();
        DataSetModifier modifier = this.getModifier(testContext, annotations);
        boolean override = false;
        for (ExpectedDatabase annotation : annotations.getMethodAnnotations()) {
            this.verifyExpected(testContext, connections, modifier, annotation);
            override |= annotation.override();
        }
        if (!override) {
            for (ExpectedDatabase annotation : annotations.getClassAnnotations()) {
                this.verifyExpected(testContext, connections, modifier, annotation);
            }
        }
    }

    private void verifyExpected(DbUnitTestContext testContext, DatabaseConnections connections, DataSetModifier modifier, ExpectedDatabase annotation) throws Exception, DataSetException, SQLException, DatabaseUnitException {
        String query = annotation.query();
        String table = annotation.table();
        IDataSet expectedDataSet = this.loadDataset(testContext, annotation.value(), modifier);
        IDatabaseConnection connection = connections.get(annotation.connection());
        if (expectedDataSet != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Veriftying @DatabaseTest expectation using " + annotation.value()));
            }
            DatabaseAssertion assertion = annotation.assertionMode().getDatabaseAssertion();
            List<IColumnFilter> columnFilters = this.getColumnFilters(annotation);
            if (StringUtils.hasLength((String)query)) {
                Assert.hasLength((String)table, (String)"The table name must be specified when using a SQL query");
                ITable expectedTable = expectedDataSet.getTable(table);
                ITable actualTable = connection.createQueryTable(table, query);
                assertion.assertEquals(expectedTable, actualTable, columnFilters);
            } else if (StringUtils.hasLength((String)table)) {
                ITable actualTable = connection.createTable(table);
                ITable expectedTable = expectedDataSet.getTable(table);
                assertion.assertEquals(expectedTable, actualTable, columnFilters);
            } else {
                IDataSet actualDataSet = connection.createDataSet();
                assertion.assertEquals(expectedDataSet, actualDataSet, columnFilters);
            }
        }
    }

    private DataSetModifier getModifier(DbUnitTestContext testContext, Annotations<ExpectedDatabase> annotations) {
        DataSetModifiers modifiers = new DataSetModifiers();
        for (ExpectedDatabase annotation : annotations) {
            for (Class<? extends DataSetModifier> modifierClass : annotation.modifiers()) {
                modifiers.add(testContext.getTestInstance(), modifierClass);
            }
        }
        return modifiers;
    }

    private void setupOrTeardown(DbUnitTestContext testContext, boolean isSetup, Collection<AnnotationAttributes> annotations) throws Exception {
        DatabaseConnections connections = testContext.getConnections();
        for (AnnotationAttributes annotation : annotations) {
            List<IDataSet> datasets = this.loadDataSets(testContext, annotation);
            DatabaseOperation operation = annotation.getType();
            org.dbunit.operation.DatabaseOperation dbUnitOperation = this.getDbUnitDatabaseOperation(testContext, operation);
            if (datasets.isEmpty()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing " + (isSetup ? "Setup" : "Teardown") + " of @DatabaseTest using " + (Object)((Object)operation) + " on " + datasets.toString()));
            }
            IDatabaseConnection connection = connections.get(annotation.getConnection());
            CompositeDataSet dataSet = new CompositeDataSet(datasets.toArray(new IDataSet[datasets.size()]));
            dbUnitOperation.execute(connection, (IDataSet)dataSet);
        }
    }

    private List<IDataSet> loadDataSets(DbUnitTestContext testContext, AnnotationAttributes annotation) throws Exception {
        ArrayList<IDataSet> datasets = new ArrayList<IDataSet>();
        for (String dataSetLocation : annotation.getValue()) {
            datasets.add(this.loadDataset(testContext, dataSetLocation, DataSetModifier.NONE));
        }
        if (datasets.isEmpty()) {
            datasets.add(this.getFullDatabaseDataSet(testContext, annotation.getConnection()));
        }
        return datasets;
    }

    private IDataSet getFullDatabaseDataSet(DbUnitTestContext testContext, String name) throws Exception {
        IDatabaseConnection connection = testContext.getConnections().get(name);
        return connection.createDataSet();
    }

    private IDataSet loadDataset(DbUnitTestContext testContext, String dataSetLocation, DataSetModifier modifier) throws Exception {
        DataSetLoader dataSetLoader = testContext.getDataSetLoader();
        if (StringUtils.hasLength((String)dataSetLocation)) {
            IDataSet dataSet = dataSetLoader.loadDataSet(testContext.getTestClass(), dataSetLocation);
            dataSet = modifier.modify(dataSet);
            Assert.notNull((Object)dataSet, (String)("Unable to load dataset from \"" + dataSetLocation + "\" using " + dataSetLoader.getClass()));
            return dataSet;
        }
        return null;
    }

    private List<IColumnFilter> getColumnFilters(ExpectedDatabase annotation) throws Exception {
        Class<? extends IColumnFilter>[] columnFilterClasses = annotation.columnFilters();
        LinkedList<IColumnFilter> columnFilters = new LinkedList<IColumnFilter>();
        for (Class<? extends IColumnFilter> columnFilterClass : columnFilterClasses) {
            columnFilters.add(columnFilterClass.newInstance());
        }
        return columnFilters;
    }

    private org.dbunit.operation.DatabaseOperation getDbUnitDatabaseOperation(DbUnitTestContext testContext, DatabaseOperation operation) {
        org.dbunit.operation.DatabaseOperation databaseOperation = testContext.getDatbaseOperationLookup().get(operation);
        Assert.state((databaseOperation != null ? 1 : 0) != 0, (String)("The database operation " + (Object)((Object)operation) + " is not supported"));
        return databaseOperation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Annotations<T extends Annotation>
    implements Iterable<T> {
        private final List<T> classAnnotations;
        private final List<T> methodAnnotations;
        private final List<T> allAnnotations;

        public Annotations(DbUnitTestContext context, Class<? extends Annotation> container, Class<T> annotation) {
            this.classAnnotations = this.getAnnotations(context.getTestClass(), container, annotation);
            this.methodAnnotations = this.getAnnotations(context.getTestMethod(), container, annotation);
            ArrayList<T> allAnnotations = new ArrayList<T>(this.classAnnotations.size() + this.methodAnnotations.size());
            allAnnotations.addAll(this.classAnnotations);
            allAnnotations.addAll(this.methodAnnotations);
            this.allAnnotations = Collections.unmodifiableList(allAnnotations);
        }

        private List<T> getAnnotations(AnnotatedElement element, Class<? extends Annotation> container, Class<T> annotation) {
            ArrayList annotations = new ArrayList();
            this.addAnnotationToList(annotations, AnnotationUtils.findAnnotation((AnnotatedElement)element, annotation));
            this.addRepeatableAnnotationsToList(annotations, AnnotationUtils.findAnnotation((AnnotatedElement)element, container));
            return Collections.unmodifiableList(annotations);
        }

        private void addAnnotationToList(List<T> annotations, T annotation) {
            if (annotation != null) {
                annotations.add(annotation);
            }
        }

        private void addRepeatableAnnotationsToList(List<T> annotations, Annotation container) {
            if (container != null) {
                Annotation[] value;
                for (Annotation annotation : value = (Annotation[])AnnotationUtils.getValue((Annotation)container)) {
                    annotations.add(annotation);
                }
            }
        }

        public List<T> getClassAnnotations() {
            return this.classAnnotations;
        }

        public List<T> getMethodAnnotations() {
            return this.methodAnnotations;
        }

        @Override
        public Iterator<T> iterator() {
            return this.allAnnotations.iterator();
        }

        private static <T extends Annotation> Annotations<T> get(DbUnitTestContext testContext, Class<? extends Annotation> container, Class<T> annotation) {
            return new Annotations<T>(testContext, container, annotation);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotationAttributes {
        private final DatabaseOperation type;
        private final String[] value;
        private final String connection;

        public AnnotationAttributes(Annotation annotation) {
            Assert.state((annotation instanceof DatabaseSetup || annotation instanceof DatabaseTearDown ? 1 : 0) != 0, (String)"Only DatabaseSetup and DatabaseTearDown annotations are supported");
            Map attributes = AnnotationUtils.getAnnotationAttributes((Annotation)annotation);
            this.type = (DatabaseOperation)((Object)attributes.get("type"));
            this.value = (String[])attributes.get("value");
            this.connection = (String)attributes.get("connection");
        }

        public DatabaseOperation getType() {
            return this.type;
        }

        public String[] getValue() {
            return this.value;
        }

        public String getConnection() {
            return this.connection;
        }

        public static <T extends Annotation> Collection<AnnotationAttributes> get(Annotations<T> annotations) {
            ArrayList<AnnotationAttributes> annotationAttributes = new ArrayList<AnnotationAttributes>();
            for (Annotation annotation : annotations) {
                annotationAttributes.add(new AnnotationAttributes(annotation));
            }
            return annotationAttributes;
        }
    }
}

