/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads;

import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.StringUtils;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.models4j.RateLimitStatusImpl;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.ads.TwitterRuntimeException;
import twitter4jads.util.TwitterAdHttpUtils;
import twitter4jads.util.TwitterAdUtil;

public class BaseAdsListResponseIterable<T>
implements Iterable<BaseAdsListResponse<T>> {
    private final TwitterAdsClient twitterAdsClient;
    private BaseAdsListResponse<T> data;
    private final String baseUrl;
    private final Type type;
    private String nextCursor;
    private final List<HttpParameter> baseParameters;
    private boolean isCostBasedRateLimit;

    public BaseAdsListResponseIterable(TwitterAdsClient twitterAdsClient, String baseUrl, List<HttpParameter> baseParameters, Type type, HttpResponse response, boolean isCostBasedRateLimit) throws IOException, TwitterException {
        this.isCostBasedRateLimit = isCostBasedRateLimit;
        TwitterAdUtil.ensureNotNull(twitterAdsClient, "Twitter Ads API");
        TwitterAdUtil.ensureNotNull(response, "Twitter Ads Response");
        this.twitterAdsClient = twitterAdsClient;
        this.baseUrl = baseUrl;
        this.baseParameters = baseParameters == null ? Collections.emptyList() : Collections.unmodifiableList(baseParameters);
        Gson gson = new Gson();
        this.data = (BaseAdsListResponse)gson.fromJson(response.asString(), type);
        if (this.data == null) {
            this.data = new BaseAdsListResponse();
        }
        this.type = type;
        RateLimitStatusImpl rateLimitStatus = isCostBasedRateLimit ? TwitterAdHttpUtils.createFromResponseHeaderForCostBasedRateLimit(response) : TwitterAdHttpUtils.createFromResponseHeader(response);
        this.data.setRateLimitStatus(rateLimitStatus);
        if (TwitterAdUtil.isNotEmpty(this.data.getData()) && this.data.getNextCursor() != null) {
            this.nextCursor = this.data.getNextCursor();
        }
    }

    @Override
    public BaseAdsListResponseIterator<T> iterator() {
        return new BaseAdsListResponseIterator(this);
    }

    private BaseAdsListResponseIterable<T> fetchNextResponse() throws IOException, TwitterException {
        List<HttpParameter> parameters = TwitterAdUtil.createMutableList(this.baseParameters);
        parameters = this.removeParamIfExist(parameters, "cursor");
        parameters.add(new HttpParameter("cursor", this.getNextCursor()));
        HttpResponse httpResponse = this.twitterAdsClient.get(this.baseUrl, parameters.toArray(new HttpParameter[parameters.size()]));
        return new BaseAdsListResponseIterable<T>(this.twitterAdsClient, this.baseUrl, this.baseParameters, this.type, httpResponse, this.isCostBasedRateLimit);
    }

    private List<HttpParameter> removeParamIfExist(List<HttpParameter> parameters, String param) {
        if (parameters.isEmpty() || param == null) {
            return parameters;
        }
        ArrayList<HttpParameter> toReturn = new ArrayList<HttpParameter>();
        for (HttpParameter parameter : parameters) {
            if (parameter != null && param.equalsIgnoreCase(parameter.getName())) continue;
            toReturn.add(parameter);
        }
        return toReturn;
    }

    public boolean hasData() {
        return this.data != null && this.data.getData() != null && !this.data.getData().isEmpty();
    }

    private BaseAdsListResponse<T> getData() {
        return this.data == null ? new BaseAdsListResponse<T>() : this.data;
    }

    private boolean hasNext() {
        return StringUtils.isNotBlank((CharSequence)this.getNextCursor());
    }

    public String getNextCursor() {
        return this.nextCursor;
    }

    public static class BaseAdsListResponseIterator<T>
    implements Iterator<BaseAdsListResponse<T>> {
        private BaseAdsListResponseIterable<T> baseAdsListResponseIterable;
        private boolean initialResponse = true;

        private BaseAdsListResponseIterator(BaseAdsListResponseIterable<T> baseAdsListResponseIterable) {
            this.baseAdsListResponseIterable = baseAdsListResponseIterable;
        }

        @Override
        public boolean hasNext() {
            return this.initialResponse || ((BaseAdsListResponseIterable)this.baseAdsListResponseIterable).hasNext();
        }

        @Override
        public BaseAdsListResponse<T> next() {
            if (this.initialResponse) {
                this.initialResponse = false;
                return ((BaseAdsListResponseIterable)this.baseAdsListResponseIterable).getData();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more data to fetch");
            }
            try {
                this.baseAdsListResponseIterable = ((BaseAdsListResponseIterable)this.baseAdsListResponseIterable).fetchNextResponse();
            }
            catch (IOException | TwitterException e) {
                throw new TwitterRuntimeException(e, new TwitterException("Could not fetch more data."));
            }
            return ((BaseAdsListResponseIterable)this.baseAdsListResponseIterable).getData();
        }

        @Override
        public void remove() {
        }

        public String getNextCursor() {
            return this.baseAdsListResponseIterable.getNextCursor();
        }
    }
}

