/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.BaseAdsResponse;
import twitter4jads.TwitterAdsConstants;
import twitter4jads.auth.Authorization;
import twitter4jads.auth.OAuthSupport;
import twitter4jads.conf.Configuration;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.models4j.TwitterAPIMonitor;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.models4j.TwitterImpl;
import twitter4jads.internal.models4j.Version;
import twitter4jads.models.TwitterTonUploadResponse;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.media.TwitterLibraryMedia;
import twitter4jads.models.media.TwitterMediaLibraryStatus;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsClient
extends TwitterImpl
implements OAuthSupport {
    public static final String ADS_API_URL = "https://ads-api.twitter.com/";
    public static final Gson GSON_INSTANCE = new Gson();
    private static final Map<String, String> requestHeaders = new HashMap<String, String>();

    public static TwitterAdsClient getInstance(Configuration conf, Authorization auth) {
        return new TwitterAdsClient(conf, auth);
    }

    public TwitterAdsClient(Configuration conf, Authorization auth) {
        super(conf, auth);
    }

    private String getImplicitParamsStr() {
        return "";
    }

    public String getBaseAdsAPIUrl() {
        return ADS_API_URL;
    }

    public String getMediaUploadBaseUrl() {
        return this.conf.getMediaUploadBaseUrl();
    }

    public <T> BaseAdsListResponseIterable<T> executeHttpListRequest(String baseUrl, List<HttpParameter> params, Type type) throws TwitterException {
        return this.executeHttpListRequest(baseUrl, params, type, false);
    }

    public <T> BaseAdsListResponseIterable<T> executeHttpListRequest(String baseUrl, List<HttpParameter> params, Type type, boolean isCostBasedRateLimit) throws TwitterException {
        BaseAdsListResponseIterable<T> response;
        HttpResponse httpResponse = params != null ? this.get(baseUrl, params.toArray(new HttpParameter[params.size()])) : this.get(baseUrl);
        try {
            response = this.constructBaseAdsListResponse(baseUrl, httpResponse, params, type, isCostBasedRateLimit);
        }
        catch (IOException e) {
            throw new TwitterException("Failed to parse response.", e);
        }
        return response;
    }

    public <T> BaseAdsListResponseIterable<T> constructBaseAdsListResponse(String baseUrl, HttpResponse httpResponse, List<HttpParameter> params, Type type, boolean isCostBasedRateLimit) throws TwitterException, IOException {
        return new BaseAdsListResponseIterable(this, baseUrl, params, type, httpResponse, isCostBasedRateLimit);
    }

    public <T> BaseAdsResponse<T> executeHttpRequest(String baseUrl, HttpParameter[] params, Type type, HttpVerb httpVerb) throws TwitterException {
        BaseAdsResponse response = null;
        switch (httpVerb) {
            case GET: {
                try {
                    HttpResponse httpResponse = this.get(baseUrl, params);
                    String stringResponse = httpResponse.asString();
                    response = TwitterAdUtil.constructBaseAdsResponse(httpResponse, stringResponse, type);
                    break;
                }
                catch (IOException e) {
                    throw new TwitterException("Failed to parse response.", e);
                }
            }
            case PUT: {
                try {
                    HttpResponse httpResponse = this.put(baseUrl, params);
                    String stringResponse = httpResponse.asString();
                    response = TwitterAdUtil.constructBaseAdsResponse(httpResponse, stringResponse, type);
                    break;
                }
                catch (IOException e) {
                    throw new TwitterException("Failed to parse response.", e);
                }
            }
            case POST: {
                try {
                    HttpResponse httpResponse = this.postRequest(baseUrl, params);
                    String stringResponse = httpResponse.asString();
                    response = TwitterAdUtil.constructBaseAdsResponse(httpResponse, stringResponse, type);
                    break;
                }
                catch (IOException e) {
                    throw new TwitterException("Failed to parse response.", e);
                }
            }
            case DELETE: {
                try {
                    HttpResponse httpResponse = this.delete(baseUrl, params);
                    String stringResponse = httpResponse.asString();
                    response = TwitterAdUtil.constructBaseAdsResponse(httpResponse, stringResponse, type);
                    break;
                }
                catch (IOException e) {
                    throw new TwitterException("Failed to parse response.", e);
                }
            }
        }
        return response;
    }

    public HttpResponse postRequest(String url, String requestBody) throws TwitterException {
        return super.post(url, requestBody);
    }

    public HttpResponse postRequest(String url, HttpParameter[] params) throws TwitterException {
        return this.post(url, params);
    }

    public HttpResponse getRequest(String url, HttpParameter[] params) throws TwitterException {
        return this.get(url, params);
    }

    public HttpResponse getRequest(String url) throws TwitterException {
        return this.get(url);
    }

    public HttpResponse getWithoutMergeOfParams(String url, HttpParameter[] params) throws TwitterException {
        return this.getWithoutMergingImplicitParams(url, params);
    }

    public HttpResponse putRequest(String url, HttpParameter[] params) throws TwitterException {
        return this.put(url, params);
    }

    public TwitterTonUploadResponse executeHttpRequestForTon(String baseUrl, HttpParameter[] params, HttpVerb httpVerb, Map<String, String> customHeaders) throws TwitterException {
        TwitterTonUploadResponse response = null;
        switch (httpVerb) {
            case PUT: {
                HttpResponse httpResponse = this.putWithCustomHeaders(baseUrl, params, customHeaders, true);
                response = this.getResponseFromHeaders(httpResponse);
                break;
            }
            case POST: {
                HttpResponse httpResponse = this.postWithCustomHeaders(baseUrl, params, customHeaders, true);
                response = this.getResponseFromHeaders(httpResponse);
            }
        }
        return response;
    }

    public <T> T executeRequest(String baseUrl, HttpParameter[] params, Type typeToken, HttpVerb httpVerb) throws TwitterException {
        T response = null;
        switch (httpVerb) {
            case GET: {
                try {
                    HttpResponse httpResponse = this.getRequest(baseUrl, params);
                    String stringResponse = httpResponse.asString();
                    response = this.constructHTTPRequestResponse(stringResponse, typeToken);
                    break;
                }
                catch (IOException e) {
                    throw new TwitterException("Failed to parse response.", e);
                }
            }
            case PUT: {
                try {
                    HttpResponse httpResponse = this.put(baseUrl, params);
                    String stringResponse = httpResponse.asString();
                    response = this.constructHTTPRequestResponse(stringResponse, typeToken);
                    break;
                }
                catch (IOException e) {
                    throw new TwitterException("Failed to parse response.", e);
                }
            }
            case POST: {
                try {
                    HttpResponse httpResponse = this.postRequest(baseUrl, params);
                    String stringResponse = httpResponse.asString();
                    response = this.constructHTTPRequestResponse(stringResponse, typeToken);
                    break;
                }
                catch (IOException e) {
                    throw new TwitterException("Failed to parse response.", e);
                }
            }
            case DELETE: {
                try {
                    HttpResponse httpResponse = this.delete(baseUrl, params);
                    String stringResponse = httpResponse.asString();
                    response = this.constructHTTPRequestResponse(stringResponse, typeToken);
                    break;
                }
                catch (IOException e) {
                    throw new TwitterException("Failed to parse response.", e);
                }
            }
        }
        return response;
    }

    public TwitterLibraryMedia waitForMediaProcessing(String accountId, String mediaKey, long maxWaitTime) throws TwitterException {
        Long totalWaitTime = 0L;
        String url = this.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/media_library" + "/" + mediaKey;
        Type type = new TypeToken<BaseAdsResponse<TwitterLibraryMedia>>(){}.getType();
        while (totalWaitTime < maxWaitTime) {
            TwitterMediaLibraryStatus status;
            BaseAdsResponse response = this.executeHttpRequest(url, null, type, HttpVerb.GET);
            TwitterLibraryMedia media = (TwitterLibraryMedia)response.getData();
            try {
                status = TwitterMediaLibraryStatus.valueOf(media.getMediaStatus());
            }
            catch (Exception eX) {
                return null;
            }
            switch (status) {
                case TRANSCODE_FAILED: {
                    throw new TwitterException("Media processing error. Status: " + TwitterMediaLibraryStatus.TRANSCODE_FAILED.name());
                }
                case TRANSCODE_COMPLETED: {
                    return media;
                }
                case TRANSCODE_PENDING: 
                case TRANSCODE_IN_PROGRESS: {
                    TwitterAdUtil.reallySleep(TwitterAdsConstants.WAIT_INTERVAL);
                    totalWaitTime = totalWaitTime + TwitterAdsConstants.WAIT_INTERVAL;
                }
            }
        }
        return null;
    }

    public Configuration getConf() {
        return super.getConfiguration();
    }

    private <T> T constructHTTPRequestResponse(String response, Type typeToken) throws IOException {
        return (T)GSON_INSTANCE.fromJson(response, typeToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse get(String url) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, null, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, null, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse get(String url, HttpParameter ... params) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, params, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, params, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse post(String url, HttpParameter ... params) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, params, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, params, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    private boolean isOk(HttpResponse response) {
        return response != null && response.getStatusCode() < 300;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse put(String url, HttpParameter[] params) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.put(url, params, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.put(url, params, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse delete(String url) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.delete(url, null, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.delete(url, null, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse delete(String url, HttpParameter[] params) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.delete(url, params, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.delete(url, params, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpResponse getWithoutMergingImplicitParams(String url, HttpParameter[] params) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, params, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, params, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    private TwitterTonUploadResponse getResponseFromHeaders(HttpResponse httpResponse) {
        String maximumChunkSizeFromHeader;
        Integer minChunkSize = null;
        Integer maxChunkSize = null;
        String location = httpResponse.getResponseHeader("location");
        Integer bytesSuccessfullyUploaded = this.getBytesUploadedFromHeader(httpResponse);
        String minimumChunkSizeFromHeader = httpResponse.getResponseHeader("x-ton-min-chunk-size");
        if (minimumChunkSizeFromHeader != null) {
            minChunkSize = Integer.valueOf(minimumChunkSizeFromHeader);
        }
        if ((maximumChunkSizeFromHeader = httpResponse.getResponseHeader("x-ton-max-chunk-size")) != null) {
            maxChunkSize = Integer.valueOf(maximumChunkSizeFromHeader);
        }
        return new TwitterTonUploadResponse(location, minChunkSize, maxChunkSize, bytesSuccessfullyUploaded, null);
    }

    private Integer getBytesUploadedFromHeader(HttpResponse httpResponse) {
        int i;
        String rangeFromHeader = httpResponse.getResponseHeader("range");
        if (rangeFromHeader != null && (i = rangeFromHeader.indexOf("-")) > 0) {
            String range = rangeFromHeader.substring(i + 1, rangeFromHeader.length());
            return Integer.valueOf(range);
        }
        return null;
    }

    static {
        requestHeaders.put("X-Twitter-Client-Version", Version.getVersion());
        requestHeaders.put("X-Twitter-Client-URL", "http://twitter4jads.org/en/twitter4jads-" + Version.getVersion() + ".xml");
        requestHeaders.put("X-Twitter-Client", "Twitter4J");
        requestHeaders.put("User-Agent", "twitter4jads http://twitter4jads.org/ /" + Version.getVersion());
        requestHeaders.put("Accept-Encoding", "gzip");
    }
}

