/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.auth;

import twitter4jads.auth.AccessToken;
import twitter4jads.auth.Authorization;
import twitter4jads.auth.BasicAuthorization;
import twitter4jads.auth.NullAuthorization;
import twitter4jads.auth.OAuthAuthorization;
import twitter4jads.conf.Configuration;

public final class AuthorizationFactory {
    public static Authorization getInstance(Configuration conf) {
        Authorization auth = null;
        String consumerKey = conf.getOAuthConsumerKey();
        String consumerSecret = conf.getOAuthConsumerSecret();
        if (consumerKey != null && consumerSecret != null) {
            OAuthAuthorization oauth = new OAuthAuthorization(conf);
            String accessToken = conf.getOAuthAccessToken();
            String accessTokenSecret = conf.getOAuthAccessTokenSecret();
            if (accessToken != null && accessTokenSecret != null) {
                oauth.setOAuthAccessToken(new AccessToken(accessToken, accessTokenSecret));
            }
            auth = oauth;
        } else {
            String screenName = conf.getUser();
            String password = conf.getPassword();
            if (screenName != null && password != null) {
                auth = new BasicAuthorization(screenName, password);
            }
        }
        if (null == auth) {
            auth = NullAuthorization.getInstance();
        }
        return auth;
    }
}

