/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.conf;

import java.util.Properties;
import twitter4jads.conf.Configuration;
import twitter4jads.conf.ConfigurationBase;
import twitter4jads.conf.PropertyConfiguration;

public final class ConfigurationBuilder {
    private ConfigurationBase configurationBean = new PropertyConfiguration();

    public ConfigurationBuilder setUseSSL(boolean useSSL) {
        this.checkNotBuilt();
        this.configurationBean.setUseSSL(useSSL);
        return this;
    }

    public ConfigurationBuilder setPrettyDebugEnabled(boolean prettyDebugEnabled) {
        this.checkNotBuilt();
        this.configurationBean.setPrettyDebugEnabled(prettyDebugEnabled);
        return this;
    }

    public ConfigurationBuilder setGZIPEnabled(boolean gzipEnabled) {
        this.checkNotBuilt();
        this.configurationBean.setGZIPEnabled(gzipEnabled);
        return this;
    }

    public ConfigurationBuilder setDebugEnabled(boolean debugEnabled) {
        this.checkNotBuilt();
        this.configurationBean.setDebug(debugEnabled);
        return this;
    }

    public ConfigurationBuilder setUser(String user) {
        this.checkNotBuilt();
        this.configurationBean.setUser(user);
        return this;
    }

    public ConfigurationBuilder setPassword(String password) {
        this.checkNotBuilt();
        this.configurationBean.setPassword(password);
        return this;
    }

    public ConfigurationBuilder setHttpProxyHost(String httpProxyHost) {
        this.checkNotBuilt();
        this.configurationBean.setHttpProxyHost(httpProxyHost);
        return this;
    }

    public ConfigurationBuilder setHttpProxyUser(String httpProxyUser) {
        this.checkNotBuilt();
        this.configurationBean.setHttpProxyUser(httpProxyUser);
        return this;
    }

    public ConfigurationBuilder setHttpProxyPassword(String httpProxyPassword) {
        this.checkNotBuilt();
        this.configurationBean.setHttpProxyPassword(httpProxyPassword);
        return this;
    }

    public ConfigurationBuilder setHttpProxyPort(int httpProxyPort) {
        this.checkNotBuilt();
        this.configurationBean.setHttpProxyPort(httpProxyPort);
        return this;
    }

    public ConfigurationBuilder setHttpConnectionTimeout(int httpConnectionTimeout) {
        this.checkNotBuilt();
        this.configurationBean.setHttpConnectionTimeout(httpConnectionTimeout);
        return this;
    }

    public ConfigurationBuilder setHttpReadTimeout(int httpReadTimeout) {
        this.checkNotBuilt();
        this.configurationBean.setHttpReadTimeout(httpReadTimeout);
        return this;
    }

    public ConfigurationBuilder setHttpStreamingReadTimeout(int httpStreamingReadTimeout) {
        this.checkNotBuilt();
        this.configurationBean.setHttpStreamingReadTimeout(httpStreamingReadTimeout);
        return this;
    }

    public ConfigurationBuilder setHttpRetryCount(int httpRetryCount) {
        this.checkNotBuilt();
        this.configurationBean.setHttpRetryCount(httpRetryCount);
        return this;
    }

    public ConfigurationBuilder setHttpMaxTotalConnections(int httpMaxConnections) {
        this.checkNotBuilt();
        this.configurationBean.setHttpMaxTotalConnections(httpMaxConnections);
        return this;
    }

    public ConfigurationBuilder setHttpDefaultMaxPerRoute(int httpDefaultMaxPerRoute) {
        this.checkNotBuilt();
        this.configurationBean.setHttpDefaultMaxPerRoute(httpDefaultMaxPerRoute);
        return this;
    }

    public ConfigurationBuilder setHttpRetryIntervalSeconds(int httpRetryIntervalSeconds) {
        this.checkNotBuilt();
        this.configurationBean.setHttpRetryIntervalSeconds(httpRetryIntervalSeconds);
        return this;
    }

    public ConfigurationBuilder setOAuthConsumerKey(String oAuthConsumerKey) {
        this.checkNotBuilt();
        this.configurationBean.setOAuthConsumerKey(oAuthConsumerKey);
        return this;
    }

    public ConfigurationBuilder setOAuthConsumerSecret(String oAuthConsumerSecret) {
        this.checkNotBuilt();
        this.configurationBean.setOAuthConsumerSecret(oAuthConsumerSecret);
        return this;
    }

    public ConfigurationBuilder setOAuthAccessToken(String oAuthAccessToken) {
        this.checkNotBuilt();
        this.configurationBean.setOAuthAccessToken(oAuthAccessToken);
        return this;
    }

    public ConfigurationBuilder setOAuthAccessTokenSecret(String oAuthAccessTokenSecret) {
        this.checkNotBuilt();
        this.configurationBean.setOAuthAccessTokenSecret(oAuthAccessTokenSecret);
        return this;
    }

    public ConfigurationBuilder setOAuthRequestTokenURL(String oAuthRequestTokenURL) {
        this.checkNotBuilt();
        this.configurationBean.setOAuthRequestTokenURL(oAuthRequestTokenURL);
        return this;
    }

    public ConfigurationBuilder setOAuthAuthorizationURL(String oAuthAuthorizationURL) {
        this.checkNotBuilt();
        this.configurationBean.setOAuthAuthorizationURL(oAuthAuthorizationURL);
        return this;
    }

    public ConfigurationBuilder setOAuthAccessTokenURL(String oAuthAccessTokenURL) {
        this.checkNotBuilt();
        this.configurationBean.setOAuthAccessTokenURL(oAuthAccessTokenURL);
        return this;
    }

    public ConfigurationBuilder setOAuthAuthenticationURL(String oAuthAuthenticationURL) {
        this.checkNotBuilt();
        this.configurationBean.setOAuthAuthenticationURL(oAuthAuthenticationURL);
        return this;
    }

    public ConfigurationBuilder setRestBaseURL(String restBaseURL) {
        this.checkNotBuilt();
        this.configurationBean.setRestBaseURL(restBaseURL);
        return this;
    }

    public ConfigurationBuilder setStreamBaseURL(String streamBaseURL) {
        this.checkNotBuilt();
        this.configurationBean.setStreamBaseURL(streamBaseURL);
        return this;
    }

    public ConfigurationBuilder setUserStreamBaseURL(String userStreamBaseURL) {
        this.checkNotBuilt();
        this.configurationBean.setUserStreamBaseURL(userStreamBaseURL);
        return this;
    }

    public ConfigurationBuilder setSiteStreamBaseURL(String siteStreamBaseURL) {
        this.checkNotBuilt();
        this.configurationBean.setSiteStreamBaseURL(siteStreamBaseURL);
        return this;
    }

    public ConfigurationBuilder setAsyncNumThreads(int asyncNumThreads) {
        this.checkNotBuilt();
        this.configurationBean.setAsyncNumThreads(asyncNumThreads);
        return this;
    }

    public ConfigurationBuilder setContributingTo(long contributingTo) {
        this.checkNotBuilt();
        this.configurationBean.setContributingTo(contributingTo);
        return this;
    }

    public ConfigurationBuilder setClientVersion(String clientVersion) {
        this.checkNotBuilt();
        this.configurationBean.setClientVersion(clientVersion);
        return this;
    }

    public ConfigurationBuilder setClientURL(String clientURL) {
        this.checkNotBuilt();
        this.configurationBean.setClientURL(clientURL);
        return this;
    }

    public ConfigurationBuilder setDispatcherImpl(String dispatcherImpl) {
        this.checkNotBuilt();
        this.configurationBean.setDispatcherImpl(dispatcherImpl);
        return this;
    }

    public ConfigurationBuilder setIncludeRTsEnabled(boolean enabled) {
        this.checkNotBuilt();
        this.configurationBean.setIncludeRTsEnbled(enabled);
        return this;
    }

    public ConfigurationBuilder setIncludeEntitiesEnabled(boolean enabled) {
        this.checkNotBuilt();
        this.configurationBean.setIncludeEntitiesEnbled(enabled);
        return this;
    }

    public ConfigurationBuilder setIncludeMyRetweetEnabled(boolean enabled) {
        this.checkNotBuilt();
        this.configurationBean.setIncludeMyRetweetEnabled(enabled);
        return this;
    }

    public ConfigurationBuilder setJSONStoreEnabled(boolean enabled) {
        this.checkNotBuilt();
        this.configurationBean.setJSONStoreEnabled(enabled);
        return this;
    }

    public ConfigurationBuilder setMBeanEnabled(boolean enabled) {
        this.checkNotBuilt();
        this.configurationBean.setMBeanEnabled(enabled);
        return this;
    }

    public ConfigurationBuilder setUserStreamRepliesAllEnabled(boolean enabled) {
        this.checkNotBuilt();
        this.configurationBean.setUserStreamRepliesAllEnabled(enabled);
        return this;
    }

    public ConfigurationBuilder setMediaProvider(String mediaProvider) {
        this.checkNotBuilt();
        this.configurationBean.setMediaProvider(mediaProvider);
        return this;
    }

    public ConfigurationBuilder setMediaProviderAPIKey(String mediaProviderAPIKey) {
        this.checkNotBuilt();
        this.configurationBean.setMediaProviderAPIKey(mediaProviderAPIKey);
        return this;
    }

    public ConfigurationBuilder setMediaProviderParameters(Properties props) {
        this.checkNotBuilt();
        this.configurationBean.setMediaProviderParameters(props);
        return this;
    }

    public ConfigurationBuilder setLoggerImpl(String loggerImpl) {
        this.checkNotBuilt();
        this.configurationBean.setLoggerFactory(loggerImpl);
        return this;
    }

    public ConfigurationBuilder setSandboxEnabledForAds(boolean isSandboxEnabledForAds) {
        this.checkNotBuilt();
        this.configurationBean.setSandboxEnabledForAds(isSandboxEnabledForAds);
        return this;
    }

    public Configuration build() {
        this.checkNotBuilt();
        this.configurationBean.cacheInstance();
        try {
            ConfigurationBase configurationBase = this.configurationBean;
            return configurationBase;
        }
        finally {
            this.configurationBean = null;
        }
    }

    private void checkNotBuilt() {
        if (this.configurationBean == null) {
            throw new IllegalStateException("Cannot use this builder any longer, build() has already been called");
        }
    }
}

