/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.BaseAdsResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterAdsAccountApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.ads.AdAccount;
import twitter4jads.models.ads.AdAccountNativePermissions;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.ads.PromotableUser;
import twitter4jads.models.ads.TwitterPoliticalAgreement;
import twitter4jads.models.ads.sort.AccountsSortByField;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsAccountApiImpl
implements TwitterAdsAccountApi {
    private final TwitterAdsClient twitterAdsClient;

    public TwitterAdsAccountApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public BaseAdsListResponseIterable<AdAccount> getAllAccounts(boolean withDeleted, Optional<AccountsSortByField> sortByField) throws TwitterException {
        ArrayList<HttpParameter> param = new ArrayList<HttpParameter>();
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/";
        param.add(new HttpParameter("with_deleted", withDeleted));
        if (sortByField != null && sortByField.isPresent()) {
            param.add(new HttpParameter("sort_by", sortByField.get().getField()));
        }
        Type type = new TypeToken<BaseAdsListResponse<AdAccount>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, param, type);
    }

    @Override
    public BaseAdsResponse<AdAccount> getAdAccountById(String accountId, boolean withDeleted) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId;
        HttpParameter[] param = new HttpParameter[]{new HttpParameter("with_deleted", withDeleted)};
        Type type = new TypeToken<BaseAdsResponse<AdAccount>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, param, type, HttpVerb.GET);
    }

    @Override
    public List<String> getAccountPermissions(String accountId) throws TwitterException {
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/features";
        HttpResponse httpResponse = this.twitterAdsClient.getWithoutMergeOfParams(baseUrl, null);
        ArrayList permissionsFromChannel = Lists.newArrayList();
        try {
            Type type = new TypeToken<BaseAdsListResponse<String>>(){}.getType();
            BaseAdsListResponse permissions = TwitterAdUtil.constructBaseAdsListResponse(httpResponse, httpResponse.asString(), type);
            if (permissions == null || CollectionUtils.isEmpty(permissions.getData())) {
                throw new TwitterException("Empty response returned for Account Permissions");
            }
            List data = permissions.getData();
            permissionsFromChannel.addAll(data);
        }
        catch (Exception e) {
            throw new TwitterException("Exception occurred while getting the Account Permissions", e);
        }
        return permissionsFromChannel;
    }

    @Override
    public BaseAdsListResponseIterable<PromotableUser> getPromotableUsers(String accountId, boolean withDeleted) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("with_deleted", withDeleted));
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/promotable_users/";
        Type type = new TypeToken<BaseAdsListResponse<PromotableUser>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<AdAccountNativePermissions> getAdAccountNativePermissions(String accountId) throws TwitterException {
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/authenticated_user_access";
        Type type = new TypeToken<BaseAdsResponse<AdAccountNativePermissions>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.GET);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterPoliticalAgreement> getPoliticalAgreementForAccount(String accountId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/political_agreements/";
        Type type = new TypeToken<BaseAdsListResponse<TwitterPoliticalAgreement>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }
}

