/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import twitter4jads.BaseAdsListBatchPostResponse;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.BaseAdsResponse;
import twitter4jads.ErrorResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterAdsAudienceApi;
import twitter4jads.impl.NewAdsAudienceApiOperation;
import twitter4jads.impl.NewAdsAudienceApiParams;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.models4j.RateLimitStatus;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.ads.TailoredAudience;
import twitter4jads.models.ads.audience.AudienceApiResponse;
import twitter4jads.models.ads.audience.TailoredAudienceMatchingRules;
import twitter4jads.models.ads.audience.TailoredAudienceOperation;
import twitter4jads.models.ads.audience.TailoredAudiencePermission;
import twitter4jads.models.ads.audience.TailoredAudiencePermissionLevel;
import twitter4jads.models.ads.audience.TailoredAudienceUserDetails;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsAudienceApiImpl
implements TwitterAdsAudienceApi {
    private final TwitterAdsClient twitterAdsClient;
    private static final Gson GSON = new Gson();
    private static final long SIXTY_FOUR_MB = 0x4000000L;
    private static final Set<Integer> acceptableApiErrors = Sets.newHashSet((Object[])new Integer[]{400, 404, 429});

    public TwitterAdsAudienceApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public BaseAdsListResponseIterable<TailoredAudience> getAllTailoredAudiences(String accountId, Optional<Integer> count, Optional<Boolean> withDeleted, Optional<String> cursor) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/tailored_audiences";
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (count != null && count.isPresent() && count.get() < 1000) {
            params.add(new HttpParameter("count", count.get()));
        }
        if (withDeleted != null && withDeleted.isPresent()) {
            params.add(new HttpParameter("with_deleted", withDeleted.get()));
        }
        if (cursor != null && cursor.isPresent()) {
            params.add(new HttpParameter("cursor", cursor.get()));
        }
        Type type = new TypeToken<BaseAdsListResponse<TailoredAudience>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<TailoredAudience> getTailoredAudienceForId(String accountId, String tailoredAudienceId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(tailoredAudienceId, "tailoredAudienceId");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/tailored_audiences/" + tailoredAudienceId;
        Type type = new TypeToken<BaseAdsResponse<TailoredAudience>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.GET);
    }

    @Override
    public BaseAdsResponse<TailoredAudience> deleteTailoredAudience(String accountId, String tailoredAudienceId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(tailoredAudienceId, "tailoredAudienceId");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/tailored_audiences/" + tailoredAudienceId;
        Type type = new TypeToken<BaseAdsResponse<TailoredAudience>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsResponse<TailoredAudience> createTailoredAudience(String accountId, String name) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(name, "name");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/tailored_audiences/";
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("name", name));
        Type type = new TypeToken<BaseAdsResponse<TailoredAudience>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.POST);
    }

    @Override
    public BaseAdsResponse<TailoredAudienceMatchingRules> addMatchingRulesToAudience(TailoredAudienceMatchingRules tailoredAudienceMatchingRules, String accountId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(tailoredAudienceMatchingRules, "Matching Rules");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/tailored_audience_matching_rules/";
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("tailored_audience_id", tailoredAudienceMatchingRules.getTailoredAudienceId()));
        params.add(new HttpParameter("website_tag_id", tailoredAudienceMatchingRules.getWebsiteTagId()));
        params.add(new HttpParameter("rule_type", tailoredAudienceMatchingRules.getRuleType().name()));
        if (StringUtils.isNotBlank((CharSequence)tailoredAudienceMatchingRules.getRuleValue())) {
            params.add(new HttpParameter("rule_value", tailoredAudienceMatchingRules.getRuleValue()));
        }
        Type type = new TypeToken<BaseAdsResponse<TailoredAudienceMatchingRules>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.POST);
    }

    @Override
    public BaseAdsListBatchPostResponse<TailoredAudience> createFlexibleTailoredAudience(String accountId, String requestBody) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(requestBody, "params");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/batch/accounts/" + accountId + "/tailored_audiences/";
        Type type = new TypeToken<BaseAdsListBatchPostResponse<TailoredAudience>>(){}.getType();
        HttpResponse httpResponse = this.twitterAdsClient.postBatchRequest(baseUrl, requestBody);
        return (BaseAdsListBatchPostResponse)GSON.fromJson(httpResponse.asString(), type);
    }

    @Override
    public List<TailoredAudienceOperation> updateTailoredAudienceById(String accountId, String tailoredAudienceId, List<TailoredAudienceOperation> operations) throws TwitterException {
        List apiOperation;
        String requestBody;
        AudienceApiResponse apiResponse;
        List<TailoredAudienceOperation> batch;
        boolean errorFlag;
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(tailoredAudienceId, "tailoredAudienceId");
        TwitterAdUtil.ensureNotEmpty(operations, "operations");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/tailored_audiences/" + tailoredAudienceId + "/" + "users";
        Gson gson = new Gson();
        ArrayList result = Lists.newArrayList();
        Iterator<List<TailoredAudienceOperation>> batchIterator = this.generateBatchSequence(operations);
        while (batchIterator.hasNext() && !(errorFlag = this.handleAudienceUpdateResponse(batch = batchIterator.next(), apiResponse = this.publishAudienceWithRetry(baseUrl, requestBody = gson.toJson(apiOperation = batch.stream().map(this::generateRequestOperation).collect(Collectors.toList()))), result))) {
        }
        return result;
    }

    @Override
    public BaseAdsListResponse<TailoredAudiencePermission> getTailoredAudiencePermission(String accountId, String tailoredAudienceId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(tailoredAudienceId, "tailoredAudienceId");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/tailored_audiences/" + tailoredAudienceId + "/permissions/";
        Type type = new TypeToken<BaseAdsListResponse<TailoredAudiencePermission>>(){}.getType();
        return (BaseAdsListResponse)this.twitterAdsClient.executeRequest(baseUrl, null, type, HttpVerb.GET);
    }

    @Override
    public BaseAdsResponse<TailoredAudiencePermission> shareTailoredAudience(String accountId, String tailoredAudienceId, String grantedAccountId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(tailoredAudienceId, "tailoredAudienceId");
        TwitterAdUtil.ensureNotNull(grantedAccountId, "grantedAccountId");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/tailored_audiences/" + tailoredAudienceId + "/permissions/";
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("granted_account_id", grantedAccountId));
        params.add(new HttpParameter("permission_level", TailoredAudiencePermissionLevel.READ_WRITE.name()));
        Type type = new TypeToken<BaseAdsResponse<TailoredAudiencePermission>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.POST);
    }

    private Iterator<List<TailoredAudienceOperation>> generateBatchSequence(List<TailoredAudienceOperation> operations) {
        final PriorityQueue<TailoredAudienceOperation> operationPriorityQueue = new PriorityQueue<TailoredAudienceOperation>(Comparator.comparingInt(operation -> operation.getUsers().size()).reversed());
        for (TailoredAudienceOperation operation2 : operations) {
            operationPriorityQueue.offer(operation2);
        }
        return new Iterator<List<TailoredAudienceOperation>>(){

            @Override
            public boolean hasNext() {
                return !operationPriorityQueue.isEmpty();
            }

            @Override
            public List<TailoredAudienceOperation> next() {
                int peekSize;
                ArrayList toReturn = Lists.newArrayList();
                for (int totalSize = 0; totalSize < 2500 && !operationPriorityQueue.isEmpty(); totalSize += peekSize) {
                    peekSize = ((TailoredAudienceOperation)operationPriorityQueue.peek()).getUsers().size();
                    if (totalSize + peekSize < 2500) {
                        toReturn.add(operationPriorityQueue.poll());
                        continue;
                    }
                    int diff = 2500 - totalSize;
                    totalSize = 2500;
                    TailoredAudienceOperation topOperation = (TailoredAudienceOperation)operationPriorityQueue.poll();
                    TailoredAudienceOperation fractionalTopOperation = new TailoredAudienceOperation();
                    fractionalTopOperation.setOperationType(topOperation.getOperationType());
                    fractionalTopOperation.setEffectiveFrom(topOperation.getEffectiveFrom());
                    fractionalTopOperation.setExpireAt(topOperation.getExpireAt());
                    HashSet fractionalTopOperationUsers = Sets.newHashSet();
                    Iterator<TailoredAudienceUserDetails> topOperationUsersIterator = topOperation.getUsers().iterator();
                    while (diff > 0 && topOperationUsersIterator.hasNext()) {
                        fractionalTopOperationUsers.add(topOperationUsersIterator.next());
                        --diff;
                    }
                    topOperation.getUsers().removeAll(fractionalTopOperationUsers);
                    fractionalTopOperation.setUsers(fractionalTopOperationUsers);
                    operationPriorityQueue.offer(topOperation);
                    toReturn.add(fractionalTopOperation);
                    break;
                }
                return toReturn;
            }
        };
    }

    private NewAdsAudienceApiOperation generateRequestOperation(TailoredAudienceOperation operation) {
        NewAdsAudienceApiOperation apiOperation = new NewAdsAudienceApiOperation();
        apiOperation.setOperationType(operation.getOperationType().name());
        NewAdsAudienceApiParams apiParams = new NewAdsAudienceApiParams();
        apiParams.setExpireAt(operation.getExpireAt());
        apiParams.setEffectiveAt(operation.getEffectiveFrom());
        apiParams.setTailoredAudienceUserDetails(operation.getUsers());
        apiOperation.setParams(apiParams);
        return apiOperation;
    }

    private AudienceApiResponse publishAudienceWithRetry(String baseUrl, String requestBody) throws TwitterException {
        boolean retryFlag = true;
        int retryCount = 2;
        for (int retry = 1; retryFlag && retry <= 2; ++retry) {
            try {
                HttpResponse httpResponse = this.twitterAdsClient.postRequest(baseUrl, requestBody);
                String stringResponse = httpResponse.asString();
                return TwitterAdUtil.constructAudienceApiResponse(httpResponse, stringResponse);
            }
            catch (TwitterException eX) {
                if (!acceptableApiErrors.contains(eX.getStatusCode()) || StringUtils.isBlank((CharSequence)eX.getActualDetailMessage()) || eX.getResponse() == null) {
                    throw eX;
                }
                AudienceApiResponse audienceApiResponse = TwitterAdUtil.constructAudienceApiResponse(eX.getResponse(), eX.getActualDetailMessage());
                retryFlag = this.shouldRetryForRateLimitError(audienceApiResponse.getRateLimitStatus());
                if (!retryFlag) {
                    return audienceApiResponse;
                }
                TwitterAdUtil.reallySleep((long)audienceApiResponse.getRateLimitStatus().getSecondsUntilReset() * 1000L);
                continue;
            }
            catch (Exception eX) {
                throw new TwitterException("Failed to update audience", eX);
            }
        }
        return null;
    }

    private boolean shouldRetryForRateLimitError(RateLimitStatus rateLimitStatus) {
        return rateLimitStatus.getRemaining() == 0 && rateLimitStatus.getSecondsUntilReset() > 0;
    }

    private boolean handleAudienceUpdateResponse(List<TailoredAudienceOperation> batch, AudienceApiResponse apiResponse, List<TailoredAudienceOperation> result) {
        boolean errorFlag = false;
        if (apiResponse.getData() != null) {
            AudienceApiResponse.NewAudienceApiResponseData response = apiResponse.getData();
            if (response.getSuccessCount().compareTo(response.getTotalCount()) != 0 || response.getSuccessCount().compareTo(this.countUsersInBatch(batch)) != 0) {
                this.fillErrorsInOperation(batch, apiResponse);
                errorFlag = true;
            }
        } else {
            this.fillErrorsInOperation(batch, apiResponse);
            errorFlag = true;
        }
        result.addAll(batch);
        return errorFlag;
    }

    private Long countUsersInBatch(List<TailoredAudienceOperation> batch) {
        long totalSize = 0L;
        if (batch == null) {
            return totalSize;
        }
        for (TailoredAudienceOperation operation : batch) {
            totalSize += (long)operation.getUsers().size();
        }
        return totalSize;
    }

    private void fillErrorsInOperation(List<TailoredAudienceOperation> batch, AudienceApiResponse apiResponse) {
        if (CollectionUtils.isEmpty(batch) || CollectionUtils.isEmpty(apiResponse.getErrors()) && CollectionUtils.isEmpty(apiResponse.getOperationErrors())) {
            return;
        }
        int batchSize = batch.size();
        for (int index = 0; index < batchSize; ++index) {
            TailoredAudienceOperation operation = batch.get(index);
            if (CollectionUtils.isNotEmpty(apiResponse.getErrors())) {
                List errors = apiResponse.getErrors().stream().map(ErrorResponse::getMessage).collect(Collectors.toList());
                operation.getErrors().addAll(errors);
            }
            if (!CollectionUtils.isNotEmpty(apiResponse.getOperationErrors()) || !CollectionUtils.isNotEmpty((Collection)apiResponse.getOperationErrors().get(index))) continue;
            List operationErrors = apiResponse.getOperationErrors().get(index).stream().map(ErrorResponse::getMessage).collect(Collectors.toList());
            operation.getOperationErrors().addAll(operationErrors);
        }
    }
}

