/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Optional;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterAdsBiddingApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.ads.BiddingRules;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.ads.TwitterBidInfo;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsBiddingApiImpl
implements TwitterAdsBiddingApi {
    private final TwitterAdsClient twitterAdsClient;

    public TwitterAdsBiddingApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public BaseAdsListResponseIterable<BiddingRules> getBiddingRules(String currency) throws TwitterException {
        ArrayList<HttpParameter> param = new ArrayList<HttpParameter>();
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/bidding_rules";
        if (TwitterAdUtil.isNotNullOrEmpty(currency)) {
            param.add(new HttpParameter("currency", currency));
        }
        Type type = new TypeToken<BaseAdsListResponse<BiddingRules>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, param, type);
    }

    @Override
    public TwitterBidInfo getBidInfo(String accountId, String campaignType, Optional<String> currency, Optional<String> objectiveForBidding) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(campaignType, "campaignType");
        ArrayList params = Lists.newArrayList();
        String baseUrl = "https://ads.twitter.com/accounts/" + accountId + "/campaigns/bid_guidance";
        params.add(new HttpParameter("account", accountId));
        params.add(new HttpParameter("campaign_type", campaignType));
        if (currency != null && currency.isPresent()) {
            params.add(new HttpParameter("currency", currency.get()));
        }
        if (objectiveForBidding != null && objectiveForBidding.isPresent()) {
            params.add(new HttpParameter("objective", objectiveForBidding.get()));
        }
        Type type = new TypeToken<TwitterBidInfo>(){}.getType();
        return (TwitterBidInfo)this.twitterAdsClient.executeRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.GET);
    }
}

