/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.BaseAdsResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterAdsCampaignApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.ads.Campaign;
import twitter4jads.models.ads.EntityStatus;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.ads.TwitterAgreementType;
import twitter4jads.models.ads.TwitterPoliticalDisclaimer;
import twitter4jads.models.ads.TwitterSponsorshipType;
import twitter4jads.models.ads.sort.CampaignSortByField;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsCampaignApiImpl
implements TwitterAdsCampaignApi {
    private static final Integer MAX_REQUEST_PARAMETER_SIZE = 200;
    private final TwitterAdsClient twitterAdsClient;

    public TwitterAdsCampaignApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public BaseAdsListResponseIterable<Campaign> getAllCampaigns(String accountId, Optional<Collection<String>> campaignIds, Optional<Collection<String>> fundingInstrumentIds, boolean withDeleted, Optional<Integer> count, Optional<String> cursor, Optional<CampaignSortByField> sortByField) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        String campaignIdsAsString = null;
        String fundingInstrumentIdsAsString = null;
        if (campaignIds != null && campaignIds.isPresent()) {
            TwitterAdUtil.ensureMaxSize(campaignIds.get(), MAX_REQUEST_PARAMETER_SIZE);
            campaignIdsAsString = TwitterAdUtil.getCsv(campaignIds.get());
        }
        if (fundingInstrumentIds != null && fundingInstrumentIds.isPresent()) {
            TwitterAdUtil.ensureMaxSize(fundingInstrumentIds.get(), MAX_REQUEST_PARAMETER_SIZE);
            fundingInstrumentIdsAsString = TwitterAdUtil.getCsv(fundingInstrumentIds.get());
        }
        List<HttpParameter> params = this.getCampaignParameters(accountId, Optional.ofNullable(campaignIdsAsString), Optional.ofNullable(fundingInstrumentIdsAsString), withDeleted, count, cursor);
        if (sortByField != null && sortByField.isPresent()) {
            params.add(new HttpParameter("sort_by", sortByField.get().getField()));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/campaigns/";
        Type type = new TypeToken<BaseAdsListResponse<Campaign>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<Campaign> getCampaignById(String accountId, String campaignId, boolean withDeleted) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(campaignId, "campaignId");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/campaigns/" + campaignId;
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("with_deleted", withDeleted)};
        Type type = new TypeToken<BaseAdsResponse<Campaign>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params, type, HttpVerb.GET);
    }

    @Override
    public BaseAdsResponse<Campaign> createCampaign(String accountId, Campaign campaign) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        List<HttpParameter> params = this.validateCreateCampaignParameters(campaign);
        HttpParameter[] parameters = null;
        if (!params.isEmpty()) {
            parameters = params.toArray(new HttpParameter[0]);
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/campaigns/";
        Type type = new TypeToken<BaseAdsResponse<Campaign>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, parameters, type, HttpVerb.POST);
    }

    @Override
    public BaseAdsResponse<Campaign> updateCampaign(String accountId, String campaignId, Optional<String> name, Long totalBudgetAmountLocalMicro, Optional<Long> dailyBudgetAmountLocalMicro, Optional<String> startTime, Optional<String> endTime, EntityStatus status, Optional<Boolean> standardDelivery, int frequencyCap, int durationInDays) throws TwitterException {
        List<HttpParameter> params = this.validateUpdateCampaignParameters(accountId, campaignId, name, totalBudgetAmountLocalMicro, dailyBudgetAmountLocalMicro, startTime, endTime, status, standardDelivery, frequencyCap, durationInDays);
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/campaigns/" + campaignId;
        Type type = new TypeToken<BaseAdsResponse<Campaign>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[0]), type, HttpVerb.PUT);
    }

    @Override
    public BaseAdsResponse<Campaign> deleteCampaign(String accountId, String campaignId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(campaignId, "Campaign Id");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/campaigns/" + campaignId;
        Type type = new TypeToken<BaseAdsResponse<Campaign>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsResponse<TwitterPoliticalDisclaimer> publishDisclaimer(String accountId, TwitterPoliticalDisclaimer twitterPoliticalDisclaimer) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        List<HttpParameter> params = this.validateCreateDisclaimerParameters(accountId, twitterPoliticalDisclaimer);
        HttpParameter[] parameters = null;
        if (!params.isEmpty()) {
            parameters = params.toArray(new HttpParameter[0]);
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/political_disclaimers/";
        Type type = new TypeToken<BaseAdsResponse<TwitterPoliticalDisclaimer>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, parameters, type, HttpVerb.POST);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterPoliticalDisclaimer> getDisclaimersByCampaignIds(String accountId, Collection<String> campaignIds) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        String campaignIdsAsString = null;
        if (TwitterAdUtil.isNotNull(campaignIds)) {
            TwitterAdUtil.ensureMaxSize(campaignIds, 200);
            campaignIdsAsString = TwitterAdUtil.getCsv(campaignIds);
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/political_disclaimers/";
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("campaign_ids", campaignIdsAsString));
        params.add(new HttpParameter("with_deleted", true));
        Type type = new TypeToken<BaseAdsListResponse<TwitterPoliticalDisclaimer>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<TwitterPoliticalDisclaimer> updateDisclaimer(String accountId, String disclaimerId, String paidForBy, String paidForByWebsite, String authorizedBy) throws TwitterException {
        List<HttpParameter> params = this.validateUpdateDisclaimerParameters(accountId, disclaimerId, paidForBy, paidForByWebsite, authorizedBy);
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/political_disclaimers/" + disclaimerId;
        Type type = new TypeToken<BaseAdsResponse<TwitterPoliticalDisclaimer>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[0]), type, HttpVerb.PUT);
    }

    private List<HttpParameter> validateCreateCampaignParameters(Campaign campaign) {
        TwitterAdUtil.ensureNotNull(campaign.getName(), "Name");
        String name = campaign.getName();
        TwitterAdUtil.ensureNotNull(campaign.getFundingInstrumentId(), "Funding Instrument ID");
        String fundingInstrumentId = campaign.getFundingInstrumentId();
        TwitterAdUtil.ensureNotNull(campaign.getStartTime(), "Start Time");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String startTime = df.format(campaign.getStartTime());
        TwitterAdUtil.ensureNotNull(campaign.getDailyBudgetInMicro(), "Daily Budget Amount");
        Long dailyBudgetAmountLocalMicro = campaign.getDailyBudgetInMicro();
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        Long totalBudgetAmountLocalMicro = campaign.getTotalBudgetInMicro();
        if (totalBudgetAmountLocalMicro != null) {
            params.add(new HttpParameter("total_budget_amount_local_micro", totalBudgetAmountLocalMicro));
        }
        params.add(new HttpParameter("name", name));
        params.add(new HttpParameter("funding_instrument_id", fundingInstrumentId));
        params.add(new HttpParameter("start_time", startTime));
        params.add(new HttpParameter("daily_budget_amount_local_micro", dailyBudgetAmountLocalMicro));
        if (campaign.getEndTime() != null) {
            String endTime = df.format(campaign.getEndTime());
            params.add(new HttpParameter("end_time", endTime));
        }
        if (campaign.getEntityStatus() != null) {
            params.add(new HttpParameter("entity_status", campaign.getEntityStatus()));
        }
        if (campaign.getStandardDelivery() != null) {
            Boolean standardDelivery = campaign.getStandardDelivery();
            params.add(new HttpParameter("standard_delivery", standardDelivery));
        }
        if (campaign.getFrequencyCap() != null) {
            params.add(new HttpParameter("frequency_cap", campaign.getFrequencyCap()));
        }
        if (campaign.getDurationInDays() != null) {
            params.add(new HttpParameter("duration_in_days", campaign.getDurationInDays()));
        }
        return params;
    }

    private List<HttpParameter> getCampaignParameters(String accountId, Optional<String> campaignIds, Optional<String> fundingInstrumentIds, boolean withDeleted, Optional<Integer> count, Optional<String> cursor) {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (campaignIds != null && campaignIds.isPresent()) {
            params.add(new HttpParameter("campaign_ids", campaignIds.get()));
        }
        if (fundingInstrumentIds != null && fundingInstrumentIds.isPresent()) {
            params.add(new HttpParameter("funding_instrument_ids", fundingInstrumentIds.get()));
        }
        if (count != null && count.isPresent()) {
            params.add(new HttpParameter("count", count.get()));
        }
        if (cursor != null && cursor.isPresent()) {
            params.add(new HttpParameter("cursor", cursor.get()));
        }
        return params;
    }

    private List<HttpParameter> validateUpdateCampaignParameters(String accountId, String campaignId, Optional<String> name, Long totalBudgetAmountLocalMicro, Optional<Long> dailyBudgetAmountLocalMicro, Optional<String> startTime, Optional<String> endTime, EntityStatus status, Optional<Boolean> standardDelivery, int frequencyCap, int durationInDays) {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(campaignId, "Campaign Id");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (totalBudgetAmountLocalMicro == null || totalBudgetAmountLocalMicro >= 0L) {
            params.add(new HttpParameter("total_budget_amount_local_micro", String.valueOf(totalBudgetAmountLocalMicro)));
        }
        if (endTime != null && endTime.isPresent()) {
            params.add(new HttpParameter("end_time", String.valueOf(endTime)));
        }
        if (name != null && name.isPresent()) {
            params.add(new HttpParameter("name", name.get()));
        }
        if (dailyBudgetAmountLocalMicro != null && dailyBudgetAmountLocalMicro.isPresent()) {
            params.add(new HttpParameter("daily_budget_amount_local_micro", dailyBudgetAmountLocalMicro.get()));
        }
        if (startTime != null && startTime.isPresent()) {
            params.add(new HttpParameter("start_time", startTime.get()));
        }
        if (endTime != null && endTime.isPresent()) {
            params.add(new HttpParameter("end_time", endTime.get()));
        }
        if (status != null) {
            params.add(new HttpParameter("entity_status", status.name()));
        }
        if (standardDelivery != null && standardDelivery.isPresent()) {
            params.add(new HttpParameter("standard_delivery", standardDelivery.get()));
        }
        if (frequencyCap > 0) {
            params.add(new HttpParameter("frequency_cap", frequencyCap));
        }
        if (durationInDays > 0) {
            params.add(new HttpParameter("duration_in_days", durationInDays));
        }
        return params;
    }

    private List<HttpParameter> validateUpdateDisclaimerParameters(String accountId, String disclaimerId, String paidForBy, String paidForByWebsite, String authorizedBy) {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(disclaimerId, "Disclaimer Id");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (TwitterAdUtil.isNotNullOrEmpty(paidForBy)) {
            params.add(new HttpParameter("paid_for_by", paidForBy));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(paidForByWebsite)) {
            params.add(new HttpParameter("paid_for_by_website", paidForByWebsite));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(authorizedBy)) {
            params.add(new HttpParameter("authorized_by", authorizedBy));
        }
        return params;
    }

    private List<HttpParameter> validateCreateDisclaimerParameters(String accountId, TwitterPoliticalDisclaimer twitterPoliticalDisclaimer) {
        TwitterAdUtil.ensureNotNull((Object)twitterPoliticalDisclaimer.getSponsorshipType(), "Sponsorship Type");
        TwitterSponsorshipType sponsorshipType = twitterPoliticalDisclaimer.getSponsorshipType();
        TwitterAdUtil.ensureNotNull((Object)twitterPoliticalDisclaimer.getDisclaimerType(), "Disclaimer Type");
        TwitterAgreementType disclaimerType = twitterPoliticalDisclaimer.getDisclaimerType();
        TwitterAdUtil.ensureNotNull(twitterPoliticalDisclaimer.getCampaignId(), "Campaign Id");
        String campaignId = twitterPoliticalDisclaimer.getCampaignId();
        TwitterAdUtil.ensureNotNull(twitterPoliticalDisclaimer.getPaidForBy(), "Paid For By");
        String paidForBy = twitterPoliticalDisclaimer.getPaidForBy();
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("account_id", accountId));
        params.add(new HttpParameter("campaign_id", campaignId));
        params.add(new HttpParameter("disclaimer_type", disclaimerType.name()));
        params.add(new HttpParameter("sponsorship_type", sponsorshipType.name()));
        params.add(new HttpParameter("paid_for_by", paidForBy));
        if (twitterPoliticalDisclaimer.getAuthorizedBy() != null) {
            params.add(new HttpParameter("authorized_by", twitterPoliticalDisclaimer.getAuthorizedBy()));
        }
        if (twitterPoliticalDisclaimer.getPaidForByWebsite() != null) {
            params.add(new HttpParameter("paid_for_by_website", twitterPoliticalDisclaimer.getPaidForByWebsite()));
        }
        return params;
    }
}

