/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.BaseAdsResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterAdsCardsApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.models4j.Media;
import twitter4jads.internal.models4j.MediaUpload;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.ads.TwitterUUIDResponse;
import twitter4jads.models.ads.cards.AbstractConversationCard;
import twitter4jads.models.ads.cards.TwitterImageAppDownloadCard;
import twitter4jads.models.ads.cards.TwitterImageConversationCard;
import twitter4jads.models.ads.cards.TwitterImageDMCard;
import twitter4jads.models.ads.cards.TwitterLeadGenerationStat;
import twitter4jads.models.ads.cards.TwitterVideoAppDownloadCard;
import twitter4jads.models.ads.cards.TwitterVideoConversationCard;
import twitter4jads.models.ads.cards.TwitterVideoDMCard;
import twitter4jads.models.ads.cards.TwitterVideoWebsiteCard;
import twitter4jads.models.ads.cards.TwitterWebsiteCard;
import twitter4jads.models.media.TwitterLibraryMedia;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsCardsApiImpl
implements TwitterAdsCardsApi {
    private final TwitterAdsClient twitterAdsClient;
    private static final int CONVERSATION_CARD_HASHTAG_LENGTH = 20;
    private static final int DM_CARD_CTA_LENGTH = 20;
    private static final int CONVERSATION_CARD_TWEET_LENGTH = 256;

    public TwitterAdsCardsApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public BaseAdsListResponseIterable<TwitterImageAppDownloadCard> getAllImageAppDownloadCards(String accountId, List<String> cardIds, boolean withDeleted, Optional<Integer> count) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (TwitterAdUtil.isNotEmpty(cardIds)) {
            params.add(new HttpParameter("card_ids", TwitterAdUtil.getCsv(cardIds)));
        }
        if (count != null && count.isPresent()) {
            params.add(new HttpParameter("count", count.get()));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/image_app_download/";
        Type type = new TypeToken<BaseAdsListResponse<TwitterImageAppDownloadCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(url, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterVideoAppDownloadCard> getAllVideoAppDownloadCards(String accountId, List<String> cardIds, boolean withDeleted, Optional<Integer> count) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (TwitterAdUtil.isNotEmpty(cardIds)) {
            params.add(new HttpParameter("card_ids", TwitterAdUtil.getCsv(cardIds)));
        }
        if (count != null && count.isPresent()) {
            params.add(new HttpParameter("count", count.get()));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_app_download/";
        Type type = new TypeToken<BaseAdsListResponse<TwitterVideoAppDownloadCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(url, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterImageDMCard> getAllImageDMCards(String accountId, List<String> cardIds, boolean withDeleted, Integer count) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/image_direct_message/";
        Type type = new TypeToken<BaseAdsListResponse<TwitterImageDMCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(url, Lists.newArrayList(), type);
    }

    @Override
    public BaseAdsResponse<TwitterWebsiteCard> deleteWebsiteCard(String accountId, String cardId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(cardId, "Card Id");
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/website/" + cardId;
        Type type = new TypeToken<BaseAdsResponse<TwitterWebsiteCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, null, type, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsResponse<TwitterWebsiteCard> getWebsiteCard(String accountId, String cardId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(cardId, "CardId");
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/website/" + cardId;
        Type type = new TypeToken<BaseAdsResponse<TwitterWebsiteCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, null, type, HttpVerb.GET);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterWebsiteCard> getAllWebsiteCards(String accountId, List<String> cardIds, boolean withDeleted, Optional<Integer> count) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (TwitterAdUtil.isNotEmpty(cardIds)) {
            params.add(new HttpParameter("card_ids", TwitterAdUtil.getCsv(cardIds)));
        }
        if (count != null && count.isPresent()) {
            params.add(new HttpParameter("count", count.get()));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/website/";
        Type type = new TypeToken<BaseAdsListResponse<TwitterWebsiteCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(url, params, type);
    }

    @Override
    public BaseAdsResponse<TwitterVideoAppDownloadCard> deleteVideoAppDownloadCard(String accountId, String cardId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(cardId, "Card Id");
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_app_download/" + cardId;
        Type type = new TypeToken<BaseAdsResponse<TwitterVideoAppDownloadCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, null, type, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsResponse<TwitterImageAppDownloadCard> deleteImageAppDownloadCard(String accountId, String cardId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(cardId, "Card Id");
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/image_app_download/" + cardId;
        Type type = new TypeToken<BaseAdsResponse<TwitterImageAppDownloadCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, null, type, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsResponse<TwitterLeadGenerationStat> getTwitterLeadGenerationStat(String accountId, String cardId, String startTime, Optional<String> endTime, Optional<String> granularity, Optional<String> metric, Optional<Boolean> withDeleted) throws TwitterException {
        List<HttpParameter> params = this.validateAndCreateParamsForLeadGenerationCardStat(accountId, cardId, startTime, endTime, granularity, metric, withDeleted);
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/stats/accounts/" + accountId + "/cards/lead_gen/" + cardId;
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type typeToken = new TypeToken<BaseAdsResponse<TwitterLeadGenerationStat>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, typeToken, HttpVerb.GET);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterImageConversationCard> getAllImageConversationCards(String accountId, List<String> cardIds, boolean withDeleted, Integer count) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (TwitterAdUtil.isNotEmpty(cardIds)) {
            params.add(new HttpParameter("card_ids", TwitterAdUtil.getCsv(cardIds)));
        }
        if (TwitterAdUtil.isNotNull(count)) {
            params.add(new HttpParameter("count", count));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/image_conversation/";
        Type type = new TypeToken<BaseAdsListResponse<TwitterImageConversationCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(url, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterVideoConversationCard> getAllVideoConversationCards(String accountId, List<String> cardIds, boolean withDeleted, Integer count) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (TwitterAdUtil.isNotEmpty(cardIds)) {
            params.add(new HttpParameter("card_ids", TwitterAdUtil.getCsv(cardIds)));
        }
        if (TwitterAdUtil.isNotNull(count)) {
            params.add(new HttpParameter("count", count));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_conversation/";
        Type type = new TypeToken<BaseAdsListResponse<TwitterVideoConversationCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(url, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterVideoWebsiteCard> getAllVideoWebsiteCards(String accountId, List<String> cardIds, boolean withDeleted, Integer count) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (TwitterAdUtil.isNotEmpty(cardIds)) {
            params.add(new HttpParameter("card_ids", TwitterAdUtil.getCsv(cardIds)));
        }
        if (TwitterAdUtil.isNotNull(count)) {
            params.add(new HttpParameter("count", count));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_website/";
        Type type = new TypeToken<BaseAdsListResponse<TwitterVideoWebsiteCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(url, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterVideoDMCard> getAllVideoDMCards(String accountId, List<String> cardIds, boolean withDeleted, Integer count) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (TwitterAdUtil.isNotEmpty(cardIds)) {
            params.add(new HttpParameter("card_ids", TwitterAdUtil.getCsv(cardIds)));
        }
        if (TwitterAdUtil.isNotNull(count)) {
            params.add(new HttpParameter("count", count));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_direct_message/";
        Type type = new TypeToken<BaseAdsListResponse<TwitterVideoDMCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(url, params, type);
    }

    @Override
    public BaseAdsResponse<TwitterWebsiteCard> updateWebsiteCard(String accountId, String name, String cardId, String websiteTitle, String websiteUrl, String imageMediaId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(cardId, "Card Id");
        List<HttpParameter> params = this.validateAndCreateParamsForCreateWebsiteCard(accountId, name, websiteTitle, websiteUrl, imageMediaId);
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/website/" + cardId;
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterWebsiteCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.PUT);
    }

    @Override
    public BaseAdsResponse<TwitterWebsiteCard> createWebsiteCard(String accountId, String name, String websiteTitle, String websiteUrl, String imageMediaId) throws TwitterException {
        List<HttpParameter> params = this.validateAndCreateParamsForCreateWebsiteCard(accountId, name, websiteTitle, websiteUrl, imageMediaId);
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/website/";
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterWebsiteCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.POST);
    }

    @Override
    public BaseAdsResponse<TwitterImageAppDownloadCard> createImageAppDownloadCard(String accountId, String name, String countryCode, String iphoneAppId, String ipadAppId, String googlePlayAppId, String iphoneDeepLink, String ipadDeepLink, String googlePlayDeepLink, String imageMediaId, String callToAction) throws TwitterException {
        List<HttpParameter> params = this.validateAndCreateParamsForCreateImageAppDownloadCard(accountId, name, countryCode, iphoneAppId, ipadAppId, googlePlayAppId, iphoneDeepLink, ipadDeepLink, googlePlayDeepLink, imageMediaId, callToAction);
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/image_app_download/";
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterImageAppDownloadCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.POST);
    }

    @Override
    public BaseAdsResponse<TwitterImageAppDownloadCard> updateImageAppDownloadCard(String accountId, String name, String cardId, String countryCode, String iphoneAppId, String ipadAppId, String googlePlayAppId, String iphoneDeepLink, String ipadDeepLink, String googlePlayDeepLink, String imageMediaId, String callToAction) throws TwitterException {
        TwitterAdUtil.ensureNotNull(cardId, "Card Id");
        List<HttpParameter> params = this.validateAndCreateParamsForUpdateImageAppDownloadCard(accountId, name, countryCode, iphoneAppId, ipadAppId, googlePlayAppId, iphoneDeepLink, ipadDeepLink, googlePlayDeepLink, imageMediaId, callToAction);
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/image_app_download/" + cardId;
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterImageAppDownloadCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.PUT);
    }

    @Override
    public BaseAdsResponse<TwitterVideoAppDownloadCard> createVideoAppDownloadCard(String accountId, String name, String countryCode, String iphoneAppId, String ipadAppId, String googlePlayAppId, String iphoneDeepLink, String ipadDeepLink, String googlePlayDeepLink, String imageMediaId, String callToAction, TwitterLibraryMedia video) throws TwitterException, IOException, InterruptedException {
        List<HttpParameter> params = this.validateAndCreateParamsForCreateVideoAppDownloadCard(accountId, name, countryCode, iphoneAppId, ipadAppId, googlePlayAppId, iphoneDeepLink, ipadDeepLink, googlePlayDeepLink, imageMediaId, video.getMediaKey(), callToAction);
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_app_download/";
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterVideoAppDownloadCard>>(){}.getType();
        BaseAdsResponse<TwitterVideoAppDownloadCard> twitterVideoAppDownloadResponse = this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.POST);
        TwitterVideoAppDownloadCard videoAppDownloadCard = (TwitterVideoAppDownloadCard)twitterVideoAppDownloadResponse.getData();
        if (video.getMediaKey() != null) {
            videoAppDownloadCard.setChannelVideoId(video.getMediaKey());
        }
        if (video.getMediaUrl() != null) {
            videoAppDownloadCard.setChannelVideoUrl(video.getMediaUrl());
        }
        if (video.getDuration() != null) {
            videoAppDownloadCard.setChannelVideoLength(video.getDuration().toString());
        }
        videoAppDownloadCard.setChannelImageId(imageMediaId);
        return twitterVideoAppDownloadResponse;
    }

    @Override
    public BaseAdsResponse<TwitterVideoAppDownloadCard> updateVideoAppDownloadCard(String accountId, String name, String cardId, String countryCode, String iphoneAppId, String ipadAppId, String googlePlayAppId, String iphoneDeepLink, String ipadDeepLink, String googlePlayDeepLink, String imageMediaId, String callToActionValue, TwitterLibraryMedia video) throws TwitterException, IOException, InterruptedException {
        TwitterAdUtil.ensureNotNull(cardId, "Card Id");
        String channelVideoId = null;
        if (video != null) {
            channelVideoId = video.getMediaKey();
        }
        List<HttpParameter> params = this.validateAndCreateParamsForUpdateVideoAppDownloadCard(accountId, name, countryCode, iphoneAppId, ipadAppId, googlePlayAppId, iphoneDeepLink, ipadDeepLink, googlePlayDeepLink, imageMediaId, channelVideoId, callToActionValue);
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_app_download/" + cardId;
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterVideoAppDownloadCard>>(){}.getType();
        BaseAdsResponse<TwitterVideoAppDownloadCard> twitterVideoAppDownloadResponse = this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.PUT);
        TwitterVideoAppDownloadCard videoAppDownloadCard = (TwitterVideoAppDownloadCard)twitterVideoAppDownloadResponse.getData();
        if (video != null) {
            videoAppDownloadCard.setChannelVideoId(video.getMediaKey());
        }
        if (video != null) {
            videoAppDownloadCard.setChannelVideoUrl(video.getMediaUrl());
        }
        if (video != null) {
            videoAppDownloadCard.setChannelVideoLength(video.getDuration().toString());
        }
        videoAppDownloadCard.setChannelImageId(imageMediaId);
        return twitterVideoAppDownloadResponse;
    }

    @Override
    public BaseAdsResponse<TwitterImageConversationCard> createImageConversationCard(String accountId, String name, String title, String firstHashtag, String firstTweet, String secondHashtag, String secondTweet, String thirdHashtag, String thirdTweet, String fourthHashtag, String fourthTweet, String thanksText, String thanksUrl, String imageUrl, String imageMediaId) throws TwitterException {
        List<HttpParameter> params = this.validateAndCreateParamsForCreateImageConversationCard(accountId, name, title, firstHashtag, firstTweet, secondHashtag, secondTweet, thirdHashtag, thirdTweet, fourthHashtag, fourthTweet, thanksText, thanksUrl, imageUrl);
        params.add(new HttpParameter("image_media_id", imageMediaId));
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/image_conversation/";
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterImageConversationCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.POST);
    }

    @Override
    public BaseAdsResponse<TwitterImageConversationCard> updateImageConversationCard(String accountId, String cardId, String name, String title, String firstHashtag, String firstTweet, String secondHashtag, String secondTweet, String thirdHashtag, String thirdTweet, String fourthHashtag, String fourthTweet, String thanksText, String thanksUrl, String imageUrl, String imageMediaId) throws TwitterException {
        BaseAdsResponse<TwitterImageConversationCard> response = this.getImageConversationCard(accountId, cardId);
        TwitterImageConversationCard existingCard = response.getData();
        List<HttpParameter> params = this.validateAndCreateParamsForUpdateImageConversationCard(accountId, name, title, firstHashtag, firstTweet, secondHashtag, secondTweet, thirdHashtag, thirdTweet, fourthHashtag, fourthTweet, thanksText, thanksUrl, imageUrl, existingCard);
        params.add(new HttpParameter("image_media_id", imageMediaId));
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/image_conversation/" + cardId;
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterImageConversationCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.PUT);
    }

    @Override
    public BaseAdsResponse<TwitterImageConversationCard> deleteImageConversationCard(String accountId, String cardId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(cardId, "Card Id");
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/image_conversation/" + cardId;
        Type type = new TypeToken<BaseAdsResponse<TwitterImageConversationCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, null, type, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsResponse<TwitterVideoConversationCard> createVideoConversationCard(String accountId, String name, String title, String firstHashtag, String firstTweet, String secondHashtag, String secondTweet, String thirdHashtag, String thirdTweet, String fourthHashtag, String fourthTweet, String thanksText, String thanksUrl, String imageMediaId, TwitterLibraryMedia twitterVideo) throws TwitterException {
        TwitterAdUtil.ensureNotNull(twitterVideo.getMediaKey(), "Video Key");
        List<HttpParameter> params = this.validateAndCreateParamsForCreateVideoConversationCard(accountId, name, title, firstHashtag, firstTweet, secondHashtag, secondTweet, thirdHashtag, thirdTweet, fourthHashtag, fourthTweet, thanksText, thanksUrl);
        if (TwitterAdUtil.isNotNullOrEmpty(imageMediaId)) {
            params.add(new HttpParameter("image_media_id", imageMediaId));
        }
        params.add(new HttpParameter("video_id", twitterVideo.getMediaKey()));
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_conversation/";
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterVideoConversationCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.POST);
    }

    @Override
    public BaseAdsResponse<TwitterVideoConversationCard> updateVideoConversationCard(String accountId, String cardId, String name, String title, String firstHashtag, String firstTweet, String secondHashtag, String secondTweet, String thirdHashtag, String thirdTweet, String fourthHashtag, String fourthTweet, String thanksText, String thanksUrl, String imageMediaId, TwitterLibraryMedia twitterVideo) throws TwitterException {
        BaseAdsResponse<TwitterVideoConversationCard> response = this.getVideoConversationCard(accountId, cardId);
        TwitterVideoConversationCard existingCard = response.getData();
        List<HttpParameter> params = this.validateAndCreateParamsForUpdateVideoConversationCard(accountId, name, title, firstHashtag, firstTweet, secondHashtag, secondTweet, thirdHashtag, thirdTweet, fourthHashtag, fourthTweet, thanksText, thanksUrl, existingCard);
        if (TwitterAdUtil.isNotNullOrEmpty(imageMediaId)) {
            params.add(new HttpParameter("image_media_id", imageMediaId));
        }
        if (twitterVideo != null) {
            params.add(new HttpParameter("video_id", twitterVideo.getMediaKey()));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_conversation/" + cardId;
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterVideoConversationCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.PUT);
    }

    @Override
    public BaseAdsResponse<TwitterVideoConversationCard> deleteVideoConversationCard(String accountId, String cardId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(cardId, "Card Id");
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_conversation/" + cardId;
        Type type = new TypeToken<BaseAdsResponse<TwitterVideoConversationCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, null, type, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsResponse<TwitterImageDMCard> createImageDMCard(String accountId, String name, String firstCta, Long firstWelcomeMessageId, String secondCta, Long secondWelcomeMessageId, String thirdCta, Long thirdWelcomeMessageId, String fourthCta, Long fourthWelcomeMessageId, Long recipientAccountId, String imageUrl, String imageMediaId) throws TwitterException {
        List<HttpParameter> params = this.validateAndCreateParamsForCreateImageDMCard(accountId, name, firstCta, firstWelcomeMessageId, secondCta, secondWelcomeMessageId, thirdCta, thirdWelcomeMessageId, fourthCta, fourthWelcomeMessageId, recipientAccountId, imageUrl);
        params.add(new HttpParameter("image_media_id", imageMediaId));
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/image_direct_message/";
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterImageDMCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.POST);
    }

    @Override
    public BaseAdsResponse<TwitterVideoDMCard> createVideoDMCard(String accountId, String name, String firstCta, Long firstWelcomeMessageId, String secondCta, Long secondWelcomeMessageId, String thirdCta, Long thirdWelcomeMessageId, String fourthCta, Long fourthWelcomeMessageId, Long recipientAccountId, String imageUrl, String videoUrl, String imageMediaId, String videoMediaKey) throws TwitterException {
        List<HttpParameter> params = this.validateAndCreateParamsForCreateVideoDMCard(accountId, name, firstCta, firstWelcomeMessageId, secondCta, secondWelcomeMessageId, thirdCta, thirdWelcomeMessageId, fourthCta, fourthWelcomeMessageId, recipientAccountId, videoUrl);
        if (StringUtils.isNotBlank((CharSequence)imageMediaId)) {
            params.add(new HttpParameter("image_media_id", imageMediaId));
        }
        params.add(new HttpParameter("video_id", videoMediaKey));
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_direct_message/";
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterVideoDMCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.POST);
    }

    @Override
    public BaseAdsResponse<TwitterImageDMCard> updateImageDMCard(String accountId, String name, String firstCta, Long firstWelcomeMessageId, String secondCta, Long secondWelcomeMessageId, String thirdCta, Long thirdWelcomeMessageId, String fourthCta, Long fourthWelcomeMessageId, String imageUrl, String imageMediaId, String channelId) throws TwitterException {
        List<HttpParameter> params = this.validateAndCreateParamsForUpdateDMCard(accountId, name, firstCta, firstWelcomeMessageId, secondCta, secondWelcomeMessageId, thirdCta, thirdWelcomeMessageId, fourthCta, fourthWelcomeMessageId, channelId);
        if (StringUtils.isNotBlank((CharSequence)imageMediaId)) {
            params.add(new HttpParameter("image_media_id", imageMediaId));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/image_direct_message/" + channelId;
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterImageDMCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.PUT);
    }

    @Override
    public BaseAdsResponse<TwitterVideoDMCard> updateVideoDMCard(String accountId, String name, String firstCta, Long firstWelcomeMessageId, String secondCta, Long secondWelcomeMessageId, String thirdCta, Long thirdWelcomeMessageId, String fourthCta, Long fourthWelcomeMessageId, String imageUrl, String videoUrl, String imageMediaId, String videoMediaKey, String channelId) throws TwitterException {
        List<HttpParameter> params = this.validateAndCreateParamsForUpdateDMCard(accountId, name, firstCta, firstWelcomeMessageId, secondCta, secondWelcomeMessageId, thirdCta, thirdWelcomeMessageId, fourthCta, fourthWelcomeMessageId, channelId);
        if (StringUtils.isNotBlank((CharSequence)imageMediaId)) {
            params.add(new HttpParameter("image_media_id", imageMediaId));
        }
        if (StringUtils.isNotBlank((CharSequence)videoMediaKey)) {
            params.add(new HttpParameter("video_id", videoMediaKey));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_direct_message/" + channelId;
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterVideoDMCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.PUT);
    }

    @Override
    public BaseAdsResponse<TwitterImageDMCard> deleteImageDMCard(String accountId, String cardId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(cardId, "Card Id");
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/image_direct_message/" + cardId;
        Type type = new TypeToken<BaseAdsResponse<TwitterImageDMCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, null, type, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsResponse<TwitterVideoDMCard> deleteVideoDMCard(String accountId, String cardId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(cardId, "Card Id");
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_direct_message/" + cardId;
        Type type = new TypeToken<BaseAdsResponse<TwitterVideoDMCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, null, type, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsResponse<TwitterVideoWebsiteCard> createVideoWebsiteCard(String accountId, String name, String title, String videoKey, String websiteUrl) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(name, "Name");
        TwitterAdUtil.ensureNotNull(title, "Title");
        TwitterAdUtil.ensureNotNull(videoKey, "Video Key");
        TwitterAdUtil.ensureNotNull(websiteUrl, "Website url");
        this.verifyLength(name, "Name", 80L);
        this.verifyLength(title, "Title", 70L);
        List<HttpParameter> params = this.validateAndCreateParamsForCreateVideoWebsiteCard(accountId, name, title, videoKey, websiteUrl);
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_website/";
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterVideoWebsiteCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.POST);
    }

    @Override
    public BaseAdsResponse<TwitterVideoWebsiteCard> updateVideoWebsiteCard(String accountId, String cardId, String name, String title, String videoKey, String websiteUrl) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(cardId, "Card Id");
        List<HttpParameter> params = this.validateAndCreateParamsForUpdateVideoWebsiteCard(name, title, videoKey, websiteUrl);
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_website/" + cardId;
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterVideoWebsiteCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.PUT);
    }

    @Override
    public BaseAdsResponse<TwitterVideoWebsiteCard> deleteVideoWebsiteCard(String accountId, String cardId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(cardId, "Card Id");
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_website/" + cardId;
        Type type = new TypeToken<BaseAdsResponse<TwitterVideoWebsiteCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, null, type, HttpVerb.DELETE);
    }

    @Override
    public String postVideoCardImage(String imageTonLocation) throws TwitterException {
        TwitterAdUtil.ensureNotNull(imageTonLocation, "imageTonLocation");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("location", imageTonLocation));
        TwitterUUIDResponse twitterUUIDResponse = (TwitterUUIDResponse)this.twitterAdsClient.executeRequest("https://video.twitter.com/api/v1/images", params.toArray(new HttpParameter[params.size()]), (Type)((Object)TwitterUUIDResponse.class), HttpVerb.POST);
        return twitterUUIDResponse.getuUID();
    }

    private String getMediaId(String image) {
        Media media;
        try {
            TwitterAdUtil.ensureNotNull(image, "image");
            InputStream fileBody = new URL(image).openStream();
            media = this.twitterAdsClient.upload(new MediaUpload(fileBody));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (media != null) {
            return media.getMediaIdString();
        }
        return null;
    }

    private BaseAdsResponse<TwitterVideoConversationCard> getVideoConversationCard(String accountId, String cardId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/video_conversation/" + cardId;
        Type type = new TypeToken<BaseAdsResponse<TwitterVideoConversationCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, null, type, HttpVerb.GET);
    }

    private List<HttpParameter> validateAndCreateParamsForCreateWebsiteCard(String accountId, String name, String websiteTitle, String websiteUrl, String mediaId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(name, "Name");
        TwitterAdUtil.ensureNotNull(websiteTitle, "WebsiteTitle");
        TwitterAdUtil.ensureNotNull(websiteUrl, "WebsiteUrl");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("name", name));
        params.add(new HttpParameter("website_title", websiteTitle));
        params.add(new HttpParameter("website_url", websiteUrl));
        if (TwitterAdUtil.isNotNullOrEmpty(mediaId)) {
            params.add(new HttpParameter("image_media_id", mediaId));
        }
        return params;
    }

    private void verifyHashtagLength(String hashtag, String label) throws TwitterException {
        if (hashtag.length() > 20) {
            throw new TwitterException(new UnsupportedOperationException(label + " cannot be more than " + 20 + " characters"));
        }
    }

    private void verifyTweetLength(String tweet, String label) throws TwitterException {
        if (tweet.length() > 256) {
            throw new TwitterException(new UnsupportedOperationException(label + " cannot be more than " + 256 + " characters"));
        }
    }

    private List<HttpParameter> validateAndCreateParamsForUpdateConversationCard(String accountId, String name, String title, String firstHashtag, String firstTweet, String secondHashtag, String secondTweet, String thirdHashtag, String thirdTweet, String fourthHashtag, String fourthTweet, String thanksText, String thanksUrl, AbstractConversationCard existingCard) throws TwitterException {
        List<HttpParameter> params = this.validateAndCreateParamsForCreateConversationCard(accountId, name, title, firstHashtag, firstTweet, secondHashtag, secondTweet, thirdHashtag, thirdTweet, fourthHashtag, fourthTweet, thanksText, thanksUrl);
        if (!TwitterAdUtil.isNotNullOrEmpty(title) && TwitterAdUtil.isNotNullOrEmpty(existingCard.getTitle())) {
            params.add(new HttpParameter("title", ""));
        }
        if (!TwitterAdUtil.isNotNullOrEmpty(secondHashtag) && TwitterAdUtil.isNotNullOrEmpty(existingCard.getSecondHashtag())) {
            params.add(new HttpParameter("second_cta", ""));
        }
        if (!TwitterAdUtil.isNotNullOrEmpty(secondTweet) && TwitterAdUtil.isNotNullOrEmpty(existingCard.getSecondTweet())) {
            params.add(new HttpParameter("second_cta_tweet", ""));
        }
        if (!TwitterAdUtil.isNotNullOrEmpty(thirdHashtag) && TwitterAdUtil.isNotNullOrEmpty(existingCard.getThirdHashtag())) {
            params.add(new HttpParameter("third_cta", ""));
        }
        if (!TwitterAdUtil.isNotNullOrEmpty(thirdTweet) && TwitterAdUtil.isNotNullOrEmpty(existingCard.getThirdTweet())) {
            params.add(new HttpParameter("third_cta_tweet", ""));
        }
        if (!TwitterAdUtil.isNotNullOrEmpty(fourthHashtag) && TwitterAdUtil.isNotNullOrEmpty(existingCard.getFourthHashtag())) {
            params.add(new HttpParameter("fourth_cta", ""));
        }
        if (!TwitterAdUtil.isNotNullOrEmpty(fourthTweet) && TwitterAdUtil.isNotNullOrEmpty(existingCard.getFourthTweet())) {
            params.add(new HttpParameter("fourth_cta_tweet", ""));
        }
        if (!TwitterAdUtil.isNotNullOrEmpty(thanksUrl) && TwitterAdUtil.isNotNullOrEmpty(existingCard.getThankUrl())) {
            params.add(new HttpParameter("thank_you_url", ""));
        }
        return params;
    }

    private List<HttpParameter> validateAndCreateParamsForCreateAppDownloadCard(String accountId, String name, String countryCode, String iphoneAppId, String ipadAppId, String googlePlayAppId, String iphoneDeepLink, String ipadDeepLink, String googlePlayDeepLink, String customAppDescription, String mediaId, String callToAction) throws TwitterException {
        List<HttpParameter> params = this.getCardHttpParameters(accountId, name, countryCode, iphoneAppId, ipadAppId, googlePlayAppId, iphoneDeepLink, ipadDeepLink, googlePlayDeepLink);
        if (TwitterAdUtil.isNotNullOrEmpty(mediaId)) {
            params.add(new HttpParameter("custom_icon_media_id", mediaId));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(callToAction)) {
            params.add(new HttpParameter("app_cta", callToAction));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(customAppDescription)) {
            params.add(new HttpParameter("custom_app_description", customAppDescription));
        }
        return params;
    }

    private List<HttpParameter> validateAndCreateParamsForUpdateVideoConversationCard(String accountId, String name, String title, String firstHashtag, String firstTweet, String secondHashtag, String secondTweet, String thirdHashtag, String thirdTweet, String fourthHashtag, String fourthTweet, String thanksText, String thanksUrl, TwitterVideoConversationCard existingCard) throws TwitterException {
        return this.validateAndCreateParamsForUpdateConversationCard(accountId, name, title, firstHashtag, firstTweet, secondHashtag, secondTweet, thirdHashtag, thirdTweet, fourthHashtag, fourthTweet, thanksText, thanksUrl, existingCard);
    }

    private List<HttpParameter> getCardHttpParameters(String accountId, String name, String countryCode, String iphoneAppId, String ipadAppId, String googlePlayAppId, String iphoneDeepLink, String ipadDeepLink, String googlePlayDeepLink) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(countryCode, "App Country Code");
        TwitterAdUtil.ensureNotNull(name, "Name");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("name", name));
        params.add(new HttpParameter("country_code", countryCode));
        if (!(TwitterAdUtil.isNotNullOrEmpty(googlePlayAppId) || TwitterAdUtil.isNotNullOrEmpty(ipadAppId) || TwitterAdUtil.isNotNullOrEmpty(iphoneAppId))) {
            throw new TwitterException(new UnsupportedOperationException("Please provide atleast one valid store app id to create an app download card"));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(iphoneAppId)) {
            params.add(new HttpParameter("iphone_app_id", iphoneAppId));
            if (TwitterAdUtil.isNotNullOrEmpty(iphoneDeepLink)) {
                params.add(new HttpParameter("iphone_deep_link", iphoneDeepLink));
            }
        }
        if (TwitterAdUtil.isNotNullOrEmpty(ipadAppId)) {
            params.add(new HttpParameter("ipad_app_id", ipadAppId));
            if (TwitterAdUtil.isNotNullOrEmpty(ipadDeepLink)) {
                params.add(new HttpParameter("ipad_deep_link", ipadDeepLink));
            }
        }
        if (TwitterAdUtil.isNotNullOrEmpty(googlePlayAppId)) {
            params.add(new HttpParameter("googleplay_app_id", googlePlayAppId));
            if (TwitterAdUtil.isNotNullOrEmpty(googlePlayDeepLink)) {
                params.add(new HttpParameter("googleplay_deep_link", googlePlayDeepLink));
            }
        }
        return params;
    }

    private List<HttpParameter> validateAndCreateParamsForLeadGenerationCardStat(String accountId, String cardId, String startTime, Optional<String> endTime, Optional<String> granularity, Optional<String> metric, Optional<Boolean> withDeleted) {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(cardId, "CardId");
        TwitterAdUtil.ensureNotNull(startTime, "StartTime");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("start_time", startTime));
        if (endTime != null && endTime.isPresent()) {
            params.add(new HttpParameter("end_time", endTime.get()));
        }
        if (granularity != null && granularity.isPresent()) {
            params.add(new HttpParameter("granularity", granularity.get()));
        }
        if (metric != null && metric.isPresent()) {
            params.add(new HttpParameter("metrics", metric.get()));
        }
        if (withDeleted != null && withDeleted.isPresent()) {
            params.add(new HttpParameter("with_deleted", withDeleted.get()));
        }
        return params;
    }

    private BaseAdsResponse<TwitterImageConversationCard> getImageConversationCard(String accountId, String cardId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/cards/image_conversation/" + cardId;
        Type type = new TypeToken<BaseAdsResponse<TwitterImageConversationCard>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, null, type, HttpVerb.GET);
    }

    private List<HttpParameter> validateAndCreateParamsForUpdateAppDownloadCard(String accountId, String name, String countryCode, String iphoneAppId, String ipadAppId, String googlePlayAppId, String iphoneDeepLink, String ipadDeepLink, String googlePlayDeepLink, String customAppDescription, String mediaId, String callToAction) throws TwitterException {
        List<HttpParameter> params = this.getCardHttpParametersForUpdate(accountId, name, countryCode, iphoneAppId, ipadAppId, googlePlayAppId, iphoneDeepLink, ipadDeepLink, googlePlayDeepLink);
        if (TwitterAdUtil.isNotNullOrEmpty(mediaId)) {
            params.add(new HttpParameter("custom_icon_media_id", mediaId));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(callToAction)) {
            params.add(new HttpParameter("app_cta", callToAction));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(customAppDescription)) {
            params.add(new HttpParameter("custom_app_description", customAppDescription));
        }
        return params;
    }

    private List<HttpParameter> validateAndCreateParamsForCreateVideoConversationCard(String accountId, String name, String title, String firstHashtag, String firstTweet, String secondHashtag, String secondTweet, String thirdHashtag, String thirdTweet, String fourthHashtag, String fourthTweet, String thanksText, String thanksUrl) throws TwitterException {
        return this.validateAndCreateParamsForCreateConversationCard(accountId, name, title, firstHashtag, firstTweet, secondHashtag, secondTweet, thirdHashtag, thirdTweet, fourthHashtag, fourthTweet, thanksText, thanksUrl);
    }

    private List<HttpParameter> getCardHttpParametersForUpdate(String accountId, String name, String countryCode, String iphoneAppId, String ipadAppId, String googlePlayAppId, String iphoneDeepLink, String ipadDeepLink, String googlePlayDeepLink) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(countryCode, "App Country Code");
        TwitterAdUtil.ensureNotNull(name, "Name");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("name", name));
        params.add(new HttpParameter("country_code", countryCode));
        if (!(TwitterAdUtil.isNotNullOrEmpty(googlePlayAppId) || TwitterAdUtil.isNotNullOrEmpty(ipadAppId) || TwitterAdUtil.isNotNullOrEmpty(iphoneAppId))) {
            throw new TwitterException(new UnsupportedOperationException("Please provide atleast one valid store app id to create an app download card"));
        }
        iphoneAppId = iphoneAppId == null ? "" : iphoneAppId;
        iphoneDeepLink = iphoneDeepLink == null ? "" : iphoneDeepLink;
        ipadAppId = ipadAppId == null ? "" : ipadAppId;
        ipadDeepLink = ipadDeepLink == null ? "" : ipadDeepLink;
        googlePlayAppId = googlePlayAppId == null ? "" : googlePlayAppId;
        googlePlayDeepLink = googlePlayDeepLink == null ? "" : googlePlayDeepLink;
        params.add(new HttpParameter("iphone_app_id", iphoneAppId));
        params.add(new HttpParameter("iphone_deep_link", iphoneDeepLink));
        params.add(new HttpParameter("ipad_app_id", ipadAppId));
        params.add(new HttpParameter("ipad_deep_link", ipadDeepLink));
        params.add(new HttpParameter("googleplay_app_id", googlePlayAppId));
        params.add(new HttpParameter("googleplay_deep_link", googlePlayDeepLink));
        return params;
    }

    private List<HttpParameter> validateAndCreateParamsForCreateImageAppDownloadCard(String accountId, String name, String countryCode, String iphoneAppId, String ipadAppId, String googlePlayAppId, String iphoneDeepLink, String ipadDeepLink, String googlePlayDeepLink, String mediaId, String callToAction) throws TwitterException {
        List<HttpParameter> params = this.getCardHttpParameters(accountId, name, countryCode, iphoneAppId, ipadAppId, googlePlayAppId, iphoneDeepLink, ipadDeepLink, googlePlayDeepLink);
        if (TwitterAdUtil.isNotNullOrEmpty(mediaId)) {
            params.add(new HttpParameter("wide_app_image_media_id", mediaId));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(callToAction)) {
            params.add(new HttpParameter("app_cta", callToAction));
        }
        return params;
    }

    private List<HttpParameter> validateAndCreateParamsForUpdateImageAppDownloadCard(String accountId, String name, String countryCode, String iphoneAppId, String ipadAppId, String googlePlayAppId, String iphoneDeepLink, String ipadDeepLink, String googlePlayDeepLink, String mediaId, String callToAction) throws TwitterException {
        List<HttpParameter> params = this.getCardHttpParametersForUpdate(accountId, name, countryCode, iphoneAppId, ipadAppId, googlePlayAppId, iphoneDeepLink, ipadDeepLink, googlePlayDeepLink);
        if (TwitterAdUtil.isNotNullOrEmpty(mediaId)) {
            params.add(new HttpParameter("wide_app_image_media_id", mediaId));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(callToAction)) {
            params.add(new HttpParameter("app_cta", callToAction));
        }
        return params;
    }

    private List<HttpParameter> validateAndCreateParamsForCreateImageConversationCard(String accountId, String name, String title, String firstHashtag, String firstTweet, String secondHashtag, String secondTweet, String thirdHashtag, String thirdTweet, String fourthHashtag, String fourthTweet, String thanksText, String thanksUrl, String imageUrl) throws TwitterException {
        TwitterAdUtil.ensureNotNull(imageUrl, "Image");
        return this.validateAndCreateParamsForCreateConversationCard(accountId, name, title, firstHashtag, firstTweet, secondHashtag, secondTweet, thirdHashtag, thirdTweet, fourthHashtag, fourthTweet, thanksText, thanksUrl);
    }

    private List<HttpParameter> validateAndCreateParamsForCreateConversationCard(String accountId, String name, String title, String firstHashtag, String firstTweet, String secondHashtag, String secondTweet, String thirdHashtag, String thirdTweet, String fourthHashtag, String fourthTweet, String thanksText, String thanksUrl) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(name, "Name");
        TwitterAdUtil.ensureNotNull(firstHashtag, "First Cta Hashtag");
        TwitterAdUtil.ensureNotNull(firstTweet, "First Cta Tweet");
        TwitterAdUtil.ensureNotNull(thanksText, "Thanks tweet text");
        this.verifyHashtagLength(firstHashtag, "First hashtag");
        this.verifyTweetLength(firstTweet, "First Tweet");
        if (TwitterAdUtil.isNotNullOrEmpty(title) && TwitterAdUtil.isNotNullOrEmpty(secondHashtag)) {
            throw new TwitterException(new UnsupportedOperationException("Card Title cannot be used with second hashtag"));
        }
        if (!TwitterAdUtil.isNotNullOrEmpty(title) && !TwitterAdUtil.isNotNullOrEmpty(secondHashtag)) {
            throw new TwitterException(new UnsupportedOperationException("Atleast one of card title or second hashtag is compulsory"));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(secondHashtag) && !TwitterAdUtil.isNotNullOrEmpty(secondTweet)) {
            throw new TwitterException(new UnsupportedOperationException("Please provide tweet along with second hashtag"));
        }
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("name", name));
        params.add(new HttpParameter("first_cta", firstHashtag));
        params.add(new HttpParameter("first_cta_tweet", firstTweet));
        params.add(new HttpParameter("thank_you_text", thanksText));
        if (TwitterAdUtil.isNotNull(title)) {
            params.add(new HttpParameter("title", title));
        }
        if (TwitterAdUtil.isNotNull(secondHashtag)) {
            this.verifyHashtagLength(secondHashtag, "Second hashtag");
            params.add(new HttpParameter("second_cta", secondHashtag));
        }
        if (TwitterAdUtil.isNotNull(secondTweet)) {
            this.verifyTweetLength(secondTweet, "Second Tweet");
            params.add(new HttpParameter("second_cta_tweet", secondTweet));
        }
        if (TwitterAdUtil.isNotNull(thirdHashtag)) {
            this.verifyHashtagLength(thirdHashtag, "Third hashtag");
            params.add(new HttpParameter("third_cta", thirdHashtag));
        }
        if (TwitterAdUtil.isNotNull(thirdTweet)) {
            this.verifyTweetLength(thirdTweet, "Third Tweet");
            params.add(new HttpParameter("third_cta_tweet", thirdTweet));
        }
        if (TwitterAdUtil.isNotNull(fourthHashtag)) {
            this.verifyHashtagLength(fourthHashtag, "Fourth hashtag");
            params.add(new HttpParameter("fourth_cta", fourthHashtag));
        }
        if (TwitterAdUtil.isNotNull(fourthTweet)) {
            this.verifyTweetLength(fourthTweet, "Fourth Tweet");
            params.add(new HttpParameter("fourth_cta_tweet", fourthTweet));
        }
        if (TwitterAdUtil.isNotNull(thanksUrl)) {
            params.add(new HttpParameter("thank_you_url", thanksUrl));
        }
        return params;
    }

    private List<HttpParameter> validateAndCreateParamsForCreateVideoAppDownloadCard(String accountId, String name, String countryCode, String iphoneAppId, String ipadAppId, String googlePlayAppId, String iphoneDeepLink, String ipadDeepLink, String googlePlayDeepLink, String posterMediaId, String videoMediaId, String callToAction) throws TwitterException {
        List<HttpParameter> params = this.getCardHttpParameters(accountId, name, countryCode, iphoneAppId, ipadAppId, googlePlayAppId, iphoneDeepLink, ipadDeepLink, googlePlayDeepLink);
        if (TwitterAdUtil.isNotNullOrEmpty(videoMediaId)) {
            params.add(new HttpParameter("video_id", videoMediaId));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(posterMediaId)) {
            params.add(new HttpParameter("image_media_id", posterMediaId));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(callToAction)) {
            params.add(new HttpParameter("app_cta", callToAction));
        }
        return params;
    }

    private List<HttpParameter> validateAndCreateParamsForUpdateVideoAppDownloadCard(String accountId, String name, String countryCode, String iphoneAppId, String ipadAppId, String googlePlayAppId, String iphoneDeepLink, String ipadDeepLink, String googlePlayDeepLink, String imageMediaId, String videoMediaId, String callToAction) throws TwitterException {
        List<HttpParameter> params = this.getVideoCardHttpParametersForUpdate(accountId, name, countryCode, iphoneAppId, ipadAppId, googlePlayAppId, iphoneDeepLink, ipadDeepLink, googlePlayDeepLink);
        if (TwitterAdUtil.isNotNullOrEmpty(imageMediaId)) {
            params.add(new HttpParameter("image_media_id", imageMediaId));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(videoMediaId)) {
            params.add(new HttpParameter("video_id", videoMediaId));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(callToAction)) {
            params.add(new HttpParameter("app_cta", callToAction));
        }
        return params;
    }

    private List<HttpParameter> getVideoCardHttpParametersForUpdate(String accountId, String name, String countryCode, String iphoneAppId, String ipadAppId, String googlePlayAppId, String iphoneDeepLink, String ipadDeepLink, String googlePlayDeepLink) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(countryCode, "App Country Code");
        TwitterAdUtil.ensureNotNull(name, "Name");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("name", name));
        params.add(new HttpParameter("country_code", countryCode));
        if (!(TwitterAdUtil.isNotNullOrEmpty(googlePlayAppId) || TwitterAdUtil.isNotNullOrEmpty(ipadAppId) || TwitterAdUtil.isNotNullOrEmpty(iphoneAppId))) {
            throw new TwitterException(new UnsupportedOperationException("Please provide atleast one valid store app id to create an app download card"));
        }
        if (TwitterAdUtil.isNotNull(iphoneAppId)) {
            params.add(new HttpParameter("iphone_app_id", iphoneAppId));
            if (TwitterAdUtil.isNotNull(iphoneDeepLink)) {
                params.add(new HttpParameter("iphone_deep_link", iphoneDeepLink));
            }
        }
        if (TwitterAdUtil.isNotNull(ipadAppId)) {
            params.add(new HttpParameter("ipad_app_id", ipadAppId));
            if (TwitterAdUtil.isNotNull(ipadDeepLink)) {
                params.add(new HttpParameter("ipad_deep_link", ipadDeepLink));
            }
        }
        if (TwitterAdUtil.isNotNull(googlePlayAppId)) {
            params.add(new HttpParameter("googleplay_app_id", googlePlayAppId));
            if (TwitterAdUtil.isNotNull(googlePlayDeepLink)) {
                params.add(new HttpParameter("googleplay_deep_link", googlePlayDeepLink));
            }
        }
        return params;
    }

    private List<HttpParameter> validateAndCreateParamsForUpdateImageConversationCard(String accountId, String name, String title, String firstHashtag, String firstTweet, String secondHashtag, String secondTweet, String thirdHashtag, String thirdTweet, String fourthHashtag, String fourthTweet, String thanksText, String thanksUrl, String imageUrl, TwitterImageConversationCard existingCard) throws TwitterException {
        TwitterAdUtil.ensureNotNull(imageUrl, "Image");
        return this.validateAndCreateParamsForUpdateConversationCard(accountId, name, title, firstHashtag, firstTweet, secondHashtag, secondTweet, thirdHashtag, thirdTweet, fourthHashtag, fourthTweet, thanksText, thanksUrl, existingCard);
    }

    private List<HttpParameter> validateAndCreateParamsForCreateVideoWebsiteCard(String accountId, String name, String title, String videoId, String websiteUrl) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(name, "Name");
        TwitterAdUtil.ensureNotNull(title, "Title");
        TwitterAdUtil.ensureNotNull(videoId, "Video Id");
        TwitterAdUtil.ensureNotNull(websiteUrl, "Website url");
        this.verifyLength(name, "Name", 80L);
        this.verifyLength(title, "Title", 70L);
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("name", name));
        params.add(new HttpParameter("title", title));
        params.add(new HttpParameter("video_id", videoId));
        params.add(new HttpParameter("website_url", websiteUrl));
        return params;
    }

    private List<HttpParameter> validateAndCreateParamsForUpdateVideoWebsiteCard(String name, String title, String videoId, String websiteUrl) throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (TwitterAdUtil.isNotNullOrEmpty(name)) {
            this.verifyLength(name, "Name", 80L);
            params.add(new HttpParameter("name", name));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(title)) {
            this.verifyLength(title, "Title", 70L);
            params.add(new HttpParameter("title", title));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(videoId)) {
            params.add(new HttpParameter("video_id", videoId));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(websiteUrl)) {
            params.add(new HttpParameter("website_url", websiteUrl));
        }
        return params;
    }

    private void verifyLength(String field, String label, long length) throws TwitterException {
        if ((long)field.length() > length) {
            throw new TwitterException(new UnsupportedOperationException(label + " cannot be more than " + length + " characters"));
        }
    }

    private List<HttpParameter> validateAndCreateParamsForCreateImageDMCard(String accountId, String name, String firstCta, Long firstWelcomeMessageId, String secondCta, Long secondWelcomeMessageId, String thirdCta, Long thirdWelcomeMessageId, String fourthCta, Long fourthWelcomeMessageId, Long recipientAccountId, String imageUrl) throws TwitterException {
        TwitterAdUtil.ensureNotNull(imageUrl, "Image Url");
        return this.validateAndCreateParamsForCreateDMCard(accountId, name, firstCta, firstWelcomeMessageId, secondCta, secondWelcomeMessageId, thirdCta, thirdWelcomeMessageId, fourthCta, fourthWelcomeMessageId, recipientAccountId);
    }

    private List<HttpParameter> validateAndCreateParamsForCreateVideoDMCard(String accountId, String name, String firstCta, Long firstWelcomeMessageId, String secondCta, Long secondWelcomeMessageId, String thirdCta, Long thirdWelcomeMessageId, String fourthCta, Long fourthWelcomeMessageId, Long recipientAccountId, String videoUrl) throws TwitterException {
        TwitterAdUtil.ensureNotNull(videoUrl, "Video Url");
        return this.validateAndCreateParamsForCreateDMCard(accountId, name, firstCta, firstWelcomeMessageId, secondCta, secondWelcomeMessageId, thirdCta, thirdWelcomeMessageId, fourthCta, fourthWelcomeMessageId, recipientAccountId);
    }

    private List<HttpParameter> validateAndCreateParamsForUpdateDMCard(String accountId, String name, String firstCta, Long firstWelcomeMessageId, String secondCta, Long secondWelcomeMessageId, String thirdCta, Long thirdWelcomeMessageId, String fourthCta, Long fourthWelcomeMessageId, String channelId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(channelId, "Card Channel Id");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            params.add(new HttpParameter("name", name));
        }
        if (TwitterAdUtil.isNotNull(firstCta) && TwitterAdUtil.isNotNull(firstWelcomeMessageId)) {
            this.verifyCtaLength(firstCta, "First Cta");
            params.add(new HttpParameter("first_cta", firstCta));
            params.add(new HttpParameter("first_cta_welcome_message_id", firstWelcomeMessageId));
        }
        if (TwitterAdUtil.isNotNull(secondCta) && TwitterAdUtil.isNotNull(secondWelcomeMessageId)) {
            this.verifyCtaLength(secondCta, "Second Cta");
            params.add(new HttpParameter("second_cta", secondCta));
            params.add(new HttpParameter("second_cta_welcome_message_id", secondWelcomeMessageId));
        }
        if (TwitterAdUtil.isNotNull(thirdCta) && TwitterAdUtil.isNotNull(thirdWelcomeMessageId)) {
            this.verifyCtaLength(thirdCta, "Third Cta");
            params.add(new HttpParameter("third_cta", thirdCta));
            params.add(new HttpParameter("third_cta_welcome_message_id", thirdWelcomeMessageId));
        }
        if (TwitterAdUtil.isNotNull(fourthCta) && TwitterAdUtil.isNotNull(fourthWelcomeMessageId)) {
            this.verifyCtaLength(fourthCta, "Fourth Cta");
            params.add(new HttpParameter("fourth_cta", fourthCta));
            params.add(new HttpParameter("fourth_cta_welcome_message_id", fourthWelcomeMessageId));
        }
        return params;
    }

    private List<HttpParameter> validateAndCreateParamsForCreateDMCard(String accountId, String name, String firstCta, Long firstWelcomeMessageId, String secondCta, Long secondWelcomeMessageId, String thirdCta, Long thirdWelcomeMessageId, String fourthCta, Long fourthWelcomeMessageId, Long recipientAccountId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(name, "Card Name");
        TwitterAdUtil.ensureNotNull(firstCta, "First Cta");
        TwitterAdUtil.ensureNotNull(firstWelcomeMessageId, "First Welcome Message ID");
        TwitterAdUtil.ensureNotNull(recipientAccountId, "Promotable Account ID");
        this.verifyCtaLength(firstCta, "First Cta");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("name", name));
        params.add(new HttpParameter("recipient_user_id", recipientAccountId));
        params.add(new HttpParameter("first_cta", firstCta));
        params.add(new HttpParameter("first_cta_welcome_message_id", firstWelcomeMessageId));
        if (TwitterAdUtil.isNotNull(secondCta) && TwitterAdUtil.isNotNull(secondWelcomeMessageId)) {
            this.verifyCtaLength(secondCta, "Second Cta");
            params.add(new HttpParameter("second_cta", secondCta));
            params.add(new HttpParameter("second_cta_welcome_message_id", secondWelcomeMessageId));
        }
        if (TwitterAdUtil.isNotNull(thirdCta) && TwitterAdUtil.isNotNull(thirdWelcomeMessageId)) {
            this.verifyCtaLength(thirdCta, "Third Cta");
            params.add(new HttpParameter("third_cta", thirdCta));
            params.add(new HttpParameter("third_cta_welcome_message_id", thirdWelcomeMessageId));
        }
        if (TwitterAdUtil.isNotNull(fourthCta) && TwitterAdUtil.isNotNull(fourthWelcomeMessageId)) {
            this.verifyCtaLength(fourthCta, "Fourth Cta");
            params.add(new HttpParameter("fourth_cta", fourthCta));
            params.add(new HttpParameter("fourth_cta_welcome_message_id", fourthWelcomeMessageId));
        }
        return params;
    }

    private void verifyCtaLength(String cta, String label) throws TwitterException {
        if (cta.length() > 20) {
            throw new TwitterException(new UnsupportedOperationException(label + " cannot be more than " + 20 + " characters"));
        }
    }
}

