/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.BaseAdsResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterAdsFundingInstrumentApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.ads.FundingInstrument;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.ads.sort.FundingInstrumentSortByField;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsFundingInstrumentApiImpl
implements TwitterAdsFundingInstrumentApi {
    private static final Integer MAX_REQUEST_PARAMETER_SIZE = 50;
    private final TwitterAdsClient twitterAdsClient;

    public TwitterAdsFundingInstrumentApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public BaseAdsListResponseIterable<FundingInstrument> getAllFundingInstruments(String accountId, boolean withDeleted, Optional<Collection<String>> fundingInstrumentIds, Optional<FundingInstrumentSortByField> sortByField) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        String fundingInstrumentIdsAsString = null;
        if (fundingInstrumentIds != null && fundingInstrumentIds.isPresent()) {
            TwitterAdUtil.ensureMaxSize(fundingInstrumentIds.get(), MAX_REQUEST_PARAMETER_SIZE);
            fundingInstrumentIdsAsString = TwitterAdUtil.getCsv(fundingInstrumentIds.get());
        }
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (TwitterAdUtil.isNotNullOrEmpty(fundingInstrumentIdsAsString)) {
            params.add(new HttpParameter("funding_instrument_ids", fundingInstrumentIdsAsString));
        }
        if (sortByField != null && sortByField.isPresent()) {
            params.add(new HttpParameter("sort_by", sortByField.get().getField()));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/funding_instruments/";
        Type type = new TypeToken<BaseAdsListResponse<FundingInstrument>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<FundingInstrument> getFundingInstrumentById(String accountId, String fundingInstrumentId, boolean withDeleted) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(fundingInstrumentId, "fundingInstrumentId");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/funding_instruments/" + fundingInstrumentId;
        HttpParameter[] param = new HttpParameter[]{new HttpParameter("with_deleted", withDeleted)};
        Type type = new TypeToken<BaseAdsResponse<FundingInstrument>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, param, type, HttpVerb.GET);
    }
}

