/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.BaseAdsResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterAdsLineItemApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.ads.BidType;
import twitter4jads.models.ads.EntityStatus;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.ads.LineItem;
import twitter4jads.models.ads.LineItemAppResponse;
import twitter4jads.models.ads.Placement;
import twitter4jads.models.ads.ProductType;
import twitter4jads.models.ads.PromotedAccount;
import twitter4jads.models.ads.Sentiments;
import twitter4jads.models.ads.TrackingTag;
import twitter4jads.models.ads.TwitterAdObjective;
import twitter4jads.models.ads.TwitterOSType;
import twitter4jads.models.ads.sort.LineItemsSortByField;
import twitter4jads.models.ads.sort.PromotedAccountsSortByField;
import twitter4jads.models.media.TwitterMediaCallToAction;
import twitter4jads.models.video.AssociateMediaCreativeResponse;
import twitter4jads.models.video.TwitterCallToActionType;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsLineItemApiImpl
implements TwitterAdsLineItemApi {
    private static final Integer MAX_REQUEST_PARAMETER_SIZE = 200;
    private final TwitterAdsClient twitterAdsClient;

    public TwitterAdsLineItemApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public BaseAdsResponse<LineItem> createLineItem(String accountId, LineItem lineItem) throws TwitterException {
        BidType bidType;
        String campaignId = lineItem.getCampaignId();
        boolean automaticallySelectBid = lineItem.isAutomaticallySelectBid();
        Long bidAmountLocalMicro = null;
        if (!automaticallySelectBid) {
            bidAmountLocalMicro = lineItem.getBidAmtInMicro();
            bidType = lineItem.getBidType();
        } else {
            bidType = BidType.AUTO;
        }
        Sentiments includeSentiment = lineItem.getSentiment();
        Boolean matchRelevantPopularQueries = lineItem.getMatchRelevantPopularQueries();
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        List<HttpParameter> params = this.validateCreateLineItemParameters(Optional.ofNullable(campaignId), bidType, Optional.ofNullable(bidAmountLocalMicro), automaticallySelectBid, Optional.ofNullable(lineItem.getProductType()), lineItem.getPlacements(), lineItem.getStatus(), Optional.ofNullable(includeSentiment), Optional.ofNullable(matchRelevantPopularQueries), Optional.ofNullable(lineItem.getObjective()), Optional.ofNullable(lineItem.getChargeBy()), Optional.ofNullable(lineItem.getBidUnit()), Optional.ofNullable(lineItem.getOptimization()), Optional.ofNullable(lineItem.getAdvertiserDomain()), lineItem.getCategories(), lineItem.getWebEventTag(), lineItem.getName(), Optional.ofNullable(lineItem.getStartTime()), Optional.ofNullable(lineItem.getEndTime()), lineItem.getTargetCpaLocalMicro(), lineItem.getBudget(), lineItem.getTrackingTags());
        HttpParameter[] parameters = null;
        if (!params.isEmpty()) {
            parameters = params.toArray(new HttpParameter[params.size()]);
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/line_items/";
        HttpResponse httpResponse = this.twitterAdsClient.postRequest(baseUrl, parameters);
        try {
            Type type = new TypeToken<BaseAdsResponse<LineItem>>(){}.getType();
            return TwitterAdUtil.constructBaseAdsResponse(httpResponse, httpResponse.asString(), type);
        }
        catch (IOException e) {
            throw new TwitterException("Failed to parse line item.");
        }
    }

    @Override
    public BaseAdsResponse<LineItem> updateLineItem(String accountId, String lineItemId, BidType bidType, boolean automaticallySelectBid, Optional<Long> bidAmountLocalMicro, EntityStatus status, Optional<Sentiments> includeSentiment, Optional<Boolean> matchRelevantPopularQueries, Optional<String> chargeBy, Optional<String> bidUnit, Optional<String> advertiserDomain, String optimization, String[] iabCategories, String startTime, String endTime, String name, Long targetCPA, Long budget, String trackingTags) throws TwitterException {
        if (automaticallySelectBid) {
            bidAmountLocalMicro = null;
            bidType = BidType.AUTO;
        }
        List<HttpParameter> params = this.validateUpdateLineItemParameters(accountId, lineItemId, bidType, automaticallySelectBid, bidAmountLocalMicro, status, includeSentiment, matchRelevantPopularQueries, chargeBy, bidUnit, optimization, advertiserDomain, iabCategories, budget, name, startTime, endTime, targetCPA, trackingTags);
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/line_items/" + lineItemId;
        Type type = new TypeToken<BaseAdsResponse<LineItem>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.PUT);
    }

    @Override
    public BaseAdsResponse<LineItem> deleteLineItem(String accountId, String lineItemId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(lineItemId, "LineItem Id");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/line_items/" + lineItemId;
        Type type = new TypeToken<BaseAdsResponse<LineItem>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsListResponseIterable<LineItem> getAllLineItems(String accountId, Optional<Collection<String>> campaignIds, Optional<Collection<String>> lineItemIds, Optional<Collection<String>> fundingInstrumentIds, Optional<Integer> count, boolean withDeleted, String cursor, Optional<LineItemsSortByField> sortByField) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        String campaignIdsAsString = null;
        String lineItemIdsAsString = null;
        String fundingInstrumentIdsAsString = null;
        if (campaignIds != null && campaignIds.isPresent()) {
            TwitterAdUtil.ensureMaxSize(campaignIds.get(), MAX_REQUEST_PARAMETER_SIZE);
            campaignIdsAsString = TwitterAdUtil.getCsv(campaignIds.get());
        }
        if (lineItemIds != null && lineItemIds.isPresent()) {
            TwitterAdUtil.ensureMaxSize(lineItemIds.get(), MAX_REQUEST_PARAMETER_SIZE);
            lineItemIdsAsString = TwitterAdUtil.getCsv(lineItemIds.get());
        }
        if (lineItemIds != null && fundingInstrumentIds.isPresent()) {
            TwitterAdUtil.ensureMaxSize(fundingInstrumentIds.get(), MAX_REQUEST_PARAMETER_SIZE);
            fundingInstrumentIdsAsString = TwitterAdUtil.getCsv(fundingInstrumentIds.get());
        }
        List<HttpParameter> params = this.validateLineItemParameters(accountId, campaignIdsAsString, lineItemIdsAsString, fundingInstrumentIdsAsString, count, withDeleted, cursor);
        if (sortByField != null && sortByField.isPresent()) {
            params.add(new HttpParameter("sort_by", sortByField.get().getField()));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/line_items/";
        Type type = new TypeToken<BaseAdsListResponse<LineItem>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<LineItem> getLineItemById(String accountId, String lineItemId, boolean withDeleted) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(lineItemId, "lineItemId");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/line_items/" + lineItemId;
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("with_deleted", withDeleted)};
        Type type = new TypeToken<BaseAdsResponse<LineItem>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params, type, HttpVerb.GET);
    }

    @Override
    public BaseAdsResponse<PromotedAccount> createPromotedAccounts(String accountId, String lineItemId, String userId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(lineItemId, "Line Item Id");
        TwitterAdUtil.ensureNotNull(userId, "User Id");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("line_item_id", lineItemId));
        params.add(new HttpParameter("user_id", userId));
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/promoted_accounts/";
        HttpResponse httpResponse = this.twitterAdsClient.postRequest(baseUrl, params.toArray(new HttpParameter[params.size()]));
        try {
            Type type = new TypeToken<BaseAdsResponse<PromotedAccount>>(){}.getType();
            return TwitterAdUtil.constructBaseAdsResponse(httpResponse, httpResponse.asString(), type);
        }
        catch (IOException e) {
            throw new TwitterException("Failed to parse promoted accounts.");
        }
    }

    @Override
    public BaseAdsResponse<TwitterMediaCallToAction> createCallToActionDetails(String accountId, String lineItemId, TwitterCallToActionType twitterCallToActionType, String callToActionUrl) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(lineItemId, "Line Item Id");
        TwitterAdUtil.ensureNotNull(callToActionUrl, "Call To Action Url");
        TwitterAdUtil.ensureNotNull((Object)twitterCallToActionType, "Call To Action Type");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("line_item_id", lineItemId));
        params.add(new HttpParameter("account_id", accountId));
        params.add(new HttpParameter("call_to_action", twitterCallToActionType.name()));
        params.add(new HttpParameter("call_to_action_url", callToActionUrl));
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/preroll_call_to_actions";
        HttpResponse httpResponse = this.twitterAdsClient.postRequest(baseUrl, params.toArray(new HttpParameter[params.size()]));
        try {
            Type type = new TypeToken<BaseAdsResponse<TwitterMediaCallToAction>>(){}.getType();
            return TwitterAdUtil.constructBaseAdsResponse(httpResponse, httpResponse.asString(), type);
        }
        catch (IOException e) {
            throw new TwitterException("Failed to parse call to action response.");
        }
    }

    @Override
    public BaseAdsResponse<AssociateMediaCreativeResponse> associateMediaCreativeWithAccount(String accountId, String lineItemId, String accountMediaId, String landingUrl) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(lineItemId, "Line Item Id");
        TwitterAdUtil.ensureNotNull(accountMediaId, "Account Media Id");
        TwitterAdUtil.ensureNotNull(landingUrl, " Landing Url");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("account_id", accountId));
        params.add(new HttpParameter("line_item_id", lineItemId));
        params.add(new HttpParameter("account_media_id", accountMediaId));
        if (TwitterAdUtil.isNotNullOrEmpty(landingUrl)) {
            params.add(new HttpParameter("landing_url", landingUrl));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/media_creatives";
        HttpResponse httpResponse = this.twitterAdsClient.postRequest(baseUrl, params.toArray(new HttpParameter[params.size()]));
        try {
            Type type = new TypeToken<BaseAdsResponse<AssociateMediaCreativeResponse>>(){}.getType();
            return TwitterAdUtil.constructBaseAdsResponse(httpResponse, httpResponse.asString(), type);
        }
        catch (IOException e) {
            throw new TwitterException("Failed to parse response for associate media to account", e);
        }
    }

    @Override
    @Deprecated
    public BaseAdsListResponseIterable<PromotedAccount> getPromotedAccounts(String accountId, Optional<Collection<String>> promotedAccountIds, String lineItemId, boolean withDeleted, PromotedAccountsSortByField sortByField) throws TwitterException {
        HashSet<String> lineItemIds = new HashSet<String>();
        if (TwitterAdUtil.isNotNullOrEmpty(lineItemId)) {
            lineItemIds.add(lineItemId);
        }
        return this.getPromotedAccounts(accountId, promotedAccountIds, Optional.of(lineItemIds), withDeleted, sortByField);
    }

    @Override
    public BaseAdsListResponseIterable<PromotedAccount> getPromotedAccounts(String accountId, Optional<Collection<String>> promotedAccountIds, Optional<Collection<String>> lineItemIds, boolean withDeleted, PromotedAccountsSortByField sortByField) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        String promotedAccountsIdsAsString = null;
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (promotedAccountIds != null && promotedAccountIds.isPresent() && TwitterAdUtil.isNotEmpty(promotedAccountIds.get())) {
            TwitterAdUtil.ensureMaxSize(promotedAccountIds.get(), MAX_REQUEST_PARAMETER_SIZE);
            promotedAccountsIdsAsString = TwitterAdUtil.getCsv(promotedAccountIds.get());
        }
        if (lineItemIds != null && lineItemIds.isPresent() && TwitterAdUtil.isNotEmpty(lineItemIds.get())) {
            TwitterAdUtil.ensureMaxSize(lineItemIds.get(), 200);
            params.add(new HttpParameter("line_item_ids", TwitterAdUtil.getCsv(lineItemIds.get())));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(promotedAccountsIdsAsString)) {
            params.add(new HttpParameter("promoted_account_ids", promotedAccountsIdsAsString));
        }
        if (sortByField != null) {
            params.add(new HttpParameter("sort_by", sortByField.getField()));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/promoted_accounts/";
        Type type = new TypeToken<BaseAdsListResponse<PromotedAccount>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<TwitterMediaCallToAction> updateCallToAction(String accountId, String channelId, String callToActionUrl, TwitterCallToActionType twitterCallToActionType) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(channelId, "Channel Id");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("id", channelId));
        if (StringUtils.isNotBlank((CharSequence)callToActionUrl)) {
            params.add(new HttpParameter("call_to_action_url", callToActionUrl));
        }
        if (twitterCallToActionType != null) {
            params.add(new HttpParameter("call_to_action", twitterCallToActionType.name()));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/preroll_call_to_actions" + "/" + channelId;
        HttpResponse httpResponse = this.twitterAdsClient.putRequest(baseUrl, params.toArray(new HttpParameter[params.size()]));
        try {
            Type type = new TypeToken<BaseAdsResponse<TwitterMediaCallToAction>>(){}.getType();
            return TwitterAdUtil.constructBaseAdsResponse(httpResponse, httpResponse.asString(), type);
        }
        catch (IOException e) {
            throw new TwitterException("Failed to parse call to action response.");
        }
    }

    @Override
    public BaseAdsResponse<TwitterMediaCallToAction> deleteCallToAction(String accountId, String channelId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(channelId, "Channel Id");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("id", channelId));
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/preroll_call_to_actions" + "/" + channelId;
        Type type = new TypeToken<BaseAdsResponse<TwitterMediaCallToAction>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsResponse<LineItemAppResponse> publishApp(String accountId, String lineItemId, String appStoreIdentifier, TwitterOSType twitterOSType) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(lineItemId, "Line Item Id");
        TwitterAdUtil.ensureNotNull(appStoreIdentifier, "App Store Identifier");
        TwitterAdUtil.ensureNotNull((Object)twitterOSType, "Twitter OS Type");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("account_id", accountId));
        params.add(new HttpParameter("line_item_id", lineItemId));
        params.add(new HttpParameter("app_store_identifier", appStoreIdentifier));
        params.add(new HttpParameter("os_type", twitterOSType.name()));
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/line_item_apps";
        Type type = new TypeToken<BaseAdsResponse<LineItemAppResponse>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.POST);
    }

    @Override
    public BaseAdsResponse<LineItemAppResponse> getForLineItemAppId(String accountId, String lineItemAppId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(lineItemAppId, "Line Item App Id");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/line_item_apps" + "/" + lineItemAppId;
        Type type = new TypeToken<BaseAdsResponse<LineItemAppResponse>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.GET);
    }

    @Override
    @Deprecated
    public BaseAdsListResponseIterable<LineItemAppResponse> getForLineItemAppIds(String accountId, String lineItemId, List<String> lineItemAppIds, Integer count, String cursor, boolean withDeleted) throws TwitterException {
        HashSet<String> lineItemIds = new HashSet<String>();
        if (TwitterAdUtil.isNotNullOrEmpty(lineItemId)) {
            lineItemIds.add(lineItemId);
        }
        return this.getForLineItemAppIds(accountId, lineItemIds, lineItemAppIds, count, cursor, withDeleted);
    }

    @Override
    public BaseAdsListResponseIterable<LineItemAppResponse> getForLineItemAppIds(String accountId, Collection<String> lineItemIds, List<String> lineItemAppIds, Integer count, String cursor, boolean withDeleted) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        if (TwitterAdUtil.isEmpty(lineItemIds) && CollectionUtils.isEmpty(lineItemAppIds) && StringUtils.isBlank((CharSequence)cursor)) {
            throw new TwitterException("Details for fetching Apps are missing, either Line Item Id or App Ids or Cursor should be provided");
        }
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("account_id", accountId));
        if (TwitterAdUtil.isNotEmpty(lineItemIds)) {
            TwitterAdUtil.ensureMaxSize(lineItemIds, 200);
            params.add(new HttpParameter("line_item_ids", TwitterAdUtil.getCsv(lineItemIds)));
        }
        if (StringUtils.isNotBlank((CharSequence)cursor)) {
            params.add(new HttpParameter("cursor", cursor));
        }
        if (CollectionUtils.isNotEmpty(lineItemAppIds)) {
            params.add(new HttpParameter("line_item_app_ids", TwitterAdUtil.getCsv(lineItemAppIds)));
        }
        if (count != null) {
            params.add(new HttpParameter("count", count.toString()));
        }
        params.add(new HttpParameter("with_deleted", withDeleted));
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/line_item_apps";
        Type type = new TypeToken<BaseAdsListResponse<LineItemAppResponse>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<LineItemAppResponse> deleteLineItemApp(String accountId, String lineItemAppId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(lineItemAppId, "Line Item App Id");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/line_item_apps" + "/" + lineItemAppId;
        Type type = new TypeToken<BaseAdsResponse<LineItemAppResponse>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.DELETE);
    }

    private List<HttpParameter> validateCreateLineItemParameters(Optional<String> campaignId, BidType bidType, Optional<Long> bidAmountLocalMicro, boolean automaticallySelectBid, Optional<ProductType> productType, List<Placement> placements, EntityStatus status, Optional<Sentiments> includeSentiment, Optional<Boolean> matchRelevantPopularQueries, Optional<String> objective, Optional<String> chargeBy, Optional<String> bidUnit, Optional<String> optimization, Optional<String> advertiserDomain, String[] categories, String webEventTag, String name, Optional<Date> startTime, Optional<Date> endTime, Long targetCpaLocalMicro, Long budget, List<TrackingTag> trackingTags) {
        if (bidType == BidType.TARGET || bidType == BidType.MAX) {
            TwitterAdUtil.ensureNotNull(bidAmountLocalMicro, "Bid amount cannot be null for TARGET or MAX Bid Type");
        }
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (campaignId != null && campaignId.isPresent()) {
            params.add(new HttpParameter("campaign_id", campaignId.get()));
        }
        if (TwitterAdUtil.isNotNull(bidAmountLocalMicro) && bidAmountLocalMicro.isPresent()) {
            params.add(new HttpParameter("bid_amount_local_micro", bidAmountLocalMicro.get()));
            if (bidType != null) {
                params.add(new HttpParameter("bid_type", bidType.name()));
            }
        }
        if (chargeBy != null && chargeBy.isPresent()) {
            params.add(new HttpParameter("charge_by", chargeBy.get()));
        }
        if (bidUnit != null && bidUnit.isPresent()) {
            params.add(new HttpParameter("bid_unit", bidUnit.get()));
        }
        if (optimization != null && optimization.isPresent()) {
            params.add(new HttpParameter("optimization", optimization.get()));
        }
        if (StringUtils.isNotEmpty((CharSequence)webEventTag)) {
            params.add(new HttpParameter("primary_web_event_tag", webEventTag));
        }
        if (status != null) {
            params.add(new HttpParameter("entity_status", status.name()));
        }
        if (includeSentiment != null && includeSentiment.isPresent()) {
            params.add(new HttpParameter("include_sentiment", includeSentiment.get().name()));
        }
        if (matchRelevantPopularQueries != null && matchRelevantPopularQueries.isPresent()) {
            params.add(new HttpParameter("match_relevant_popular_queries", matchRelevantPopularQueries.get()));
        }
        if (TwitterAdUtil.isNotEmpty(trackingTags)) {
            params.add(new HttpParameter("tracking_tags", TwitterAdUtil.getTrackingTagString(trackingTags)));
        }
        if (objective != null && objective.isPresent()) {
            params.add(new HttpParameter("objective", objective.get()));
            if ("TWEET_ENGAGEMENTS".equals(objective.get()) || "VIDEO_VIEWS".equals(objective.get()) || "WEBSITE_CLICKS".equals(objective.get())) {
                if (advertiserDomain != null && advertiserDomain.isPresent()) {
                    params.add(new HttpParameter("advertiser_domain", advertiserDomain.get()));
                }
                if (categories != null && TwitterAdUtil.isNotEmpty(Arrays.asList(categories))) {
                    params.add(new HttpParameter("categories", TwitterAdUtil.getCsv(Arrays.asList(categories))));
                }
            }
        }
        if (objective != null && objective.isPresent() && TwitterAdUtil.TARGET_CPA_SUPPORTED_OBJECTIVES.contains((Object)TwitterAdObjective.valueOf(objective.get())) && TwitterAdUtil.isNotNull(targetCpaLocalMicro)) {
            params.add(new HttpParameter("target_cpa_local_micro", targetCpaLocalMicro));
        }
        if (startTime != null && startTime.isPresent()) {
            params.add(new HttpParameter("start_time", String.valueOf(startTime)));
        }
        if (endTime != null && endTime.isPresent()) {
            params.add(new HttpParameter("end_time", String.valueOf(endTime)));
        }
        if (TwitterAdUtil.isNotNull(budget)) {
            params.add(new HttpParameter("total_budget_amount_local_micro", budget));
        }
        if (productType != null && productType.isPresent()) {
            params.add(new HttpParameter("product_type", productType.get().name()));
        }
        if (TwitterAdUtil.isNotEmpty(placements)) {
            params.add(new HttpParameter("placements", TwitterAdUtil.getCsv(placements)));
        }
        return params;
    }

    private List<HttpParameter> validateUpdateLineItemParameters(String accountId, String lineItemId, BidType bidType, Boolean automaticallySelectBid, Optional<Long> bidAmountLocalMicro, EntityStatus status, Optional<Sentiments> includeSentiment, Optional<Boolean> matchRelevantPopularQueries, Optional<String> chargeBy, Optional<String> bidUnit, String optimization, Optional<String> advertiserDomain, String[] iabCategories, Long budget, String name, String startTime, String endTime, Long targetCPA, String trackingTags) {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(lineItemId, "Line Item Id");
        TwitterAdUtil.ensureNotNull((Object)bidType, "Bid Type");
        if (bidType == BidType.TARGET || bidType == BidType.MAX) {
            TwitterAdUtil.ensureNotNull(bidAmountLocalMicro, "Bid amount cannot be null for TARGET or MAX Bid Type");
        }
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (TwitterAdUtil.isNotNull(bidAmountLocalMicro) && bidAmountLocalMicro.isPresent()) {
            params.add(new HttpParameter("bid_amount_local_micro", bidAmountLocalMicro.get()));
        }
        params.add(new HttpParameter("bid_type", bidType.name()));
        if (chargeBy != null && chargeBy.isPresent()) {
            params.add(new HttpParameter("charge_by", chargeBy.get()));
        }
        if (bidUnit != null && bidUnit.isPresent()) {
            params.add(new HttpParameter("bid_unit", bidUnit.get()));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(name)) {
            params.add(new HttpParameter("name", name));
        }
        if (TwitterAdUtil.isNotNull(targetCPA)) {
            params.add(new HttpParameter("target_cpa_local_micro", targetCPA));
        }
        if (startTime != null && !startTime.isEmpty()) {
            params.add(new HttpParameter("start_time", String.valueOf(startTime)));
        }
        if (endTime != null && !endTime.isEmpty()) {
            params.add(new HttpParameter("end_time", String.valueOf(endTime)));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(optimization)) {
            params.add(new HttpParameter("optimization", optimization));
        }
        if (bidType == BidType.AUTO) {
            params.add(new HttpParameter("bid_amount_local_micro", "null"));
        }
        if (status != null) {
            params.add(new HttpParameter("entity_status", status.name()));
        }
        if (includeSentiment != null && includeSentiment.isPresent()) {
            params.add(new HttpParameter("include_sentiment", includeSentiment.get().name()));
        }
        if (matchRelevantPopularQueries != null && matchRelevantPopularQueries.isPresent()) {
            params.add(new HttpParameter("match_relevant_popular_queries", matchRelevantPopularQueries.get()));
        }
        if (TwitterAdUtil.isNotNull(trackingTags)) {
            params.add(new HttpParameter("tracking_tags", trackingTags));
        }
        String budgetStr = budget == null ? "null" : String.valueOf(budget);
        params.add(new HttpParameter("total_budget_amount_local_micro", budgetStr));
        if (advertiserDomain != null && advertiserDomain.isPresent()) {
            params.add(new HttpParameter("advertiser_domain", advertiserDomain.get()));
        }
        if (iabCategories != null && TwitterAdUtil.isNotEmpty(Arrays.asList(iabCategories))) {
            params.add(new HttpParameter("categories", TwitterAdUtil.getCsv(Arrays.asList(iabCategories))));
        }
        return params;
    }

    private List<HttpParameter> validateLineItemParameters(String accountId, String campaignIds, String lineItemIds, String fundingInstrumentIds, Optional<Integer> count, boolean withDeleted, String cursor) {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (StringUtils.isNotBlank((CharSequence)campaignIds)) {
            params.add(new HttpParameter("campaign_ids", campaignIds));
        }
        if (StringUtils.isNotBlank((CharSequence)lineItemIds)) {
            params.add(new HttpParameter("line_item_ids", lineItemIds));
        }
        if (StringUtils.isNotBlank((CharSequence)fundingInstrumentIds)) {
            params.add(new HttpParameter("funding_instrument_ids", fundingInstrumentIds));
        }
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (count != null && count.isPresent()) {
            params.add(new HttpParameter("count", count.get()));
        }
        if (StringUtils.isNotBlank((CharSequence)cursor)) {
            params.add(new HttpParameter("cursor", cursor));
        }
        return params;
    }
}

