/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.BaseAdsResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterAdsMediaApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.media.TwitterAccountMedia;
import twitter4jads.models.media.TwitterAccountMediaCreative;
import twitter4jads.models.media.TwitterLibraryMedia;
import twitter4jads.models.media.TwitterMediaLibraryCategory;
import twitter4jads.models.media.TwitterMediaLibraryType;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsMediaApiImpl
implements TwitterAdsMediaApi {
    public static final int TWITTER_MAX_LIBRARY_GET_COUNT = 50;
    private final TwitterAdsClient twitterAdsClient;

    public TwitterAdsMediaApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public BaseAdsListResponseIterable<TwitterAccountMedia> getAccountMediaForAccount(String accountId, String sortBy) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/account_media";
        ArrayList parameters = Lists.newArrayList();
        parameters.add(new HttpParameter("account_id", accountId));
        if (StringUtils.isNotBlank((CharSequence)sortBy)) {
            parameters.add(new HttpParameter("sort_by", sortBy));
        }
        Type type = new TypeToken<BaseAdsListResponse<TwitterAccountMedia>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, parameters, type);
    }

    @Override
    public BaseAdsResponse<TwitterAccountMedia> getAccountMediaById(String accountId, String accountMediaId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(accountMediaId, "Account Media Id");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/account_media" + "/" + accountMediaId;
        Type type = new TypeToken<BaseAdsResponse<TwitterAccountMedia>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.GET);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterAccountMediaCreative> getMediaCreativesForAccount(String accountId, Boolean fetchDeleted) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/media_creatives";
        ArrayList parameters = Lists.newArrayList();
        parameters.add(new HttpParameter("account_id", accountId));
        if (fetchDeleted != null) {
            parameters.add(new HttpParameter("with_deleted", fetchDeleted));
        }
        Type type = new TypeToken<BaseAdsListResponse<TwitterAccountMediaCreative>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, parameters, type);
    }

    @Override
    public BaseAdsResponse<TwitterLibraryMedia> getMediaCreativeByKeyFromLibrary(String accountId, String mediaKey) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(mediaKey, "Media Key");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/media_library" + "/" + mediaKey;
        Type type = new TypeToken<BaseAdsResponse<TwitterLibraryMedia>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.GET);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterLibraryMedia> getMediaFromLibraryForAccount(String accountId, Integer count, String cursor, TwitterMediaLibraryType mediaType) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/media_library";
        ArrayList parameters = Lists.newArrayList();
        parameters.add(new HttpParameter("account_id", accountId));
        if (StringUtils.isNotBlank((CharSequence)cursor)) {
            parameters.add(new HttpParameter("cursor", cursor));
        }
        if (mediaType != null) {
            parameters.add(new HttpParameter("media_type", mediaType.name()));
        }
        if (count == null) {
            parameters.add(new HttpParameter("count", 50));
        }
        Type type = new TypeToken<BaseAdsListResponse<TwitterLibraryMedia>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, parameters, type);
    }

    @Override
    public BaseAdsResponse<TwitterAccountMediaCreative> deleteMediaCreative(String accountId, String mediaId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(mediaId, "Media Id");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/media_creatives" + "/" + mediaId;
        Type type = new TypeToken<BaseAdsResponse<TwitterAccountMediaCreative>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsResponse<TwitterAccountMediaCreative> createAccountMediaCreative(String accountId, String lineItemId, String accountMediaId, String landingUrl) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(lineItemId, "Line Item Id");
        TwitterAdUtil.ensureNotNull(accountMediaId, "Account Media Id");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("account_media_id", accountMediaId));
        params.add(new HttpParameter("account_id", accountId));
        params.add(new HttpParameter("line_item_id", lineItemId));
        if (StringUtils.isNotBlank((CharSequence)landingUrl)) {
            params.add(new HttpParameter("landing_url", landingUrl));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/media_creatives";
        Type type = new TypeToken<BaseAdsResponse<TwitterAccountMediaCreative>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.POST);
    }

    @Override
    public TwitterLibraryMedia createAndGetLibraryMedia(String accountId, String mediaId, TwitterMediaLibraryCategory mediaCategory, String name, String title, String description, String posterImageMediaId, String fileName) throws TwitterException {
        BaseAdsResponse<TwitterLibraryMedia> channelResponse = this.associateMediaToLibrary(accountId, mediaId, mediaCategory, name, title, description, posterImageMediaId, fileName);
        if (channelResponse.getData() == null) {
            throw new TwitterException("Could not associate media to library, please retry");
        }
        TwitterLibraryMedia video = channelResponse.getData();
        return this.twitterAdsClient.waitForMediaProcessing(accountId, video.getMediaKey(), TimeUnit.MINUTES.toMillis(10L));
    }

    @Override
    public BaseAdsResponse<TwitterLibraryMedia> updateLibraryMediaByKey(String accountId, String mediaKey, String name, String title, String description, String posterImageKey, String fileName) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(mediaKey, "Video Media Key");
        ArrayList params = Lists.newArrayList();
        if (TwitterAdUtil.isNotNullOrEmpty(name)) {
            params.add(new HttpParameter("name", name));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(title)) {
            params.add(new HttpParameter("title", title));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(description)) {
            params.add(new HttpParameter("description", description));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(posterImageKey)) {
            params.add(new HttpParameter("poster_image_media_id", posterImageKey));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(fileName)) {
            params.add(new HttpParameter("file_name", fileName));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/media_library" + "/" + mediaKey;
        Type type = new TypeToken<BaseAdsResponse<TwitterLibraryMedia>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.PUT);
    }

    @Override
    public TwitterLibraryMedia waitForProcessingAndGetMedia(String accountId, String mediaKey) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(mediaKey, "Media Key");
        return this.twitterAdsClient.waitForMediaProcessing(accountId, mediaKey, TimeUnit.MINUTES.toMillis(4L));
    }

    @Override
    public BaseAdsResponse<TwitterLibraryMedia> deleteLibraryMediaByKey(String accountId, String mediaKey) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(mediaKey, "Media Key");
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/media_library" + "/" + mediaKey;
        Type type = new TypeToken<BaseAdsResponse<TwitterLibraryMedia>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, null, type, HttpVerb.DELETE);
    }

    private BaseAdsResponse<TwitterLibraryMedia> associateMediaToLibrary(String accountId, String mediaId, TwitterMediaLibraryCategory mediaCategory, String name, String title, String description, String posterImageMediaId, String fileName) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        if (StringUtils.isNotBlank((CharSequence)mediaId)) {
            TwitterAdUtil.ensureNotNull((Object)mediaCategory, "Media category");
        }
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (StringUtils.isNotBlank((CharSequence)mediaId)) {
            params.add(new HttpParameter("media_category", mediaCategory.name()));
            params.add(new HttpParameter("media_id", mediaId));
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            params.add(new HttpParameter("description", description));
        }
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            params.add(new HttpParameter("file_name", fileName));
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            params.add(new HttpParameter("name", name));
        }
        if (StringUtils.isNotBlank((CharSequence)posterImageMediaId)) {
            params.add(new HttpParameter("poster_image_media_id", posterImageMediaId));
        }
        if (StringUtils.isNotBlank((CharSequence)title)) {
            params.add(new HttpParameter("title", title));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/media_library";
        HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
        Type type = new TypeToken<BaseAdsResponse<TwitterLibraryMedia>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.POST);
    }
}

