/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import twitter4jads.TwitterAdsClient;
import twitter4jads.TwitterAdsConstants;
import twitter4jads.api.TwitterAdsMediaUploadApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.models4j.TwitterInvalidParameterException;
import twitter4jads.internal.models4j.TwitterRuntimeException;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.media.TwitterMediaType;
import twitter4jads.models.video.UploadMediaObjectResponse;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsMediaUploadApiImpl
implements TwitterAdsMediaUploadApi {
    private static final Map<Long, Long> VIDEO_SIZE_PROCESSING_WAIT_TIME_MAP;
    private final TwitterAdsClient twitterAdsClient;

    public TwitterAdsMediaUploadApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public String uploadMediaAndGetMediaId(String mediaUrl, Set<String> accountUserIds, TwitterMediaType twitterMediaType, String name) throws TwitterException {
        UploadMediaObjectResponse responseFromFinalize = this.uploadAndGetMediaId(mediaUrl, accountUserIds, twitterMediaType, name);
        String mediaIdString = responseFromFinalize.getMediaIdString();
        Long videoSize = responseFromFinalize.getSize();
        if (responseFromFinalize.getUploadMediaProcessingInfo() == null) {
            return mediaIdString;
        }
        if (responseFromFinalize.getUploadMediaProcessingInfo().getUploadErrorInfo() != null) {
            throw new TwitterException(responseFromFinalize.getUploadMediaProcessingInfo().getUploadErrorInfo().getMessage());
        }
        String state = responseFromFinalize.getUploadMediaProcessingInfo().getState();
        Integer progressPercentage = responseFromFinalize.getUploadMediaProcessingInfo().getProgressPercentage();
        if (TwitterAdUtil.isNotNullOrEmpty(state) && state.equalsIgnoreCase("succeeded") || progressPercentage != null && progressPercentage == 100) {
            return mediaIdString;
        }
        return this.waitForVideoProcessingAndReturnId(mediaIdString, responseFromFinalize, videoSize);
    }

    private UploadMediaObjectResponse uploadAndGetMediaId(String mediaUrl, Set<String> accountUserIds, TwitterMediaType twitterMediaType, String name) throws TwitterException {
        try {
            String mediaSizeInBytes = this.getMediaSizeInBytes(mediaUrl);
            String mediaId = this.initiateMediaUpload(mediaSizeInBytes, accountUserIds, twitterMediaType, name);
            this.uploadMedia(mediaUrl, mediaId, mediaSizeInBytes);
            return this.finalizeMediaUpload(mediaId);
        }
        catch (Exception e) {
            if (e instanceof TwitterException) {
                throw (TwitterException)e;
            }
            throw new TwitterException("Error Occurred while uploading Media", e);
        }
    }

    private String getMediaSizeInBytes(String mediaUrl) throws TwitterException, IOException {
        try {
            URLConnection urlConnection = new URL(mediaUrl).openConnection();
            return urlConnection.getHeaderField("Content-Length");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid media url");
        }
    }

    private String initiateMediaUpload(String mediaSizeInBytes, Set<String> accountUserIds, TwitterMediaType twitterMediaType, String name) throws TwitterException {
        Long mediaSizeInBytesLong;
        if (StringUtils.isBlank((CharSequence)mediaSizeInBytes)) {
            throw new TwitterInvalidParameterException("Media could not be uploaded as connection could not be established");
        }
        try {
            mediaSizeInBytesLong = Long.valueOf(mediaSizeInBytes);
        }
        catch (NumberFormatException eX) {
            throw new TwitterException("Media could not be uploaded as connection could not be established");
        }
        if (twitterMediaType == TwitterMediaType.IMAGE && mediaSizeInBytesLong > TwitterAdsConstants.MAX_IMAGE_SIZE_FOR_TWITTER_IN_BYTES) {
            throw new TwitterInvalidParameterException("Image should be less than 5 MB in size");
        }
        if (twitterMediaType == TwitterMediaType.VIDEO && mediaSizeInBytesLong > TwitterAdsConstants.MAX_VIDEO_SIZE_IN_BYTES) {
            throw new TwitterInvalidParameterException("Video should be less than 500 MB in size");
        }
        String url = this.twitterAdsClient.getMediaUploadBaseUrl() + "media/" + "upload.json";
        HttpParameter[] parameters = this.createInitiateMediaUploadParams(mediaSizeInBytes, accountUserIds, twitterMediaType);
        return this.twitterAdsClient.mediaUploadInitOrFinalize(url, parameters).getMediaIdString();
    }

    private UploadMediaObjectResponse finalizeMediaUpload(String mediaId) throws TwitterException {
        String url = this.twitterAdsClient.getMediaUploadBaseUrl() + "media/" + "upload.json";
        HttpParameter[] parameters = this.createFinalizeMediaUploadParams(mediaId);
        Type type = new TypeToken<UploadMediaObjectResponse>(){}.getType();
        return (UploadMediaObjectResponse)this.twitterAdsClient.executeRequest(url, parameters, type, HttpVerb.POST);
    }

    private HttpParameter[] createInitiateMediaUploadParams(String mediaSizeInBytes, Set<String> accountUserIds, TwitterMediaType twitterMediaType) {
        if (StringUtils.isBlank((CharSequence)mediaSizeInBytes)) {
            throw new TwitterRuntimeException(null, new TwitterException("mediaSizeInBytes cannot be blank or null."));
        }
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("command", "INIT"));
        params.add(new HttpParameter("total_bytes", mediaSizeInBytes));
        switch (twitterMediaType) {
            case VIDEO: {
                params.add(new HttpParameter("media_type", "video/mp4"));
                params.add(new HttpParameter("media_category", "amplify_video"));
                if (!TwitterAdUtil.isNotEmpty(accountUserIds) || accountUserIds.size() != 1) break;
                String accountUserId = accountUserIds.iterator().next();
                params.add(new HttpParameter("attributable_user_id", accountUserId));
                break;
            }
            case IMAGE: {
                params.add(new HttpParameter("media_type", "image/jpeg"));
                break;
            }
            case DM_IMAGE: {
                params.add(new HttpParameter("media_type", "image/jpeg"));
                params.add(new HttpParameter("media_category", "dm_image"));
                params.add(new HttpParameter("shared", true));
                break;
            }
            case DM_VIDEO: {
                params.add(new HttpParameter("media_type", "video/mp4"));
                params.add(new HttpParameter("media_category", "dm_video"));
                params.add(new HttpParameter("shared", true));
                break;
            }
            case DM_GIF: {
                params.add(new HttpParameter("media_type", "video/gif"));
                params.add(new HttpParameter("media_category", "dm_image"));
                params.add(new HttpParameter("shared", true));
                break;
            }
        }
        if (TwitterAdUtil.isNotEmpty(accountUserIds)) {
            params.add(new HttpParameter("additional_owners", TwitterAdUtil.getCsv(accountUserIds)));
        }
        return params.toArray(new HttpParameter[params.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void uploadMedia(String mediaUrl, String mediaId, String mediaSizeInBytes) throws TwitterException, IOException {
        int segmentIndex = 0;
        Long bytesLeftToUpload = Long.valueOf(mediaSizeInBytes);
        InputStream inputStream = null;
        BufferedInputStream bis = null;
        try {
            inputStream = new URL(mediaUrl).openStream();
            bis = new BufferedInputStream(inputStream);
            while (bytesLeftToUpload > 0L) {
                byte[] chunk;
                int bytesRead;
                int totalBytesRead = 0;
                byte[] chunkToUpload = new byte[0x400000];
                while (totalBytesRead < 0x200000 && (bytesRead = bis.read(chunk = new byte[0x200000])) != -1) {
                    chunk = Arrays.copyOf(chunk, bytesRead);
                    for (int i = 0; i < bytesRead; ++i) {
                        chunkToUpload[totalBytesRead++] = chunk[i];
                    }
                }
                if (totalBytesRead <= 0) break;
                chunkToUpload = Arrays.copyOf(chunkToUpload, totalBytesRead);
                String base64Encoding = DatatypeConverter.printBase64Binary((byte[])chunkToUpload);
                this.appendChunk(mediaId, base64Encoding, segmentIndex);
                bytesLeftToUpload = bytesLeftToUpload - (long)totalBytesRead;
                ++segmentIndex;
            }
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            IOUtils.closeQuietly(bis);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bis);
    }

    private void appendChunk(String mediaId, String chunk, int segmentIndex) throws TwitterException {
        List<HttpParameter> params;
        HttpParameter[] parameters;
        String url = this.twitterAdsClient.getMediaUploadBaseUrl() + "media/upload.json";
        HttpResponse response = this.twitterAdsClient.postRequest(url, parameters = (params = this.createAppendChunkParams(mediaId, chunk, segmentIndex)).toArray(new HttpParameter[params.size()]));
        int responseCode = response.getStatusCode();
        if (responseCode < 200 || responseCode > 299) {
            throw new TwitterException(response.asString());
        }
    }

    private List<HttpParameter> createAppendChunkParams(String mediaId, String chunk, int segment_index) {
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("command", "APPEND"));
        params.add(new HttpParameter("media_id", mediaId));
        params.add(new HttpParameter("media_data", chunk));
        params.add(new HttpParameter("segment_index", segment_index));
        return params;
    }

    private HttpParameter[] createFinalizeMediaUploadParams(String mediaId) {
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("command", "FINALIZE"));
        params.add(new HttpParameter("media_id", mediaId));
        return params.toArray(new HttpParameter[params.size()]);
    }

    private String waitForVideoProcessingAndReturnId(String mediaIdString, UploadMediaObjectResponse statusResponse, Long videoSize) throws TwitterException {
        if (statusResponse == null) {
            statusResponse = this.getUploadStatus(mediaIdString);
        }
        Long timeToWait = 0L;
        Long checkAfterSeconds = statusResponse.getUploadMediaProcessingInfo().getCheckAfterSeconds();
        Long maxWaitTime = this.decideMaxWaitTime(videoSize);
        while (timeToWait < maxWaitTime) {
            TwitterAdUtil.reallySleep(checkAfterSeconds * 1000L);
            timeToWait = timeToWait + checkAfterSeconds;
            statusResponse = this.getUploadStatus(mediaIdString);
            if (statusResponse == null) {
                throw new TwitterException("Could not upload Video successfully, please select a different video");
            }
            if (statusResponse.getUploadMediaProcessingInfo() == null) {
                return mediaIdString;
            }
            if (statusResponse.getUploadMediaProcessingInfo().getUploadErrorInfo() != null) {
                throw new TwitterException(statusResponse.getUploadMediaProcessingInfo().getUploadErrorInfo().getMessage());
            }
            String state = statusResponse.getUploadMediaProcessingInfo().getState();
            Integer progressPercentage = statusResponse.getUploadMediaProcessingInfo().getProgressPercentage();
            if ((!TwitterAdUtil.isNotNullOrEmpty(state) || !state.equalsIgnoreCase("succeeded")) && (progressPercentage == null || progressPercentage != 100)) continue;
            return mediaIdString;
        }
        if (statusResponse.getUploadMediaProcessingInfo().getProgressPercentage() != null && statusResponse.getUploadMediaProcessingInfo().getProgressPercentage() < 100 && statusResponse.getUploadMediaProcessingInfo().getState() != null && statusResponse.getUploadMediaProcessingInfo().getState().equalsIgnoreCase("in_progress")) {
            throw new TwitterException("Please retry playing the ad, or upload a new video, there is problem at Twitter's end in processing the video");
        }
        throw new TwitterException(statusResponse.getUploadMediaProcessingInfo().getUploadErrorInfo().getMessage());
    }

    private Long decideMaxWaitTime(Long videoSize) {
        Long maxWaitTime = VIDEO_SIZE_PROCESSING_WAIT_TIME_MAP.get(this.getVideoSizeGroup(videoSize));
        if (maxWaitTime == null) {
            maxWaitTime = TwitterAdsConstants.MAX_WAIT_INTERVAL_ONE_HUNDRED_FIFTY_MIB;
        }
        return maxWaitTime;
    }

    private Long getVideoSizeGroup(Long videoSize) {
        if (videoSize == null) {
            return TwitterAdsConstants.ONE_HUNDRED_FIFTY_MIB;
        }
        if (videoSize <= TwitterAdsConstants.FIFTY_MIB) {
            return TwitterAdsConstants.FIFTY_MIB;
        }
        if (videoSize <= TwitterAdsConstants.ONE_HUNDRED_FIFTY_MIB) {
            return TwitterAdsConstants.ONE_HUNDRED_FIFTY_MIB;
        }
        return TwitterAdsConstants.FIVE_HUNDRED_MIB;
    }

    private UploadMediaObjectResponse getUploadStatus(String mediaId) throws TwitterException {
        String url = this.twitterAdsClient.getMediaUploadBaseUrl() + "media/upload.json";
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("command", "STATUS"));
        params.add(new HttpParameter("media_id", mediaId));
        Type type = new TypeToken<UploadMediaObjectResponse>(){}.getType();
        return (UploadMediaObjectResponse)this.twitterAdsClient.executeRequest(url, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.GET);
    }

    static {
        HashMap videoSizeProcessingWaitTimeMap = Maps.newHashMap();
        videoSizeProcessingWaitTimeMap.put(TwitterAdsConstants.FIFTY_MIB, TwitterAdsConstants.MAX_WAIT_INTERVAL_FIFTY_MIB);
        videoSizeProcessingWaitTimeMap.put(TwitterAdsConstants.ONE_HUNDRED_FIFTY_MIB, TwitterAdsConstants.MAX_WAIT_INTERVAL_ONE_HUNDRED_FIFTY_MIB);
        videoSizeProcessingWaitTimeMap.put(TwitterAdsConstants.FIVE_HUNDRED_MIB, TwitterAdsConstants.MAX_WAIT_INTERVAL_FIVE_HUNDRED_MIB);
        VIDEO_SIZE_PROCESSING_WAIT_TIME_MAP = Collections.unmodifiableMap(videoSizeProcessingWaitTimeMap);
    }
}

