/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterAdsPreviewApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.ads.TwitterCreativePreview;
import twitter4jads.models.ads.TwitterPreviewTarget;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsPreviewApiImpl
implements TwitterAdsPreviewApi {
    private final TwitterAdsClient twitterAdsClient;

    public TwitterAdsPreviewApiImpl(TwitterAdsClient twitterAdsClient) {
        TwitterAdUtil.ensureNotNull(twitterAdsClient, "Twitter_Ads_Client");
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public BaseAdsListResponse<TwitterCreativePreview> getUnpublishedTweetPreview(String accountId, String text, String asUserId, List<String> mediaIds, String cardId, TwitterPreviewTarget twitterPreviewTarget, String videoKey) throws TwitterException {
        List<HttpParameter> parameterList = this.validateAndGetParametersForUnpublishedPostPreview(text, asUserId, mediaIds, twitterPreviewTarget, videoKey);
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/tweet/preview/";
        Type type = new TypeToken<BaseAdsListResponse<TwitterCreativePreview>>(){}.getType();
        HttpResponse response = this.twitterAdsClient.getRequest(baseUrl, parameterList.toArray(new HttpParameter[parameterList.size()]));
        try {
            return TwitterAdUtil.constructBaseAdsListResponse(response, response.asString(), type);
        }
        catch (IOException io) {
            throw new TwitterException("Response for tweet preview failed from TwitterApi.");
        }
    }

    @Override
    public BaseAdsListResponse<TwitterCreativePreview> getPublishedTweetPreview(String accountId, String tweetId, TwitterPreviewTarget twitterPreviewTarget) throws TwitterException {
        ArrayList parameterList = Lists.newArrayList();
        if (TwitterAdUtil.isNotNullOrEmpty(twitterPreviewTarget.name())) {
            parameterList.add(new HttpParameter("preview_target", twitterPreviewTarget.name()));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/tweet/preview/" + tweetId;
        Type type = new TypeToken<BaseAdsListResponse<TwitterCreativePreview>>(){}.getType();
        HttpResponse response = this.twitterAdsClient.getRequest(baseUrl, parameterList.toArray(new HttpParameter[parameterList.size()]));
        try {
            return TwitterAdUtil.constructBaseAdsListResponse(response, response.asString(), type);
        }
        catch (IOException io) {
            throw new TwitterException("Response for tweet preview failed from TwitterApi");
        }
    }

    private List<HttpParameter> validateAndGetParametersForUnpublishedPostPreview(String text, String asUserId, List<String> mediaIds, TwitterPreviewTarget twitterPreviewTarget, String videoId) throws TwitterException {
        boolean isPreviewTargetPublisherNetwork = twitterPreviewTarget == TwitterPreviewTarget.PUBLISHER_NETWORK;
        String mediaIdsCsv = TwitterAdUtil.getCsv(mediaIds);
        if (isPreviewTargetPublisherNetwork && !TwitterAdUtil.isNotNullOrEmpty(mediaIdsCsv)) {
            throw new TwitterException("To preview an unpublished tweet, mediaIds is a required field when preview_target is " + TwitterPreviewTarget.PUBLISHER_NETWORK.name());
        }
        ArrayList parameterList = Lists.newArrayList();
        parameterList.add(new HttpParameter("text", text));
        if (TwitterAdUtil.isNotNullOrEmpty(asUserId)) {
            parameterList.add(new HttpParameter("as_user_id", asUserId));
        }
        if (TwitterAdUtil.isNotNull((Object)twitterPreviewTarget)) {
            parameterList.add(new HttpParameter("preview_target", twitterPreviewTarget.name()));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(mediaIdsCsv)) {
            parameterList.add(new HttpParameter("media_ids", mediaIdsCsv));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(videoId)) {
            parameterList.add(new HttpParameter("video_id", videoId));
        }
        return parameterList;
    }
}

