/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.BaseAdsResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterAdsPromotedTweetApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.models4j.Status;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.ads.PromotedTweet;
import twitter4jads.models.ads.PromotedTweets;
import twitter4jads.models.ads.sort.PromotedTweetsSortByField;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsPromotedTweetApiImpl
implements TwitterAdsPromotedTweetApi {
    private static final Integer MAX_REQUEST_PARAMETER_SIZE = 200;
    private final TwitterAdsClient twitterAdsClient;

    public TwitterAdsPromotedTweetApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public BaseAdsListResponseIterable<PromotedTweets> getAllPromotedTweets(String accountId, boolean withDeleted, Optional<Collection<String>> lineItemIds, Optional<Integer> count, String cursor, Optional<PromotedTweetsSortByField> sortByField) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (count != null && count.isPresent()) {
            params.add(new HttpParameter("count", count.get()));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(cursor)) {
            params.add(new HttpParameter("cursor", cursor));
        }
        if (lineItemIds != null && lineItemIds.isPresent()) {
            TwitterAdUtil.ensureMaxSize(lineItemIds.get(), MAX_REQUEST_PARAMETER_SIZE);
            params.add(new HttpParameter("line_item_ids", TwitterAdUtil.getCsv(lineItemIds.get())));
        }
        if (sortByField != null && sortByField.isPresent()) {
            params.add(new HttpParameter("sort_by", sortByField.get().getField()));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/promoted_tweets/";
        Type type = new TypeToken<BaseAdsListResponse<PromotedTweets>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<PromotedTweets> getPromotedTweetsById(String accountId, String promotedTweetsId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(promotedTweetsId, "promotedTweetsId");
        Type type = new TypeToken<BaseAdsResponse<PromotedTweets>>(){}.getType();
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/promoted_tweets/" + promotedTweetsId;
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.GET);
    }

    @Override
    public BaseAdsListResponse<PromotedTweets> createPromotedTweets(String accountId, String lineItemId, Collection<String> tweetIds) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(lineItemId, "Line Item Id");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("line_item_id", lineItemId));
        if (TwitterAdUtil.isNotEmpty(tweetIds)) {
            TwitterAdUtil.ensureMaxSize(tweetIds, MAX_REQUEST_PARAMETER_SIZE);
            String tweetIdsAsString = TwitterAdUtil.getCsv(tweetIds);
            params.add(new HttpParameter("tweet_ids", tweetIdsAsString));
        }
        HttpResponse httpResponse = this.twitterAdsClient.postRequest(this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/promoted_tweets/", params.toArray(new HttpParameter[params.size()]));
        try {
            Type type = new TypeToken<BaseAdsListResponse<PromotedTweets>>(){}.getType();
            return TwitterAdUtil.constructBaseAdsListResponse(httpResponse, httpResponse.asString(), type);
        }
        catch (IOException e) {
            throw new TwitterException("Failed to parse promoted tweets.");
        }
    }

    @Override
    public BaseAdsResponse<PromotedTweets> deletePromotedTweets(String accountId, String tweetId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(tweetId, "Tweet Id");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/promoted_tweets/" + tweetId;
        Type type = new TypeToken<BaseAdsResponse<PromotedTweets>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.DELETE);
    }

    @Override
    public Status createPromotedVideoTweet(String accountId, String targetUserId, String tweetText, String videoId, String videoTitle, String videoDescription, String callToAction, String ctaValue) throws TwitterException, IOException, InterruptedException {
        try {
            Type type;
            HttpParameter[] parameters;
            String url;
            BaseAdsResponse response;
            PromotedTweet tweet;
            TwitterAdUtil.ensureNotNull(accountId, "AccountId");
            TwitterAdUtil.ensureNotNull(tweetText, "Tweet text");
            TwitterAdUtil.ensureNotNull(videoId, "Video");
            ArrayList params = Lists.newArrayList();
            if (TwitterAdUtil.isNotNullOrEmpty(targetUserId)) {
                params.add(new HttpParameter("as_user_id", targetUserId));
            }
            if (TwitterAdUtil.isNotNullOrEmpty(tweetText)) {
                params.add(new HttpParameter("status", tweetText));
            }
            if (TwitterAdUtil.isNotNullOrEmpty(videoId)) {
                params.add(new HttpParameter("video_id", videoId));
            }
            if (TwitterAdUtil.isNotNullOrEmpty(videoTitle)) {
                params.add(new HttpParameter("video_title", videoTitle));
            }
            if (TwitterAdUtil.isNotNullOrEmpty(videoDescription)) {
                params.add(new HttpParameter("video_description", videoDescription));
            }
            if (TwitterAdUtil.isNotNullOrEmpty(callToAction) && TwitterAdUtil.isNotNullOrEmpty(ctaValue)) {
                params.add(new HttpParameter("video_cta", callToAction));
                params.add(new HttpParameter("video_cta_value", ctaValue));
            }
            if ((tweet = (PromotedTweet)(response = this.twitterAdsClient.executeHttpRequest(url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/tweet", parameters = params.toArray(new HttpParameter[params.size()]), type = new TypeToken<BaseAdsResponse<PromotedTweet>>(){}.getType(), HttpVerb.POST)).getData()) == null) {
                throw new TwitterException("Unable to create Video promoted Tweet. Definitely something is wrong here.");
            }
            return tweet;
        }
        catch (Exception eX) {
            throw new TwitterException("Unable to Create Promoted Video Tweet. " + eX.getMessage());
        }
    }

    @Override
    public BaseAdsResponse<PromotedTweets> createScheduledPromotedTweets(String accountId, String lineItemId, String scheduledTweetId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(lineItemId, "Line Item Id");
        TwitterAdUtil.ensureNotNull(scheduledTweetId, "Scheduled Tweet Id");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("line_item_id", lineItemId));
        params.add(new HttpParameter("scheduled_tweet_id", scheduledTweetId));
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/scheduled_promoted_tweets/";
        Type type = new TypeToken<BaseAdsResponse<PromotedTweets>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.POST);
    }

    @Override
    public BaseAdsResponse<PromotedTweets> deleteScheduledPromotedTweet(String accountId, String scheduledPromotedTweet) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(scheduledPromotedTweet, "scheduledPromotedTweet");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/scheduled_promoted_tweets/" + scheduledPromotedTweet;
        Type type = new TypeToken<BaseAdsResponse<PromotedTweets>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsListResponseIterable<PromotedTweets> getScheduledPromotedTweets(String accountId, List<String> lineItemIds, List<String> scheduledPromotedTweetIds, Integer count, String cursor, String sortBy, boolean withDeleted, boolean includeTotalCount) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (includeTotalCount && !TwitterAdUtil.isNotNullOrEmpty(cursor)) {
            params.add(new HttpParameter("with_total_count", includeTotalCount));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(sortBy)) {
            params.add(new HttpParameter("sort_by", sortBy));
        }
        if (TwitterAdUtil.isNotNull(count)) {
            params.add(new HttpParameter("count", count));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(cursor)) {
            params.add(new HttpParameter("cursor", cursor));
        }
        if (CollectionUtils.isNotEmpty(lineItemIds)) {
            params.add(new HttpParameter("line_item_ids", TwitterAdUtil.getCsv(lineItemIds)));
        }
        if (CollectionUtils.isNotEmpty(scheduledPromotedTweetIds)) {
            params.add(new HttpParameter("scheduled_promoted_tweet_ids", TwitterAdUtil.getCsv(scheduledPromotedTweetIds)));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/scheduled_promoted_tweets/";
        Type type = new TypeToken<BaseAdsListResponse<PromotedTweets>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public Status createPromotedTweetV2(String accountId, String targetUserId, String tweetText, List<String> mediaIds, String videoId, String videoTitle, String videoDescription, String videoCallToAction, String videoCtaValue, String cardUri, boolean promotedOnly) throws TwitterException, IOException {
        try {
            List<HttpParameter> params = this.validateAndCreateParamsForPromotedTweet(accountId, targetUserId, tweetText, mediaIds, videoId, videoTitle, videoDescription, videoCallToAction, videoCtaValue, cardUri, promotedOnly);
            String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/tweet";
            HttpParameter[] parameters = params.toArray(new HttpParameter[params.size()]);
            Type type = new TypeToken<BaseAdsResponse<PromotedTweet>>(){}.getType();
            BaseAdsResponse response = this.twitterAdsClient.executeHttpRequest(url, parameters, type, HttpVerb.POST);
            PromotedTweet tweet = (PromotedTweet)response.getData();
            if (tweet == null) {
                throw new TwitterException("Unable to create the tweet. Please contact support.");
            }
            return tweet;
        }
        catch (Exception eX) {
            throw new TwitterException("Unable to create the tweet. " + eX.getMessage());
        }
    }

    private List<HttpParameter> validateAndCreateParamsForPromotedTweet(String accountId, String targetUserId, String tweetText, List<String> mediaIds, String videoId, String videoTitle, String videoDescription, String videoCallToAction, String videoCtaValue, String cardUri, boolean promotedOnly) throws TwitterException {
        ArrayList params = Lists.newArrayList();
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(tweetText, "Tweet text");
        params.add(new HttpParameter("nullcast", promotedOnly));
        if (TwitterAdUtil.isNotNullOrEmpty(targetUserId)) {
            params.add(new HttpParameter("as_user_id", targetUserId));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(tweetText)) {
            params.add(new HttpParameter("text", tweetText));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(cardUri)) {
            params.add(new HttpParameter("card_uri", cardUri));
        }
        if (TwitterAdUtil.isNotEmpty(mediaIds)) {
            params.add(new HttpParameter("media_ids", TwitterAdUtil.getCsv(mediaIds)));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(videoId)) {
            params.add(new HttpParameter("video_id", videoId));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(videoTitle)) {
            params.add(new HttpParameter("video_title", videoTitle));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(videoDescription)) {
            params.add(new HttpParameter("video_description", videoDescription));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(videoCallToAction) && TwitterAdUtil.isNotNullOrEmpty(videoCtaValue)) {
            params.add(new HttpParameter("video_cta", videoCallToAction));
            params.add(new HttpParameter("video_cta_value", videoCtaValue));
        }
        return params;
    }
}

