/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.BaseAdsResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterAdsStatApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.Granularity;
import twitter4jads.models.TwitterSegmentationType;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.ads.JobDetails;
import twitter4jads.models.ads.Placement;
import twitter4jads.models.ads.TwitterAdStatistics;
import twitter4jads.models.ads.TwitterAuctionInsights;
import twitter4jads.models.ads.TwitterEntityStatistics;
import twitter4jads.models.ads.TwitterEntityStatisticsMetrics;
import twitter4jads.models.ads.TwitterEntityType;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsStatApiImpl
implements TwitterAdsStatApi {
    private final TwitterAdsClient twitterAdsClient;

    public TwitterAdsStatApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public BaseAdsListResponseIterable<TwitterEntityStatistics> fetchStatsSync(String accountId, TwitterEntityType twitterEntity, Collection<String> entityIds, long startTime, long endTime, boolean withDeleted, Granularity granularity, Placement placement) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(startTime, "startTime");
        TwitterAdUtil.ensureNotNull(entityIds, "entityIds");
        TwitterAdUtil.ensureNotNull((Object)placement, "placement");
        String startTimeAsString = TwitterAdUtil.convertTimeToZuluFormatAndToUTC(startTime);
        String endTimeAsString = TwitterAdUtil.convertTimeToZuluFormatAndToUTC(endTime);
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/stats/accounts/" + accountId;
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("granularity", granularity.toString()));
        params.add(new HttpParameter("start_time", startTimeAsString));
        params.add(new HttpParameter("entity", twitterEntity.name()));
        if (TwitterAdUtil.isNotNullOrEmpty(endTimeAsString)) {
            params.add(new HttpParameter("end_time", endTimeAsString));
        }
        String metrics = StringUtils.join((Object[])new String[]{this.getMetrics(twitterEntity, null), ","});
        params.add(new HttpParameter("metric_groups", metrics));
        params.add(new HttpParameter("with_deleted", withDeleted));
        params.add(new HttpParameter("entity_ids", TwitterAdUtil.getCsv(entityIds)));
        params.add(new HttpParameter("placement", placement.name()));
        Type type = new TypeToken<BaseAdsListResponse<TwitterEntityStatistics>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterAuctionInsights> fetchAuctionInsights(String accountId, Collection<String> lineItemIds, long startTime, long endTime, Granularity granularity, Placement placement) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(startTime, "startTime");
        TwitterAdUtil.ensureNotNull(lineItemIds, "lineItemIds");
        TwitterAdUtil.ensureNotNull((Object)placement, "placement");
        String startTimeAsString = TwitterAdUtil.convertTimeToZuluFormatAndToUTC(startTime);
        String endTimeAsString = TwitterAdUtil.convertTimeToZuluFormatAndToUTC(endTime);
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/auction_insights";
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("granularity", granularity.toString()));
        params.add(new HttpParameter("start_time", startTimeAsString));
        if (TwitterAdUtil.isNotNullOrEmpty(endTimeAsString)) {
            params.add(new HttpParameter("end_time", endTimeAsString));
        }
        params.add(new HttpParameter("line_item_ids", TwitterAdUtil.getCsv(lineItemIds)));
        params.add(new HttpParameter("placement", placement.name()));
        Type type = new TypeToken<BaseAdsListResponse<TwitterAuctionInsights>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<JobDetails> createAsyncJob(String accountId, TwitterEntityType twitterEntityType, Collection<String> ids, long startTime, long endTime, boolean withDeleted, Granularity granularity, Placement placement, Optional<TwitterSegmentationType> twitterSegmentationType) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(startTime, "startTime");
        TwitterAdUtil.ensureNotNull(ids, "entityIds");
        TwitterAdUtil.ensureNotNull((Object)placement, "placement");
        String startTimeAsString = TwitterAdUtil.convertTimeToZuluFormatAndToUTC(startTime);
        String endTimeAsString = TwitterAdUtil.convertTimeToZuluFormatAndToUTC(endTime);
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/stats/jobs/accounts/" + accountId;
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("granularity", granularity.toString()));
        params.add(new HttpParameter("start_time", startTimeAsString));
        params.add(new HttpParameter("entity", twitterEntityType.name()));
        if (TwitterAdUtil.isNotNullOrEmpty(endTimeAsString)) {
            params.add(new HttpParameter("end_time", endTimeAsString));
        }
        TwitterSegmentationType segmentationType = null;
        if (twitterSegmentationType != null && twitterSegmentationType.isPresent()) {
            segmentationType = twitterSegmentationType.get();
            params.add(new HttpParameter("segmentation_type", twitterSegmentationType.get().name()));
        }
        String metrics = StringUtils.join((Object[])new String[]{this.getMetrics(twitterEntityType, segmentationType), ","});
        params.add(new HttpParameter("metric_groups", metrics));
        params.add(new HttpParameter("with_deleted", withDeleted));
        params.add(new HttpParameter("entity_ids", TwitterAdUtil.getCsv(ids)));
        params.add(new HttpParameter("placement", placement.name()));
        Type type = new TypeToken<BaseAdsResponse<JobDetails>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.POST);
    }

    @Override
    public BaseAdsListResponseIterable<JobDetails> getJobExecutionDetails(String accountId, Collection<String> jobIds) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("job_ids", TwitterAdUtil.getCsv(jobIds)));
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/stats/jobs/accounts/" + accountId;
        Type type = new TypeToken<BaseAdsListResponse<JobDetails>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsListResponse<TwitterEntityStatistics> fetchJobDataAsync(String dataUrl) throws TwitterException {
        String responseAsString = this.getResponseFromGZipStream(dataUrl);
        Type type = new TypeToken<BaseAdsListResponse<TwitterEntityStatistics>>(){}.getType();
        return (BaseAdsListResponse)new Gson().fromJson(responseAsString, type);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterAdStatistics> fetchCampaignStats(String accountId, Collection<String> campaignIds, long startTime, long endTime) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(startTime, "startTime");
        TwitterAdUtil.ensureNotNull(campaignIds, "campaignIds");
        String startTimeAsString = TwitterAdUtil.convertTimeToZuluFormatAndToUTC(startTime);
        String endTimeAsString = TwitterAdUtil.convertTimeToZuluFormatAndToUTC(endTime);
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/stats/accounts/" + accountId + "/reach/campaigns/";
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("campaign_ids", TwitterAdUtil.getCsv(campaignIds)));
        params.add(new HttpParameter("start_time", startTimeAsString));
        if (TwitterAdUtil.isNotNullOrEmpty(endTimeAsString)) {
            params.add(new HttpParameter("end_time", endTimeAsString));
        }
        Type type = new TypeToken<BaseAdsListResponse<TwitterAdStatistics>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<JobDetails> deleteJob(String accountId, String jobId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(jobId, "jobId");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/stats/jobs/accounts/" + accountId + "/" + jobId;
        Type type = new TypeToken<BaseAdsResponse<JobDetails>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.DELETE);
    }

    private String getResponseFromGZipStream(String urlString) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("Accept-Encoding", "gzip");
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(con.getInputStream()), "utf-8"));
            StringBuilder builder = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                builder.append(line);
                line = reader.readLine();
            }
            return builder.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getMetrics(TwitterEntityType twitterEntity, TwitterSegmentationType twitterSegmentationType) {
        String metrics;
        switch (twitterEntity) {
            case ORGANIC_TWEET: {
                metrics = StringUtils.join(TwitterEntityStatisticsMetrics.ORGANIC_METRIC_GROUPS, (String)",");
                break;
            }
            case ACCOUNT: {
                metrics = StringUtils.join(TwitterEntityStatisticsMetrics.ENGAGEMENT_METRIC_GROUPS, (String)",");
                break;
            }
            default: {
                metrics = StringUtils.join(TwitterEntityStatisticsMetrics.getMetricGroups(twitterSegmentationType), (String)",");
            }
        }
        return metrics;
    }
}

