/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.BaseAdsResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterAdsTargetingApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.LocationType;
import twitter4jads.models.ads.AppStoreSearchType;
import twitter4jads.models.ads.BidType;
import twitter4jads.models.ads.Conversations;
import twitter4jads.models.ads.Devices;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.ads.IabCategory;
import twitter4jads.models.ads.NewTwitterReachEstimate;
import twitter4jads.models.ads.PlatformVersions;
import twitter4jads.models.ads.ProductType;
import twitter4jads.models.ads.SuggestionType;
import twitter4jads.models.ads.TargetingCriteria;
import twitter4jads.models.ads.TargetingLocation;
import twitter4jads.models.ads.TargetingSuggestion;
import twitter4jads.models.ads.TargetingType;
import twitter4jads.models.ads.TwitterAppStore;
import twitter4jads.models.ads.TwitterApplicationDetails;
import twitter4jads.models.ads.TwitterBehavior;
import twitter4jads.models.ads.TwitterBehaviorTaxonomy;
import twitter4jads.models.ads.audience.TailoredAudienceType;
import twitter4jads.models.ads.tags.TwitterApplicationList;
import twitter4jads.models.ads.targeting.TargetingParamRequest;
import twitter4jads.models.ads.targeting.TargetingParamResponse;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsTargetingApiImpl
implements TwitterAdsTargetingApi {
    private static final Integer MAX_REQUEST_PARAMETER_SIZE = 50;
    private static final Gson GSON = new Gson();
    private final TwitterAdsClient twitterAdsClient;

    public TwitterAdsTargetingApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    @Deprecated
    public BaseAdsListResponseIterable<TargetingCriteria> getTargetingCriterias(String accountId, String lineItemId, boolean withDeleted) throws TwitterException {
        TwitterAdUtil.ensureNotNull(lineItemId, "lineItemId");
        return this.getTargetingCriterias(accountId, Collections.singleton(lineItemId), withDeleted, null, null, null);
    }

    @Override
    public BaseAdsListResponseIterable<TargetingCriteria> getTargetingCriterias(String accountId, Collection<String> lineItemIds, boolean withDeleted, Integer count, String cursor, String sortBy) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotEmpty(lineItemIds, "lineItemIds");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        TwitterAdUtil.ensureMaxSize(lineItemIds, 200);
        params.add(new HttpParameter("line_item_ids", TwitterAdUtil.getCsv(lineItemIds)));
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (count != null) {
            params.add(new HttpParameter("count", count));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(cursor)) {
            params.add(new HttpParameter("cursor", cursor));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(sortBy)) {
            params.add(new HttpParameter("sort_by", sortBy));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/targeting_criteria/";
        Type type = new TypeToken<BaseAdsListResponse<TargetingCriteria>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<TargetingCriteria> getTargetingCriteriaById(String accountId, String targetingId, boolean withDeleted) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(targetingId, "Targeting Id");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/targeting_criteria/" + targetingId;
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("with_deleted", withDeleted)};
        Type type = new TypeToken<BaseAdsResponse<TargetingCriteria>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params, type, HttpVerb.GET);
    }

    @Override
    public BaseAdsResponse<TargetingCriteria> deleteTargetingCriteria(String accountId, String targetingCriteriaId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(targetingCriteriaId, "Targeting Id");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/targeting_criteria/" + targetingCriteriaId;
        Type type = new TypeToken<BaseAdsResponse<TargetingCriteria>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsListResponseIterable<TargetingLocation> getAllTargetingLocations(Optional<LocationType> locationType, String q, String countryCode, Optional<Integer> count) throws TwitterException {
        List<HttpParameter> params = this.validateTargetingLocationParameters(locationType, q, countryCode, count);
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/targeting_criteria/locations";
        Type type = new TypeToken<BaseAdsListResponse<TargetingLocation>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<TargetingCriteria> getAllTargetingEvents(String q) throws TwitterException {
        return this.hitQueryForPath(q, "5/targeting_criteria/events");
    }

    @Override
    public BaseAdsListResponseIterable<TargetingCriteria> getAllTargetingInterests(String q) throws TwitterException {
        return this.hitQueryForPath(q, "5/targeting_criteria/interests");
    }

    @Override
    public BaseAdsListResponseIterable<TargetingCriteria> getAllTargetingPlatforms(String q) throws TwitterException {
        return this.hitQueryForPath(q, "5/targeting_criteria/platforms");
    }

    @Override
    public BaseAdsListResponseIterable<TargetingCriteria> getAllTargetingNetworkOperators(String q) throws TwitterException {
        return this.hitQueryForPath(q, "5/targeting_criteria/network_operators/");
    }

    @Override
    public BaseAdsListResponseIterable<TargetingCriteria> getAllTargetingLocales(String q) throws TwitterException {
        return this.hitQueryForPath(q, "5/targeting_criteria/languages");
    }

    @Override
    public List<TargetingCriteria> createTargetingCriterias(String accountId, String lineItemId, List<TargetingCriteria> targetingCriteriaValues) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(lineItemId, "Line Item");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/targeting_criteria/";
        List<HttpParameter> params = this.validateAndCreateTargetingParameters(targetingCriteriaValues);
        params.add(new HttpParameter("line_item_id", lineItemId));
        HttpResponse httpResponse = this.twitterAdsClient.putRequest(baseUrl, params.toArray(new HttpParameter[params.size()]));
        try {
            Type type = new TypeToken<BaseAdsListResponse<TargetingCriteria>>(){}.getType();
            String asString = httpResponse.asString();
            BaseAdsListResponse baseAdsListResponse = TwitterAdUtil.constructBaseAdsListResponse(httpResponse, asString, type);
            return baseAdsListResponse == null ? Collections.emptyList() : baseAdsListResponse.getData();
        }
        catch (IOException e) {
            throw new TwitterException("Failed to parse targeting criterias.");
        }
    }

    @Override
    public BaseAdsResponse<TargetingCriteria> createTargetingCriteria(String accountId, String lineItemId, TargetingType targetingType, String targetingValue, boolean tailoredAudienceExpansion, Optional<TailoredAudienceType> tailoredAudienceType) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull(lineItemId, "Line Item Id");
        TwitterAdUtil.ensureNotNull((Object)targetingType, "Targeting Type");
        TwitterAdUtil.ensureNotNull(targetingValue, "Targeting Value");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("line_item_id", lineItemId));
        params.add(new HttpParameter("targeting_type", targetingType.name()));
        params.add(new HttpParameter("targeting_value", targetingValue));
        params.add(new HttpParameter("tailored_audience_expansion", tailoredAudienceExpansion));
        if (tailoredAudienceType != null && tailoredAudienceType.isPresent()) {
            params.add(new HttpParameter("tailored_audience_type", tailoredAudienceType.get().name()));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/targeting_criteria/";
        Type type = new TypeToken<BaseAdsResponse<TargetingCriteria>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.POST);
    }

    @Override
    public BaseAdsListResponseIterable<PlatformVersions> getAllTargetingPlatformVersions() throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/targeting_criteria/platform_versions";
        Type type = new TypeToken<BaseAdsListResponse<PlatformVersions>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<Devices> getAllTargetingDevices(String q) throws TwitterException {
        return this.hitQueryForPath(q, "5/targeting_criteria/devices");
    }

    private void validateTargetingBatch(List<TargetingParamRequest> targetingParamRequests) throws TwitterException {
        if (!TwitterAdUtil.isNotEmpty(targetingParamRequests)) {
            throw new TwitterException("Targeting Params size is 0");
        }
        if (targetingParamRequests.size() > 500) {
            throw new TwitterException("Targeting Params size cannot be more than 500 as per the API");
        }
    }

    @Override
    public BaseAdsResponse<NewTwitterReachEstimate> getReachEstimate(String accountId, ProductType productType, List<TargetingCriteria> targetingCriterias, String objective, Long bidAmountLocalMicro, String currency, Long campaignDailyBudgetAmountLocalMicro, String bidType) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull((Object)productType, "Product Type");
        TwitterAdUtil.ensureNotNull(objective, "Objective");
        TwitterAdUtil.ensureNotNull(currency, "Currency");
        TwitterAdUtil.ensureNotNull(campaignDailyBudgetAmountLocalMicro, "Campaign Daily Budget Amount Local Micro");
        if (StringUtils.isBlank((CharSequence)bidType)) {
            if (bidAmountLocalMicro != null) {
                throw new IllegalArgumentException("bidAmountLocalMicro has to be null when the BidType is null as default bidType is AUTO");
            }
            bidType = BidType.AUTO.name();
        }
        List<HttpParameter> params = this.validateAndCreateTargetingParameters(targetingCriterias);
        params.add(new HttpParameter("product_type", productType.name()));
        params.add(new HttpParameter("objective", objective));
        params.add(new HttpParameter("currency", currency));
        params.add(new HttpParameter("campaign_daily_budget_amount_local_micro", campaignDailyBudgetAmountLocalMicro));
        params.add(new HttpParameter("bid_type", bidType));
        if (!BidType.AUTO.name().equals(bidType)) {
            TwitterAdUtil.ensureNotNull(bidAmountLocalMicro, "Bid Amount Local Micro");
            params.add(new HttpParameter("bid_amount_local_micro", bidAmountLocalMicro));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/reach_estimate/";
        Type type = new TypeToken<BaseAdsResponse<NewTwitterReachEstimate>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.GET);
    }

    @Override
    public BaseAdsListResponseIterable<IabCategory> fetchIabCategories(String q) throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (TwitterAdUtil.isNotNullOrEmpty(q)) {
            params.add(new HttpParameter("q", q));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/iab_categories/";
        Type type = new TypeToken<BaseAdsListResponse<IabCategory>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public TargetingParamResponse createTargetingBatchRequest(String accountId, List<TargetingParamRequest> targetingParamRequests) throws TwitterException {
        this.validateTargetingBatch(targetingParamRequests);
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/batch/accounts/" + "accounts/" + accountId + "/targeting_criteria/";
        HttpResponse httpResponse = this.twitterAdsClient.postBatchRequest(baseUrl, GSON.toJson(targetingParamRequests));
        Type typeToken = new TypeToken<TargetingParamResponse>(){}.getType();
        return (TargetingParamResponse)GSON.fromJson(httpResponse.asString(), typeToken);
    }

    @Override
    public BaseAdsListResponseIterable<TargetingCriteria> getAllTargetingTVChannels(String tvMarketLocale, Optional<Integer> count, Optional<String> cursor) throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (TwitterAdUtil.isNotNullOrEmpty(tvMarketLocale)) {
            params.add(new HttpParameter("tv_market_locale ", tvMarketLocale));
        }
        if (count != null && count.isPresent()) {
            params.add(new HttpParameter("count", count.get()));
        }
        if (cursor != null && cursor.isPresent()) {
            params.add(new HttpParameter("cursor", cursor.get()));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/targeting_criteria/tv_channels/";
        Type type = new TypeToken<BaseAdsListResponse<TargetingCriteria>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<TargetingLocation> getTargetingLocations(String query, LocationType locationType) throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(2);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            params.add(new HttpParameter("q", query.trim()));
        }
        params.add(new HttpParameter("location_type", locationType.name()));
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/targeting_criteria/locations";
        Type type = new TypeToken<BaseAdsListResponse<TargetingLocation>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<Conversations> getAllTargetingConversations() throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/targeting_criteria/conversations";
        Type type = new TypeToken<BaseAdsListResponse<Conversations>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<IabCategory> getAllIabCategories(String q) throws TwitterException {
        return this.hitQueryForPath(q, "5/iab_categories/");
    }

    @Override
    public BaseAdsListResponseIterable<TargetingCriteria> getAllTVShows(String tvMarket, String q, Optional<Integer> count, Optional<String> cursor) throws TwitterException {
        TwitterAdUtil.ensureNotNull(tvMarket, "tvMarket");
        List<HttpParameter> params = this.validateTvShowsParameters(tvMarket, q, count, cursor);
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/targeting_criteria/tv_shows/";
        Type type = new TypeToken<BaseAdsListResponse<TargetingCriteria>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<TargetingCriteria> getAllEvents() throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/targeting_criteria/events";
        Type type = new TypeToken<BaseAdsListResponse<TargetingCriteria>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<TargetingCriteria> getAllTVMarkets() throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/targeting_criteria/tv_markets/";
        Type type = new TypeToken<BaseAdsListResponse<TargetingCriteria>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<TargetingCriteria> getAllTargetingTVGenres() throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/targeting_criteria/tv_genres/";
        Type type = new TypeToken<BaseAdsListResponse<TargetingCriteria>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public List<TargetingSuggestion> getTargetingSuggestion(String accountId, SuggestionType suggestionType, List<String> targetingValues, Optional<Integer> count, List<String> ignoredValues) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "AccountId");
        TwitterAdUtil.ensureNotNull((Object)suggestionType, "Suggestion Type");
        TwitterAdUtil.ensureNotEmpty(targetingValues, "Targeting Values");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("suggestion_type", suggestionType.name()));
        params.add(new HttpParameter("targeting_values", TwitterAdUtil.getCsv(targetingValues)));
        if (TwitterAdUtil.isNotEmpty(ignoredValues)) {
            params.add(new HttpParameter("ignored_values", TwitterAdUtil.getCsv(ignoredValues)));
        }
        if (count != null && count.isPresent()) {
            params.add(new HttpParameter("count", count.get() > MAX_REQUEST_PARAMETER_SIZE ? MAX_REQUEST_PARAMETER_SIZE.intValue() : count.get().intValue()));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/targeting_suggestions/";
        HttpResponse httpResponse = this.twitterAdsClient.getRequest(baseUrl, params.toArray(new HttpParameter[params.size()]));
        try {
            Type type = new TypeToken<BaseAdsListResponse<TargetingSuggestion>>(){}.getType();
            BaseAdsListResponse baseAdsListResponse = TwitterAdUtil.constructBaseAdsListResponse(httpResponse, httpResponse.asString(), type);
            return baseAdsListResponse == null ? Collections.emptyList() : baseAdsListResponse.getData();
        }
        catch (IOException e) {
            throw new TwitterException("Failed to parse promoted tweets.");
        }
    }

    @Override
    public List<TwitterAppStore> searchAppStoreCategories(String q, Optional<AppStoreSearchType> appStoreSearchType) throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (TwitterAdUtil.isNotNullOrEmpty(q)) {
            params.add(new HttpParameter("q", q));
        }
        if (appStoreSearchType != null && appStoreSearchType.isPresent()) {
            params.add(new HttpParameter("store", appStoreSearchType.get().name()));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/targeting_criteria/app_store_categories";
        HttpResponse httpResponse = this.twitterAdsClient.getRequest(baseUrl, params.toArray(new HttpParameter[params.size()]));
        try {
            Type type = new TypeToken<BaseAdsListResponse<TwitterAppStore>>(){}.getType();
            BaseAdsListResponse baseAdsListResponse = TwitterAdUtil.constructBaseAdsListResponse(httpResponse, httpResponse.asString(), type);
            return baseAdsListResponse == null ? Collections.emptyList() : baseAdsListResponse.getData();
        }
        catch (IOException e) {
            throw new TwitterException("Failed to parse response for app store categories");
        }
    }

    @Override
    public BaseAdsListResponseIterable<TwitterBehavior> getBehaviors(Optional<Integer> count, Optional<String> cursor, List<String> behaviorIds, Optional<String> countryCode) throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (count != null && count.isPresent()) {
            params.add(new HttpParameter("count", count.get()));
        }
        if (cursor != null && cursor.isPresent()) {
            params.add(new HttpParameter("cursor", cursor.get()));
        }
        if (TwitterAdUtil.isNotEmpty(behaviorIds)) {
            params.add(new HttpParameter("behavior_ids", TwitterAdUtil.getCsv(behaviorIds)));
        }
        if (countryCode != null && countryCode.isPresent()) {
            params.add(new HttpParameter("country_code", countryCode.get()));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/targeting_criteria/behaviors/";
        Type type = new TypeToken<BaseAdsListResponse<TwitterBehavior>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterBehaviorTaxonomy> getBehaviorTaxonomy(List<String> behaviorTaxonomyIds, List<String> parentBehaviorTaxonomyIds, Optional<Integer> count, Optional<String> cursor) throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (TwitterAdUtil.isNotEmpty(behaviorTaxonomyIds)) {
            params.add(new HttpParameter("behavior_taxonomy_ids", TwitterAdUtil.getCsv(behaviorTaxonomyIds)));
        }
        if (TwitterAdUtil.isNotEmpty(parentBehaviorTaxonomyIds)) {
            params.add(new HttpParameter("parent_behavior_taxonomy_ids", TwitterAdUtil.getCsv(parentBehaviorTaxonomyIds)));
        }
        if (count != null && count.isPresent()) {
            params.add(new HttpParameter("count", count.get()));
        }
        if (cursor != null && cursor.isPresent()) {
            params.add(new HttpParameter("cursor", cursor.get()));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/targeting_criteria/behavior_taxonomies/";
        Type type = new TypeToken<BaseAdsListResponse<TwitterBehaviorTaxonomy>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterApplicationList> getAllAppLists(String accountId) throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/app_lists/";
        Type type = new TypeToken<BaseAdsListResponse<TwitterApplicationList>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<TwitterApplicationList> getAllAppsListsById(String accountId, String listId) throws TwitterException {
        ArrayList params = new ArrayList();
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/app_lists/" + listId;
        Type typeToken = new TypeToken<BaseAdsResponse<TwitterApplicationList>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), typeToken, HttpVerb.GET);
    }

    @Override
    public BaseAdsResponse<TwitterApplicationList> createNewApplicationList(String accountId, TwitterApplicationList twitterApplicationList) throws TwitterException {
        List<HttpParameter> params = this.validateAndCreateApplicationListParameters(twitterApplicationList);
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/app_lists/";
        Type typeToken = new TypeToken<BaseAdsResponse<TwitterApplicationList>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), typeToken, HttpVerb.POST);
    }

    private <T> BaseAdsListResponseIterable<T> hitQueryForPath(String q, String queryPath) throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (TwitterAdUtil.isNotNullOrEmpty(q)) {
            params.add(new HttpParameter("q", q));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + queryPath;
        Type type = new TypeToken<BaseAdsListResponse<TargetingCriteria>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    private List<HttpParameter> validateAndCreateTargetingParameters(List<TargetingCriteria> targetingValues) {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        HashMap<TargetingType, ArrayList> targeting = new HashMap<TargetingType, ArrayList>();
        for (TargetingCriteria targetingCriteria : targetingValues) {
            if (targeting.containsKey((Object)targetingCriteria.getTargetingType())) {
                ((List)targeting.get((Object)targetingCriteria.getTargetingType())).add(targetingCriteria.getTargetingValue());
                continue;
            }
            targeting.put(targetingCriteria.getTargetingType(), Lists.newArrayList((Object[])new String[]{targetingCriteria.getTargetingValue()}));
        }
        for (Map.Entry entry : targeting.entrySet()) {
            switch ((TargetingType)((Object)entry.getKey())) {
                case LOCATION: {
                    TwitterAdUtil.ensureMaxSize((Collection)entry.getValue(), 250);
                    params.add(new HttpParameter("locations", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case FOLLOWERS_OF_USER: {
                    TwitterAdUtil.ensureMaxSize((Collection)entry.getValue(), 100);
                    params.add(new HttpParameter("followers_of_users", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case SIMILAR_TO_FOLLOWERS_OF_USER: {
                    TwitterAdUtil.ensureMaxSize((Collection)entry.getValue(), 100);
                    params.add(new HttpParameter("similar_to_followers_of_users", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case INTEREST: {
                    TwitterAdUtil.ensureMaxSize((Collection)entry.getValue(), 1000);
                    params.add(new HttpParameter("interests", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case PLATFORM: {
                    params.add(new HttpParameter("platforms", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case PLATFORM_VERSION: {
                    params.add(new HttpParameter("platform_versions", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case CONVERSATION: {
                    params.add(new HttpParameter("conversations", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case DEVICE: {
                    params.add(new HttpParameter("devices", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case WIFI_ONLY: {
                    params.add(new HttpParameter("wifi_only", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case GENDER: {
                    params.add(new HttpParameter("gender", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case TV_SHOW: {
                    params.add(new HttpParameter("tv_shows", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case TV_CHANNEL: {
                    params.add(new HttpParameter("tv_channels", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case TV_GENRE: {
                    params.add(new HttpParameter("tv_genres", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case TV_MARKET: {
                    break;
                }
                case NETWORK_OPERATOR: {
                    params.add(new HttpParameter("network_operators", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case BROAD_KEYWORD: {
                    TwitterAdUtil.ensureMaxSize((Collection)entry.getValue(), 1000);
                    params.add(new HttpParameter("broad_keywords", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case UNORDERED_KEYWORD: {
                    params.add(new HttpParameter("unordered_keywords", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case PHRASE_KEYWORD: {
                    TwitterAdUtil.ensureMaxSize((Collection)entry.getValue(), 1000);
                    params.add(new HttpParameter("phrase_keywords", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case EXACT_KEYWORD: {
                    TwitterAdUtil.ensureMaxSize((Collection)entry.getValue(), 1000);
                    params.add(new HttpParameter("exact_keywords", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case NEGATIVE_PHRASE_KEYWORD: {
                    TwitterAdUtil.ensureMaxSize((Collection)entry.getValue(), 1000);
                    params.add(new HttpParameter("negative_phrase_keywords", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case NEGATIVE_UNORDERED_KEYWORD: {
                    TwitterAdUtil.ensureMaxSize((Collection)entry.getValue(), 1000);
                    params.add(new HttpParameter("negative_unordered_keywords", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case NEGATIVE_EXACT_KEYWORD: {
                    TwitterAdUtil.ensureMaxSize((Collection)entry.getValue(), 1000);
                    params.add(new HttpParameter("negative_exact_keywords", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case TAILORED_AUDIENCE: {
                    params.add(new HttpParameter("tailored_audiences", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case TAILORED_AUDIENCES_EXCLUDED: {
                    params.add(new HttpParameter("tailored_audiences_excluded", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case TAILORED_AUDIENCES_EXPANDED: {
                    params.add(new HttpParameter("tailored_audiences_expanded", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case LANGUAGE: {
                    params.add(new HttpParameter("languages", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case RTB_APP_CATEGORY: {
                    break;
                }
                case NETWORK_ACTIVATION_DURATION_LT: {
                    params.add(new HttpParameter("network_activation_duration_lt", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case NETWORK_ACTIVATION_DURATION_GTE: {
                    params.add(new HttpParameter("network_activation_duration_gte", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case AGE: {
                    params.add(new HttpParameter("age_buckets", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case BEHAVIOR: {
                    params.add(new HttpParameter("behaviors", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case NEGATIVE_BEHAVIOR: {
                    params.add(new HttpParameter("negative_behaviors", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case BEHAVIOR_EXPANDED: {
                    params.add(new HttpParameter("behaviors_expanded", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case ENGAGEMENT_TYPE: {
                    params.add(new HttpParameter("engagement_type", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case USER_ENGAGEMENT: {
                    params.add(new HttpParameter("user_engagement", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case CAMPAIGN_ENGAGEMENT: {
                    params.add(new HttpParameter("campaign_engagement", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case EXCLUDE_APP_LIST: {
                    params.add(new HttpParameter("exclude_app_list", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case EVENT: {
                    TwitterAdUtil.ensureMaxSize((Collection)entry.getValue(), 1);
                    params.add(new HttpParameter("event", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                    break;
                }
                case APP_STORE_CATEGORY: {
                    params.add(new HttpParameter("app_store_categories", TwitterAdUtil.getCsv((Collection)entry.getValue())));
                }
            }
        }
        return params;
    }

    private List<HttpParameter> validateTargetingLocationParameters(Optional<LocationType> locationType, String q, String countryCode, Optional<Integer> count) {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (locationType != null && locationType.isPresent()) {
            params.add(new HttpParameter("location_type", locationType.get().name()));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(q)) {
            params.add(new HttpParameter("q", q));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(countryCode)) {
            params.add(new HttpParameter("country_code", countryCode));
        }
        if (count != null && count.isPresent()) {
            params.add(new HttpParameter("count", count.get()));
        }
        return params;
    }

    private List<HttpParameter> validateTvShowsParameters(String tvMarket, String q, Optional<Integer> count, Optional<String> cursor) {
        TwitterAdUtil.ensureNotNull(tvMarket, "tvMarket");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (StringUtils.isNotBlank((CharSequence)tvMarket)) {
            params.add(new HttpParameter("tv_market_locale", tvMarket));
        }
        if (StringUtils.isNotBlank((CharSequence)q)) {
            params.add(new HttpParameter("q", q));
        }
        if (count != null && count.isPresent()) {
            params.add(new HttpParameter("count", count.get()));
        }
        if (cursor != null && cursor.isPresent()) {
            params.add(new HttpParameter("cursor", cursor.get()));
        }
        return params;
    }

    private List<HttpParameter> validateAndCreateApplicationListParameters(TwitterApplicationList twitterApplicationList) {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (TwitterAdUtil.isNotNullOrEmpty(twitterApplicationList.getName())) {
            params.add(new HttpParameter("name", twitterApplicationList.getName()));
        }
        if (TwitterAdUtil.isNotEmpty(twitterApplicationList.getApps())) {
            List<TwitterApplicationDetails> apps = twitterApplicationList.getApps();
            ArrayList appIdentifiers = Lists.newArrayList();
            for (TwitterApplicationDetails twitterApplicationDetails : apps) {
                if (!TwitterAdUtil.isNotNullOrEmpty(twitterApplicationDetails.getAppIdentifier())) continue;
                appIdentifiers.add(twitterApplicationDetails.getAppIdentifier());
            }
            if (TwitterAdUtil.isNotEmpty(appIdentifiers)) {
                params.add(new HttpParameter("app_store_identifiers", TwitterAdUtil.getCsv(appIdentifiers)));
            }
        }
        return params;
    }
}

