/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.BaseAdsResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterAdsWebEventApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.ads.TwitterWebsiteTag;
import twitter4jads.models.ads.tags.WebEventTag;
import twitter4jads.models.ads.tags.WebEventTagType;
import twitter4jads.util.TwitterAdUtil;

public class TwitterAdsWebEventApiImpl
implements TwitterAdsWebEventApi {
    private final TwitterAdsClient twitterAdsClient;

    public TwitterAdsWebEventApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public BaseAdsListResponseIterable<WebEventTag> getAllWebEventTags(String accountId, boolean withDeleted, Integer count, String cursor) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (TwitterAdUtil.isNotNull(count)) {
            params.add(new HttpParameter("count", count));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(cursor)) {
            params.add(new HttpParameter("cursor", cursor));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/web_event_tags/";
        Type type = new TypeToken<BaseAdsListResponse<WebEventTag>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(url, params, type);
    }

    @Override
    public BaseAdsResponse<WebEventTag> getWebEventTag(String accountId, boolean withDeleted, String webEventTagId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(webEventTagId, "Web Event Tag Id");
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("with_deleted", withDeleted)};
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/web_event_tags/" + webEventTagId;
        Type type = new TypeToken<BaseAdsResponse<WebEventTag>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, params, type, HttpVerb.GET);
    }

    @Override
    public BaseAdsResponse<WebEventTag> createWebEventTag(String accountId, String name, Integer clickWindow, Integer viewThroughWindow, WebEventTagType type, boolean retargetingEnabled) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        List<HttpParameter> params = this.validateAndCreateParamsForCreateWebEventTag(name, clickWindow, viewThroughWindow, type, retargetingEnabled);
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/web_event_tags/";
        Type typeToken = new TypeToken<BaseAdsResponse<WebEventTag>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, params.toArray(new HttpParameter[params.size()]), typeToken, HttpVerb.POST);
    }

    @Override
    public BaseAdsResponse<WebEventTag> updateWebEventTag(String accountId, String webEventTagId, String name, Integer clickWindow, Integer viewThroughWindow, WebEventTagType type, boolean retargetingEnabled) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(webEventTagId, "Web Event Tag Id");
        List<HttpParameter> params = this.validateAndCreateParamsForUpdateWebEventTag(name, clickWindow, viewThroughWindow, type, retargetingEnabled);
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/web_event_tags/" + webEventTagId;
        Type typeToken = new TypeToken<BaseAdsResponse<WebEventTag>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, params.toArray(new HttpParameter[params.size()]), typeToken, HttpVerb.PUT);
    }

    @Override
    public BaseAdsResponse<WebEventTag> deleteWebEventTag(String accountId, String webEventTagId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(webEventTagId, "Web Event Tag Id");
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/web_event_tags/" + webEventTagId;
        Type typeToken = new TypeToken<BaseAdsResponse<WebEventTag>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, null, typeToken, HttpVerb.DELETE);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterWebsiteTag> getAllWebsiteTags(String accountId, boolean withDeleted, Integer count, String cursor) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("with_deleted", withDeleted));
        if (TwitterAdUtil.isNotNull(count)) {
            params.add(new HttpParameter("count", count));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(cursor)) {
            params.add(new HttpParameter("cursor", cursor));
        }
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/website_tags/";
        Type type = new TypeToken<BaseAdsListResponse<TwitterWebsiteTag>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(url, params, type);
    }

    @Override
    public BaseAdsResponse<TwitterWebsiteTag> getWebsiteTag(String accountId, boolean withDeleted, String websiteTagId) throws TwitterException {
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/website_tags/" + websiteTagId;
        Type type = new TypeToken<BaseAdsResponse<TwitterWebsiteTag>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(url, null, type, HttpVerb.GET);
    }

    @Override
    public BaseAdsResponse<TwitterWebsiteTag> createWebsiteTag(String accountId, TwitterWebsiteTag.WebsiteTagType websiteTagType) throws TwitterException {
        String url = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/website_tags/";
        Type type = new TypeToken<BaseAdsResponse<TwitterWebsiteTag>>(){}.getType();
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("tag_type", websiteTagType.name()));
        return this.twitterAdsClient.executeHttpRequest(url, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.POST);
    }

    private List<HttpParameter> validateAndCreateParamsForCreateWebEventTag(String name, Integer clickWindow, Integer viewThroughWindow, WebEventTagType type, boolean retargetingEnabled) {
        TwitterAdUtil.ensureNotNull(name, "Name");
        TwitterAdUtil.ensureNotNull(clickWindow, "Click Window");
        TwitterAdUtil.ensureNotNull((Object)type, "Web Event Tag type");
        TwitterAdUtil.ensureNotNull(retargetingEnabled, "Retargeting");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpParameter("name", name));
        params.add(new HttpParameter("click_window", clickWindow));
        if (viewThroughWindow == null) {
            params.add(new HttpParameter("view_through_window", 0));
        } else {
            params.add(new HttpParameter("view_through_window", viewThroughWindow));
        }
        params.add(new HttpParameter("type", type.name()));
        params.add(new HttpParameter("retargeting_enabled", retargetingEnabled));
        return params;
    }

    private List<HttpParameter> validateAndCreateParamsForUpdateWebEventTag(String name, Integer clickWindow, Integer viewThroughWindow, WebEventTagType type, boolean retargetingEnabled) {
        ArrayList params = Lists.newArrayList();
        if (TwitterAdUtil.isNotNullOrEmpty(name)) {
            params.add(new HttpParameter("name", name));
        }
        if (TwitterAdUtil.isNotNull((Object)type)) {
            params.add(new HttpParameter("type", type.name()));
        }
        if (TwitterAdUtil.isNotNull(clickWindow)) {
            params.add(new HttpParameter("click_window", clickWindow));
        }
        if (TwitterAdUtil.isNotNull(viewThroughWindow)) {
            params.add(new HttpParameter("view_through_window", viewThroughWindow));
        }
        params.add(new HttpParameter("retargeting_enabled", retargetingEnabled));
        return params;
    }
}

