/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.BaseAdsResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterCallToActionApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.models.media.TwitterMediaCallToAction;
import twitter4jads.models.video.TwitterCallToActionType;
import twitter4jads.util.TwitterAdUtil;

public class TwitterCallToActionApiImpl
implements TwitterCallToActionApi {
    private final TwitterAdsClient twitterAdsClient;

    public TwitterCallToActionApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public BaseAdsResponse<TwitterMediaCallToAction> create(String accountId, String lineItemId, TwitterCallToActionType twitterCallToActionType, String callToActionUrl) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(lineItemId, "Line Item Id");
        TwitterAdUtil.ensureNotNull(callToActionUrl, "Call To Action Url");
        TwitterAdUtil.ensureNotNull((Object)twitterCallToActionType, "Call To Action Type");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("line_item_id", lineItemId));
        params.add(new HttpParameter("call_to_action", twitterCallToActionType.name()));
        params.add(new HttpParameter("call_to_action_url", callToActionUrl));
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/preroll_call_to_actions";
        HttpResponse httpResponse = this.twitterAdsClient.postRequest(baseUrl, params.toArray(new HttpParameter[params.size()]));
        try {
            Type type = new TypeToken<BaseAdsResponse<TwitterMediaCallToAction>>(){}.getType();
            return TwitterAdUtil.constructBaseAdsResponse(httpResponse, httpResponse.asString(), type);
        }
        catch (IOException e) {
            throw new TwitterException("Failed to parse call to action response.");
        }
    }

    @Override
    public BaseAdsResponse<TwitterMediaCallToAction> update(String accountId, String preRollCTAId, TwitterCallToActionType twitterCallToActionType, String callToActionUrl) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(preRollCTAId, "Pre Roll Call To Action Id");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (twitterCallToActionType != null) {
            params.add(new HttpParameter("call_to_action", twitterCallToActionType.name()));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(callToActionUrl)) {
            params.add(new HttpParameter("call_to_action_url", callToActionUrl));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/preroll_call_to_actions" + "/" + preRollCTAId;
        HttpResponse httpResponse = this.twitterAdsClient.putRequest(baseUrl, params.toArray(new HttpParameter[params.size()]));
        try {
            Type type = new TypeToken<BaseAdsResponse<TwitterMediaCallToAction>>(){}.getType();
            return TwitterAdUtil.constructBaseAdsResponse(httpResponse, httpResponse.asString(), type);
        }
        catch (IOException e) {
            throw new TwitterException("Failed to parse call to action response.");
        }
    }

    @Override
    @Deprecated
    public BaseAdsListResponseIterable<TwitterMediaCallToAction> getByLineItemId(String accountId, String lineItemId, Boolean withDeleted) throws TwitterException {
        TwitterAdUtil.ensureNotNull(lineItemId, "Line Item Id");
        return this.getByLineItemId(accountId, Collections.singleton(lineItemId), withDeleted);
    }

    @Override
    public BaseAdsListResponseIterable<TwitterMediaCallToAction> getByLineItemId(String accountId, Collection<String> lineItemIds, Boolean withDeleted) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotEmpty(lineItemIds, "Line Item Ids");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        TwitterAdUtil.ensureMaxSize(lineItemIds, 200);
        params.add(new HttpParameter("line_item_ids", TwitterAdUtil.getCsv(lineItemIds)));
        if (withDeleted != null) {
            params.add(new HttpParameter("with_deleted", withDeleted));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/preroll_call_to_actions";
        Type type = new TypeToken<BaseAdsListResponse<TwitterMediaCallToAction>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<TwitterMediaCallToAction> getById(String accountId, String callToActionId, Boolean withDeleted) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(callToActionId, "Pre Roll Call To Action Id");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (withDeleted != null) {
            params.add(new HttpParameter("with_deleted", withDeleted));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/preroll_call_to_actions" + "/" + callToActionId;
        HttpResponse httpResponse = this.twitterAdsClient.putRequest(baseUrl, params.toArray(new HttpParameter[params.size()]));
        try {
            Type type = new TypeToken<BaseAdsResponse<TwitterMediaCallToAction>>(){}.getType();
            return TwitterAdUtil.constructBaseAdsResponse(httpResponse, httpResponse.asString(), type);
        }
        catch (IOException e) {
            throw new TwitterException("Failed to parse call to action response.");
        }
    }

    @Override
    public BaseAdsResponse<TwitterMediaCallToAction> delete(String accountId, String callToActionId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(callToActionId, "Pre Roll Call To Action Id");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/preroll_call_to_actions" + "/" + callToActionId;
        Type type = new TypeToken<BaseAdsResponse<TwitterMediaCallToAction>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.DELETE);
    }
}

