/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.impl;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import twitter4jads.BaseAdsListResponse;
import twitter4jads.BaseAdsListResponseIterable;
import twitter4jads.BaseAdsResponse;
import twitter4jads.TwitterAdsClient;
import twitter4jads.api.TwitterScheduledTweetApi;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.models.ScheduledTweet;
import twitter4jads.models.ads.HttpVerb;
import twitter4jads.util.TwitterAdUtil;

public class TwitterScheduledTweetsApiImpl
implements TwitterScheduledTweetApi {
    private final TwitterAdsClient twitterAdsClient;

    public TwitterScheduledTweetsApiImpl(TwitterAdsClient twitterAdsClient) {
        this.twitterAdsClient = twitterAdsClient;
    }

    @Override
    public BaseAdsListResponseIterable<ScheduledTweet> fetch(String accountId, String userId, boolean withDeleted, Integer count, String cursor) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(userId, "userId");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("user_id", userId));
        if (TwitterAdUtil.isNotNullOrEmpty(cursor)) {
            params.add(new HttpParameter("cursor", cursor));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/scheduled_tweets/";
        Type type = new TypeToken<BaseAdsListResponse<ScheduledTweet>>(){}.getType();
        return this.twitterAdsClient.executeHttpListRequest(baseUrl, params, type);
    }

    @Override
    public BaseAdsResponse<ScheduledTweet> fetchScheduledTweetById(String accountId, String scheduledTweetId, boolean withDeleted) throws TwitterException {
        TwitterAdUtil.ensureNotNull(scheduledTweetId, "scheduledTweetId");
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        ArrayList params = new ArrayList();
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/scheduled_tweets/" + scheduledTweetId;
        Type type = new TypeToken<BaseAdsResponse<ScheduledTweet>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.GET);
    }

    @Override
    public BaseAdsResponse<ScheduledTweet> create(String accountId, Date scheduledAt, String text, String userId, String cardURI, List<String> mediaIds, boolean nullCast) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(userId, "userId");
        TwitterAdUtil.ensureNotNull(scheduledAt, "scheduledAt");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        params.add(new HttpParameter("as_user_id", userId));
        if (TwitterAdUtil.isNotNullOrEmpty(cardURI)) {
            params.add(new HttpParameter("card_uri", cardURI));
        }
        params.add(new HttpParameter("scheduled_at", TwitterAdUtil.convertTimeToZuluFormatAndToUTC(scheduledAt.getTime())));
        if (TwitterAdUtil.isNotEmpty(mediaIds)) {
            params.add(new HttpParameter("media_ids", TwitterAdUtil.getCsv(mediaIds)));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(text)) {
            params.add(new HttpParameter("text", text));
        }
        params.add(new HttpParameter("nullcast", nullCast));
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/scheduled_tweets/";
        Type type = new TypeToken<BaseAdsResponse<ScheduledTweet>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.POST);
    }

    @Override
    public BaseAdsResponse<ScheduledTweet> update(String accountId, String scheduledTweetId, Date scheduledAt, String text, String cardURI, List<String> mediaIds) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "accountId");
        TwitterAdUtil.ensureNotNull(scheduledTweetId, "scheduledTweetId");
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (TwitterAdUtil.isNotNullOrEmpty(cardURI)) {
            params.add(new HttpParameter("card_uri", cardURI));
        }
        if (TwitterAdUtil.isNotEmpty(mediaIds)) {
            params.add(new HttpParameter("media_ids", TwitterAdUtil.getCsv(mediaIds)));
        }
        if (TwitterAdUtil.isNotNullOrEmpty(text)) {
            params.add(new HttpParameter("text", text));
        }
        if (scheduledAt != null) {
            params.add(new HttpParameter("scheduled_at", TwitterAdUtil.convertTimeToZuluFormatAndToUTC(scheduledAt.getTime())));
        }
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/scheduled_tweets/" + scheduledTweetId;
        Type type = new TypeToken<BaseAdsResponse<ScheduledTweet>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, params.toArray(new HttpParameter[params.size()]), type, HttpVerb.PUT);
    }

    @Override
    public BaseAdsResponse<ScheduledTweet> delete(String accountId, String scheduledTweetId) throws TwitterException {
        TwitterAdUtil.ensureNotNull(accountId, "Account Id");
        TwitterAdUtil.ensureNotNull(scheduledTweetId, "Tweet Id");
        String baseUrl = this.twitterAdsClient.getBaseAdsAPIUrl() + "5/accounts/" + accountId + "/scheduled_tweets/" + scheduledTweetId;
        Type type = new TypeToken<BaseAdsResponse<ScheduledTweet>>(){}.getType();
        return this.twitterAdsClient.executeHttpRequest(baseUrl, null, type, HttpVerb.DELETE);
    }
}

