/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.async;

import java.util.LinkedList;
import java.util.List;
import twitter4jads.conf.Configuration;
import twitter4jads.internal.async.Dispatcher;
import twitter4jads.internal.async.ExecuteThread;

final class DispatcherImpl
implements Dispatcher {
    private ExecuteThread[] threads;
    private final List<Runnable> q = new LinkedList<Runnable>();
    final Object ticket = new Object();
    private boolean active = true;

    public DispatcherImpl(Configuration conf) {
        this.threads = new ExecuteThread[conf.getAsyncNumThreads()];
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new ExecuteThread("Twitter4J Async Dispatcher", this, i);
            this.threads[i].setDaemon(true);
            this.threads[i].start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (DispatcherImpl.this.active) {
                    DispatcherImpl.this.shutdown();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void invokeLater(Runnable task) {
        Object object = this.q;
        synchronized (object) {
            this.q.add(task);
        }
        object = this.ticket;
        synchronized (object) {
            this.ticket.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable poll() {
        while (this.active) {
            Object object = this.q;
            synchronized (object) {
                Runnable task;
                if (this.q.size() > 0 && (task = this.q.remove(0)) != null) {
                    return task;
                }
            }
            object = this.ticket;
            synchronized (object) {
                try {
                    this.ticket.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        if (this.active) {
            this.active = false;
            for (ExecuteThread thread : this.threads) {
                thread.shutdown();
            }
            Object object = this.ticket;
            synchronized (object) {
                this.ticket.notify();
            }
        }
    }
}

