/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.http;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import twitter4jads.conf.ConfigurationContext;
import twitter4jads.internal.http.HttpClient;
import twitter4jads.internal.http.HttpClientBase;
import twitter4jads.internal.http.HttpClientConfiguration;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.HttpRequest;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.http.HttpResponseCode;
import twitter4jads.internal.http.HttpResponseImpl;
import twitter4jads.internal.http.RequestMethod;
import twitter4jads.internal.logging.Logger;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.util.z_T4JInternalStringUtil;

public class HttpClientImpl
extends HttpClientBase
implements HttpResponseCode,
Serializable {
    private static final Logger logger = Logger.getLogger(HttpClientImpl.class);
    private static final long serialVersionUID = -8819171414069621503L;
    private static final Map<HttpClientConfiguration, HttpClient> instanceMap;

    public HttpClientImpl() {
        super(ConfigurationContext.getInstance());
    }

    public HttpClientImpl(HttpClientConfiguration conf) {
        super(conf);
    }

    public static HttpClient getInstance(HttpClientConfiguration conf) {
        HttpClient client = instanceMap.get(conf);
        if (null == client) {
            client = new HttpClientImpl(conf);
            instanceMap.put(conf, client);
        }
        return client;
    }

    public HttpResponse get(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.GET, url, null, null, null, null));
    }

    public HttpResponse post(String url, HttpParameter[] params) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, params, null, null, null));
    }

    public HttpResponse post(String url, String requestBody) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, null, requestBody, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse request(HttpRequest req) throws TwitterException {
        int retry = this.CONF.getHttpRetryCount() + 1;
        HttpResponse res = null;
        for (int retriedCount = 0; retriedCount < retry; ++retriedCount) {
            block36: {
                int responseCode = -1;
                try {
                    OutputStream os = null;
                    try {
                        HttpURLConnection con = this.getConnection(req.getURL());
                        con.setDoInput(true);
                        this.setHeaders(req, con);
                        con.setRequestMethod(req.getMethod().name());
                        if (req.getMethod() == RequestMethod.POST || req.getMethod() == RequestMethod.PUT) {
                            byte[] bytes;
                            if (HttpParameter.containsFile(req.getParameters())) {
                                String boundary = "----Twitter4J-upload" + System.currentTimeMillis();
                                if (!req.isTonUploadRequest()) {
                                    con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                                }
                                boundary = "--" + boundary;
                                con.setDoOutput(true);
                                os = con.getOutputStream();
                                DataOutputStream out = new DataOutputStream(os);
                                for (HttpParameter param : req.getParameters()) {
                                    if (param.isNonMultipartUpload()) {
                                        out.write(param.getFileData(), 0, param.getFileData().length);
                                        continue;
                                    }
                                    if (param.isFile()) {
                                        this.write(out, boundary + "\r\n");
                                        this.write(out, "Content-Disposition: form-data; name=\"" + param.getName() + "\"; filename=\"" + param.getFile().getName() + "\"\r\n");
                                        this.write(out, "Content-Type: " + param.getContentType() + "\r\n\r\n");
                                        byte[] buff = new byte[1024];
                                        try (BufferedInputStream in = new BufferedInputStream(param.hasFileBody() ? param.getFileBody() : new FileInputStream(param.getFile()));){
                                            int length;
                                            while ((length = in.read(buff)) != -1) {
                                                out.write(buff, 0, length);
                                            }
                                            this.write(out, "\r\n");
                                            continue;
                                        }
                                    }
                                    this.write(out, boundary + "\r\n");
                                    this.write(out, "Content-Disposition: form-data; name=\"" + param.getName() + "\"\r\n");
                                    this.write(out, "Content-Type: text/plain; charset=UTF-8\r\n\r\n");
                                    logger.debug(param.getValue());
                                    out.write(param.getValue().getBytes("UTF-8"));
                                    this.write(out, "\r\n");
                                }
                                if (!req.isTonUploadRequest()) {
                                    this.write(out, boundary + "--\r\n");
                                    this.write(out, "\r\n");
                                }
                            } else if (req.getRequestBody() != null) {
                                con.setRequestProperty("Content-Type", "application/json");
                                String payload = req.getRequestBody();
                                logger.debug("Payload: ", payload);
                                bytes = payload.getBytes("UTF-8");
                                con.setRequestProperty("Content-Length", Integer.toString(bytes.length));
                                con.setDoOutput(true);
                                os = con.getOutputStream();
                                os.write(bytes);
                            } else if (!req.isTonUploadRequest() || req.getParameters() != null) {
                                con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                                String postParam = HttpParameter.encodeParameters(req.getParameters());
                                logger.debug("Post Params: ", postParam);
                                bytes = postParam.getBytes("UTF-8");
                                con.setRequestProperty("Content-Length", Integer.toString(bytes.length));
                                con.setDoOutput(true);
                                os = con.getOutputStream();
                                os.write(bytes);
                            }
                            if (os != null) {
                                os.flush();
                                os.close();
                            }
                        }
                        res = new HttpResponseImpl(con, this.CONF);
                        responseCode = con.getResponseCode();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Response: ");
                            Map<String, List<String>> responseHeaders = con.getHeaderFields();
                            for (String key : responseHeaders.keySet()) {
                                List<String> values = responseHeaders.get(key);
                                for (String value : values) {
                                    if (key != null) {
                                        logger.debug(key + ": " + value);
                                        continue;
                                    }
                                    logger.debug(value);
                                }
                            }
                        }
                        if (responseCode >= 200 && (responseCode == 302 || responseCode == 308 || 300 > responseCode)) break;
                        if (responseCode == 420 || responseCode == 400 || responseCode < 500 || retriedCount == this.CONF.getHttpRetryCount()) {
                            throw new TwitterException(res.asString(), req, res);
                        }
                    }
                    finally {
                        try {
                            os.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException ioe) {
                    if (retriedCount != this.CONF.getHttpRetryCount()) break block36;
                    throw new TwitterException(ioe.getMessage(), ioe, responseCode);
                }
            }
            try {
                if (logger.isDebugEnabled() && res != null) {
                    res.asString();
                }
                logger.debug("Sleeping " + this.CONF.getHttpRetryIntervalSeconds() + " seconds until the next retry.");
                Thread.sleep(this.CONF.getHttpRetryIntervalSeconds() * 1000);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return res;
    }

    private void setHeaders(HttpRequest req, HttpURLConnection connection) {
        String authorizationHeader;
        if (logger.isDebugEnabled()) {
            logger.debug("Request: ");
            logger.debug(req.getMethod().name() + " ", req.getURL());
        }
        if (req.getAuthorization() != null && (authorizationHeader = req.getAuthorization().getAuthorizationHeader(req)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Authorization: ", z_T4JInternalStringUtil.maskString(authorizationHeader));
            }
            connection.addRequestProperty("Authorization", authorizationHeader);
        }
        if (req.getRequestHeaders() != null) {
            for (String key : req.getRequestHeaders().keySet()) {
                connection.addRequestProperty(key, req.getRequestHeaders().get(key));
                logger.debug(key + ": " + req.getRequestHeaders().get(key));
            }
        }
    }

    protected HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection con;
        url = this.ensureHttps(url);
        if (this.isProxyConfigured()) {
            if (this.CONF.getHttpProxyUser() != null && !this.CONF.getHttpProxyUser().equals("")) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Proxy AuthUser: " + this.CONF.getHttpProxyUser());
                    logger.debug("Proxy AuthPassword: " + z_T4JInternalStringUtil.maskString(this.CONF.getHttpProxyPassword()));
                }
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                            return new PasswordAuthentication(HttpClientImpl.this.CONF.getHttpProxyUser(), HttpClientImpl.this.CONF.getHttpProxyPassword().toCharArray());
                        }
                        return null;
                    }
                });
            }
            Proxy proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(this.CONF.getHttpProxyHost(), this.CONF.getHttpProxyPort()));
            if (logger.isDebugEnabled()) {
                logger.debug("Opening proxied connection(" + this.CONF.getHttpProxyHost() + ":" + this.CONF.getHttpProxyPort() + ")");
            }
            con = (HttpURLConnection)new URL(url).openConnection(proxy);
        } else {
            con = (HttpURLConnection)new URL(url).openConnection();
        }
        if (this.CONF.getHttpConnectionTimeout() > 0) {
            con.setConnectTimeout(this.CONF.getHttpConnectionTimeout());
        }
        if (this.CONF.getHttpReadTimeout() > 0) {
            con.setReadTimeout(this.CONF.getHttpReadTimeout());
        }
        con.setInstanceFollowRedirects(false);
        return con;
    }

    private String ensureHttps(String url) {
        if (url.startsWith("http://")) {
            logger.error("Following url was still using (http) protocol: " + url);
            url = "https://" + url.substring("http://".length());
        }
        return url;
    }

    static {
        if (ConfigurationContext.getInstance().isDalvik()) {
            System.setProperty("http.keepAlive", "false");
        }
        instanceMap = new HashMap<HttpClientConfiguration, HttpClient>(1);
    }
}

