/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.http;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import twitter4jads.auth.Authorization;
import twitter4jads.conf.ConfigurationContext;
import twitter4jads.internal.http.HttpClient;
import twitter4jads.internal.http.HttpClientFactory;
import twitter4jads.internal.http.HttpClientWrapperConfiguration;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.HttpRequest;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.http.HttpResponseEvent;
import twitter4jads.internal.http.HttpResponseListener;
import twitter4jads.internal.http.RequestMethod;
import twitter4jads.internal.models4j.TwitterException;

public final class HttpClientWrapper
implements Serializable {
    private final HttpClientWrapperConfiguration wrapperConf;
    private HttpClient http;
    private final Map<String, String> requestHeaders;
    private static final long serialVersionUID = -6511977105603119379L;
    private HttpResponseListener httpResponseListener;

    public HttpClientWrapper(HttpClientWrapperConfiguration wrapperConf) {
        this.wrapperConf = wrapperConf;
        this.requestHeaders = wrapperConf.getRequestHeaders();
        this.http = HttpClientFactory.getInstance(wrapperConf);
    }

    public HttpClientWrapper() {
        this.wrapperConf = ConfigurationContext.getInstance();
        this.requestHeaders = this.wrapperConf.getRequestHeaders();
        this.http = HttpClientFactory.getInstance(this.wrapperConf);
    }

    public void shutdown() {
        this.http.shutdown();
    }

    private HttpResponse request(HttpRequest req) throws TwitterException {
        HttpResponse res;
        try {
            res = this.http.request(req);
            if (this.httpResponseListener != null) {
                this.httpResponseListener.httpResponseReceived(new HttpResponseEvent(req, res, null));
            }
        }
        catch (TwitterException te) {
            if (this.httpResponseListener != null) {
                this.httpResponseListener.httpResponseReceived(new HttpResponseEvent(req, null, te));
            }
            throw te;
        }
        return res;
    }

    public void setHttpResponseListener(HttpResponseListener listener) {
        this.httpResponseListener = listener;
    }

    public HttpResponse get(String url, HttpParameter[] parameters, Authorization authorization) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.GET, url, parameters, null, authorization, this.requestHeaders));
    }

    public HttpResponse get(String url, Authorization authorization) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.GET, url, null, null, authorization, this.requestHeaders));
    }

    public HttpResponse post(String url, HttpParameter[] parameters, Authorization authorization) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, parameters, null, authorization, this.requestHeaders));
    }

    public HttpResponse post(String url, String requestBody, Authorization authorization) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, null, requestBody, authorization, this.requestHeaders));
    }

    public HttpResponse putWithCustomHeaders(String url, HttpParameter[] parameters, Authorization authorization, Map<String, String> customRequestHeaders, boolean isTonUpload) throws TwitterException {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (MapUtils.isNotEmpty(this.requestHeaders)) {
            headers.putAll(this.requestHeaders);
        }
        headers.putAll(customRequestHeaders);
        HttpRequest req = new HttpRequest(RequestMethod.PUT, url, parameters, null, authorization, headers);
        req.setTonUploadRequest(isTonUpload);
        return this.request(req);
    }

    public HttpResponse postWithCustomHeaders(String url, HttpParameter[] parameters, Authorization authorization, Map<String, String> customRequestHeaders, boolean isTonUpload) throws TwitterException {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (MapUtils.isNotEmpty(this.requestHeaders)) {
            headers.putAll(this.requestHeaders);
        }
        headers.putAll(customRequestHeaders);
        HttpRequest req = new HttpRequest(RequestMethod.POST, url, parameters, null, authorization, headers);
        req.setTonUploadRequest(isTonUpload);
        return this.request(req);
    }

    public HttpResponse post(String url, HttpParameter[] parameters) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, parameters, null, null, this.requestHeaders));
    }

    public HttpResponse post(String url, HttpParameter[] parameters, Map<String, String> requestHeaders) throws TwitterException {
        HashMap<String, String> headers = new HashMap<String, String>(this.requestHeaders);
        if (requestHeaders != null) {
            headers.putAll(requestHeaders);
        }
        return this.request(new HttpRequest(RequestMethod.POST, url, parameters, null, null, headers));
    }

    public HttpResponse post(String url, Authorization authorization) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, null, null, authorization, this.requestHeaders));
    }

    public HttpResponse postBatchRequest(String url, HttpParameter[] parameters, Authorization authorization, String requestBody) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, parameters, requestBody, authorization, this.requestHeaders));
    }

    public HttpResponse post(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, null, null, null, this.requestHeaders));
    }

    public HttpResponse delete(String url, HttpParameter[] parameters, Authorization authorization) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, parameters, null, authorization, this.requestHeaders));
    }

    public HttpResponse delete(String url, HttpParameter[] parameters) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, parameters, null, null, this.requestHeaders));
    }

    public HttpResponse delete(String url, Authorization authorization) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, null, null, authorization, this.requestHeaders));
    }

    public HttpResponse delete(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, null, null, null, this.requestHeaders));
    }

    public HttpResponse head(String url, HttpParameter[] parameters, Authorization authorization) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.HEAD, url, parameters, null, authorization, this.requestHeaders));
    }

    public HttpResponse head(String url, HttpParameter[] parameters) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.HEAD, url, parameters, null, null, this.requestHeaders));
    }

    public HttpResponse head(String url, Authorization authorization) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.HEAD, url, null, null, authorization, this.requestHeaders));
    }

    public HttpResponse head(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.HEAD, url, null, null, null, this.requestHeaders));
    }

    public HttpResponse put(String url, HttpParameter[] parameters, Authorization authorization) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, parameters, null, authorization, this.requestHeaders));
    }

    public HttpResponse put(String url, HttpParameter[] parameters) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, parameters, null, null, this.requestHeaders));
    }

    public HttpResponse put(String url, Authorization authorization) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, null, null, authorization, this.requestHeaders));
    }

    public HttpResponse put(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, null, null, null, this.requestHeaders));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientWrapper that = (HttpClientWrapper)o;
        if (!this.http.equals(that.http)) {
            return false;
        }
        if (!this.requestHeaders.equals(that.requestHeaders)) {
            return false;
        }
        return this.wrapperConf.equals(that.wrapperConf);
    }

    public int hashCode() {
        int result = this.wrapperConf.hashCode();
        result = 31 * result + this.http.hashCode();
        result = 31 * result + this.requestHeaders.hashCode();
        return result;
    }
}

