/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.http;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import twitter4jads.auth.Authorization;
import twitter4jads.internal.http.HttpParameter;
import twitter4jads.internal.http.RequestMethod;

public final class HttpRequest
implements Serializable {
    private final RequestMethod method;
    private final String url;
    private final HttpParameter[] parameters;
    private final String requestBody;
    private final Authorization authorization;
    private Map<String, String> requestHeaders;
    private boolean tonUploadRequest;
    private static final long serialVersionUID = -3463594029098858381L;
    private static final HttpParameter[] NULL_PARAMETERS = new HttpParameter[0];

    public HttpRequest(RequestMethod method, String url, HttpParameter[] parameters, String requestBody, Authorization authorization, Map<String, String> requestHeaders) {
        this.method = method;
        if (method != RequestMethod.POST && method != RequestMethod.PUT && parameters != null && parameters.length != 0) {
            this.url = url.contains("?") ? url + "&" + HttpParameter.encodeParameters(parameters) : url + "?" + HttpParameter.encodeParameters(parameters);
            this.parameters = NULL_PARAMETERS;
        } else {
            this.url = url;
            this.parameters = parameters;
        }
        this.requestBody = requestBody;
        this.authorization = authorization;
        this.requestHeaders = requestHeaders;
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public HttpParameter[] getParameters() {
        return this.parameters;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public String getURL() {
        return this.url;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public boolean isTonUploadRequest() {
        return this.tonUploadRequest;
    }

    public void setTonUploadRequest(boolean tonUploadRequest) {
        this.tonUploadRequest = tonUploadRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequest that = (HttpRequest)o;
        if (this.authorization != null ? !this.authorization.equals(that.authorization) : that.authorization != null) {
            return false;
        }
        if (!Arrays.equals(this.parameters, that.parameters)) {
            return false;
        }
        if (this.requestHeaders != null ? !this.requestHeaders.equals(that.requestHeaders) : that.requestHeaders != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals((Object)that.method) : that.method != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.requestBody != null ? !this.requestBody.equals(that.requestBody) : that.requestBody != null);
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? Arrays.hashCode(this.parameters) : 0);
        result = 31 * result + (this.authorization != null ? this.authorization.hashCode() : 0);
        result = 31 * result + (this.requestHeaders != null ? this.requestHeaders.hashCode() : 0);
        result = 31 * result + (this.requestBody != null ? this.requestBody.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "HttpRequest{requestMethod=" + (Object)((Object)this.method) + ", url='" + this.url + '\'' + ", postParams=" + (this.parameters == null ? null : Arrays.asList(this.parameters)) + ", authentication=" + this.authorization + ", requestHeaders=" + this.requestHeaders + ", requestBody=" + this.requestBody + '}';
    }
}

