/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import twitter4jads.internal.http.HttpClientConfiguration;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.http.StreamingGZIPInputStream;

public class HttpResponseImpl
extends HttpResponse {
    private HttpURLConnection con;

    HttpResponseImpl(HttpURLConnection con, HttpClientConfiguration conf) throws IOException {
        super(conf);
        this.con = con;
        this.statusCode = con.getResponseCode();
        this.is = con.getErrorStream();
        if (null == this.is) {
            this.is = con.getInputStream();
        }
        if (this.is != null && "gzip".equals(con.getContentEncoding())) {
            this.is = new StreamingGZIPInputStream(this.is);
        }
    }

    HttpResponseImpl(String content) {
        this.responseAsString = content;
    }

    @Override
    public String getResponseHeader(String name) {
        return this.con.getHeaderField(name);
    }

    @Override
    public Map<String, List<String>> getResponseHeaderFields() {
        return this.con.getHeaderFields();
    }

    @Override
    public void disconnect() {
        this.con.disconnect();
    }
}

