/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.json;

import java.io.Serializable;
import twitter4jads.conf.Configuration;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.json.DataObjectFactoryUtil;
import twitter4jads.internal.json.LocationJSONImpl;
import twitter4jads.internal.json.TimeZoneJSONImpl;
import twitter4jads.internal.json.TwitterResponseImpl;
import twitter4jads.internal.json.z_T4JInternalParseUtil;
import twitter4jads.internal.models4j.AccountSettings;
import twitter4jads.internal.models4j.Location;
import twitter4jads.internal.models4j.TimeZone;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.org.json.JSONArray;
import twitter4jads.internal.org.json.JSONException;
import twitter4jads.internal.org.json.JSONObject;

class AccountSettingsJSONImpl
extends TwitterResponseImpl
implements AccountSettings,
Serializable {
    private static final long serialVersionUID = 7983363611306383416L;
    private final boolean SLEEP_TIME_ENABLED;
    private final String SLEEP_START_TIME;
    private final String SLEEP_END_TIME;
    private final Location[] TREND_LOCATION;
    private final boolean GEO_ENABLED;
    private final String LANGUAGE;
    private final TimeZone TIMEZONE;
    private final boolean ALWAYS_USE_HTTPS;
    private final boolean DISCOVERABLE_BY_EMAIL;

    private AccountSettingsJSONImpl(HttpResponse res, JSONObject json) throws TwitterException {
        super(res);
        try {
            JSONObject sleepTime = json.getJSONObject("sleep_time");
            this.SLEEP_TIME_ENABLED = z_T4JInternalParseUtil.getBoolean("enabled", sleepTime);
            this.SLEEP_START_TIME = sleepTime.getString("start_time");
            this.SLEEP_END_TIME = sleepTime.getString("end_time");
            if (json.isNull("trend_location")) {
                this.TREND_LOCATION = new Location[0];
            } else {
                JSONArray locations = json.getJSONArray("trend_location");
                this.TREND_LOCATION = new Location[locations.length()];
                for (int i = 0; i < locations.length(); ++i) {
                    this.TREND_LOCATION[i] = new LocationJSONImpl(locations.getJSONObject(i));
                }
            }
            this.GEO_ENABLED = z_T4JInternalParseUtil.getBoolean("geo_enabled", json);
            this.LANGUAGE = json.getString("language");
            this.ALWAYS_USE_HTTPS = z_T4JInternalParseUtil.getBoolean("always_use_https", json);
            this.DISCOVERABLE_BY_EMAIL = z_T4JInternalParseUtil.getBoolean("discoverable_by_email", json);
            this.TIMEZONE = new TimeZoneJSONImpl(json.getJSONObject("time_zone"));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    AccountSettingsJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        this(res, res.asJSONObject());
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, res.asJSONObject());
        }
    }

    AccountSettingsJSONImpl(JSONObject json) throws TwitterException {
        this(null, json);
    }

    @Override
    public boolean isSleepTimeEnabled() {
        return this.SLEEP_TIME_ENABLED;
    }

    @Override
    public String getSleepStartTime() {
        return this.SLEEP_START_TIME;
    }

    @Override
    public String getSleepEndTime() {
        return this.SLEEP_END_TIME;
    }

    @Override
    public Location[] getTrendLocations() {
        return this.TREND_LOCATION;
    }

    @Override
    public boolean isGeoEnabled() {
        return this.GEO_ENABLED;
    }

    @Override
    public boolean isDiscoverableByEmail() {
        return this.DISCOVERABLE_BY_EMAIL;
    }

    @Override
    public boolean isAlwaysUseHttps() {
        return this.ALWAYS_USE_HTTPS;
    }

    @Override
    public String getLanguage() {
        return this.LANGUAGE;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.TIMEZONE;
    }
}

