/*
 * Decompiled with CFR 0.152.
 */
package twitter4jads.internal.json;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import twitter4jads.conf.Configuration;
import twitter4jads.internal.http.HttpResponse;
import twitter4jads.internal.json.DataObjectFactoryUtil;
import twitter4jads.internal.json.HTMLEntity;
import twitter4jads.internal.json.HashtagEntityJSONImpl;
import twitter4jads.internal.json.MediaEntityJSONImpl;
import twitter4jads.internal.json.ResponseListImpl;
import twitter4jads.internal.json.TwitterResponseImpl;
import twitter4jads.internal.json.URLEntityJSONImpl;
import twitter4jads.internal.json.UserJSONImpl;
import twitter4jads.internal.json.UserMentionEntityJSONImpl;
import twitter4jads.internal.json.z_T4JInternalParseUtil;
import twitter4jads.internal.models4j.DirectMessage;
import twitter4jads.internal.models4j.HashtagEntity;
import twitter4jads.internal.models4j.MediaEntity;
import twitter4jads.internal.models4j.ResponseList;
import twitter4jads.internal.models4j.TwitterException;
import twitter4jads.internal.models4j.URLEntity;
import twitter4jads.internal.models4j.User;
import twitter4jads.internal.models4j.UserMentionEntity;
import twitter4jads.internal.org.json.JSONArray;
import twitter4jads.internal.org.json.JSONException;
import twitter4jads.internal.org.json.JSONObject;

public final class DirectMessageJSONImpl
extends TwitterResponseImpl
implements DirectMessage,
Serializable {
    private static final long serialVersionUID = -7104233663827757577L;
    private long id;
    private String idStr;
    private String actualText;
    private String text;
    private long senderId;
    private long recipientId;
    private Date createdAt;
    private String senderScreenName;
    private String recipientScreenName;
    private UserMentionEntity[] userMentionEntities;
    private URLEntity[] urlEntities;
    private HashtagEntity[] hashtagEntities;
    private MediaEntity[] mediaEntities;
    private MediaEntity[] extendedMediaEntities;
    private User sender;
    private User recipient;

    DirectMessageJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        this.init(this.getJSONObject());
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, this.getJSONObject());
        }
    }

    DirectMessageJSONImpl() {
    }

    public DirectMessageJSONImpl(JSONObject json) throws TwitterException {
        super(json);
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        this.id = z_T4JInternalParseUtil.getLong("id", json);
        this.idStr = z_T4JInternalParseUtil.getRawString("id_str", json);
        this.senderId = z_T4JInternalParseUtil.getLong("sender_id", json);
        this.recipientId = z_T4JInternalParseUtil.getLong("recipient_id", json);
        this.createdAt = z_T4JInternalParseUtil.getDate("created_at", json);
        this.senderScreenName = z_T4JInternalParseUtil.getUnescapedString("sender_screen_name", json);
        this.recipientScreenName = z_T4JInternalParseUtil.getUnescapedString("recipient_screen_name", json);
        try {
            JSONArray mediaArray;
            int i;
            int len;
            JSONObject entities;
            this.sender = new UserJSONImpl(json.getJSONObject("sender"));
            this.recipient = new UserJSONImpl(json.getJSONObject("recipient"));
            if (!json.isNull("entities")) {
                entities = json.getJSONObject("entities");
                if (!entities.isNull("user_mentions")) {
                    JSONArray userMentionsArray = entities.getJSONArray("user_mentions");
                    len = userMentionsArray.length();
                    this.userMentionEntities = new UserMentionEntity[len];
                    for (i = 0; i < len; ++i) {
                        this.userMentionEntities[i] = new UserMentionEntityJSONImpl(userMentionsArray.getJSONObject(i));
                    }
                }
                if (!entities.isNull("urls")) {
                    JSONArray urlsArray = entities.getJSONArray("urls");
                    len = urlsArray.length();
                    this.urlEntities = new URLEntity[len];
                    for (i = 0; i < len; ++i) {
                        this.urlEntities[i] = new URLEntityJSONImpl(urlsArray.getJSONObject(i));
                    }
                }
                if (!entities.isNull("hashtags")) {
                    JSONArray hashtagsArray = entities.getJSONArray("hashtags");
                    len = hashtagsArray.length();
                    this.hashtagEntities = new HashtagEntity[len];
                    for (i = 0; i < len; ++i) {
                        this.hashtagEntities[i] = new HashtagEntityJSONImpl(hashtagsArray.getJSONObject(i));
                    }
                }
                if (!entities.isNull("media")) {
                    mediaArray = entities.getJSONArray("media");
                    len = mediaArray.length();
                    this.mediaEntities = new MediaEntity[len];
                    for (i = 0; i < len; ++i) {
                        this.mediaEntities[i] = new MediaEntityJSONImpl(mediaArray.getJSONObject(i));
                    }
                }
            }
            if (!json.isNull("extended_entities") && !(entities = json.getJSONObject("extended_entities")).isNull("media")) {
                mediaArray = entities.getJSONArray("media");
                len = mediaArray.length();
                this.extendedMediaEntities = new MediaEntity[len];
                for (i = 0; i < len; ++i) {
                    this.extendedMediaEntities[i] = new MediaEntityJSONImpl(mediaArray.getJSONObject(i));
                }
            }
            this.userMentionEntities = this.userMentionEntities == null ? new UserMentionEntity[]{} : this.userMentionEntities;
            this.urlEntities = this.urlEntities == null ? new URLEntity[]{} : this.urlEntities;
            this.hashtagEntities = this.hashtagEntities == null ? new HashtagEntity[]{} : this.hashtagEntities;
            this.mediaEntities = this.mediaEntities == null ? new MediaEntity[]{} : this.mediaEntities;
            this.extendedMediaEntities = this.extendedMediaEntities == null ? this.mediaEntities : this.extendedMediaEntities;
            this.actualText = json.getString("text");
            this.text = HTMLEntity.unescapeAndSlideEntityIncdices(this.actualText, this.userMentionEntities, this.urlEntities, this.hashtagEntities, this.mediaEntities);
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getText() {
        return this.actualText;
    }

    @Override
    public String getUnEscapedText() {
        return this.text;
    }

    @Override
    public long getSenderId() {
        return this.senderId;
    }

    @Override
    public long getRecipientId() {
        return this.recipientId;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getSenderScreenName() {
        return this.senderScreenName;
    }

    @Override
    public String getRecipientScreenName() {
        return this.recipientScreenName;
    }

    @Override
    public User getSender() {
        return this.sender;
    }

    @Override
    public User getRecipient() {
        return this.recipient;
    }

    @Override
    public UserMentionEntity[] getUserMentionEntities() {
        return this.userMentionEntities;
    }

    @Override
    public URLEntity[] getURLEntities() {
        return this.urlEntities;
    }

    @Override
    public HashtagEntity[] getHashtagEntities() {
        return this.hashtagEntities;
    }

    @Override
    public MediaEntity[] getMediaEntities() {
        return this.mediaEntities;
    }

    @Override
    public MediaEntity[] getExtendedMediaEntities() {
        return this.extendedMediaEntities;
    }

    static ResponseList<DirectMessage> createDirectMessageList(HttpResponse res, Configuration conf) throws TwitterException {
        try {
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONArray list = res.asJSONArray();
            int size = list.length();
            ResponseListImpl<DirectMessage> directMessages = new ResponseListImpl<DirectMessage>(size, res);
            for (int i = 0; i < size; ++i) {
                JSONObject json = list.getJSONObject(i);
                DirectMessageJSONImpl directMessage = new DirectMessageJSONImpl(json);
                directMessages.add(directMessage);
                if (!conf.isJSONStoreEnabled()) continue;
                DataObjectFactoryUtil.registerJSONObject(directMessage, json);
            }
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(directMessages, list);
            }
            return directMessages;
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
        catch (TwitterException te) {
            throw te;
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof DirectMessage && ((DirectMessage)obj).getId() == this.id;
    }

    @Override
    public String getIdStr() {
        return this.idStr;
    }

    public String toString() {
        return "DirectMessageJSONImpl{id=" + this.id + ", idStr='" + this.idStr + '\'' + ", actualText='" + this.actualText + '\'' + ", text='" + this.text + '\'' + ", senderId=" + this.senderId + ", recipientId=" + this.recipientId + ", createdAt=" + this.createdAt + ", senderScreenName='" + this.senderScreenName + '\'' + ", recipientScreenName='" + this.recipientScreenName + '\'' + ", userMentionEntities=" + Arrays.toString(this.userMentionEntities) + ", urlEntities=" + Arrays.toString(this.urlEntities) + ", hashtagEntities=" + Arrays.toString(this.hashtagEntities) + ", mediaEntities=" + Arrays.toString(this.mediaEntities) + ", sender=" + this.sender + ", recipient=" + this.recipient + '}';
    }
}

